package io.wispforest.accessories.mixin.client;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.wispforest.accessories.api.AccessoriesStorageLookup;
import io.wispforest.accessories.api.caching.ItemStackBasedPredicate;
import io.wispforest.accessories.api.slot.SlotPathWithStack;
import io.wispforest.accessories.pond.AccessoriesRenderStateAPI;
import net.minecraft.class_10042;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_1746;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3882;
import net.minecraft.class_4587;
import net.minecraft.class_583;
import net.minecraft.class_811;
import net.minecraft.class_976;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(class_976.class)
public abstract class CustomHeadLayerMixin<S extends class_10042, M extends class_583<S> & class_3882> {

    //TODO: FIGURE OUT WHY ARCH LOOM DON'T REMAP WRAP METHOD
    @WrapMethod(method = {
            "submit(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;ILnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;FF)V",      // Mojmap
            "method_17159(Lnet/minecraft/class_4587;Lnet/minecraft/class_11659;ILnet/minecraft/class_10042;FF)V",                                                                             // Yarn Interm.
            "render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/command/OrderedRenderCommandQueue;ILnet/minecraft/client/render/entity/state/LivingEntityRenderState;FF)V" // Yarn
    })
    private void accessories$adjustHeadItem(class_4587 poseStack, class_11659 submitNodeCollector, int i, S livingEntityRenderState, float f, float g, Operation<Void> original) {
        class_10444 prevState = null;

        if (livingEntityRenderState instanceof AccessoriesRenderStateAPI extension) {
            var lookup = extension.getStorageLookup();

            if (lookup != null) {
                var ref = lookup.getEquipped(ItemStackBasedPredicate.ofClass(class_1746.class))
                        .stream()
                        .filter(entry -> entry.path().slotName().equals("hat"))
                        .findFirst()
                        .orElse(null);

                if (ref != null) {
                    var stack = ref.stack();
                    prevState = livingEntityRenderState.field_53467;

                    var alternativeRenderState = new class_10444();

                    class_310.method_1551().method_65386()
                            .method_65598(alternativeRenderState, stack, class_811.field_4316, class_310.method_1551().field_1687, null, extension.getEntityUUIDForState().hashCode() + 5);

                    ((LivingEntityRenderStateAccessor) livingEntityRenderState).accessories$headItem(alternativeRenderState);
                }
            }
        }

        original.call(poseStack, submitNodeCollector, i, livingEntityRenderState, f, g);

        if (prevState != null) ((LivingEntityRenderStateAccessor) livingEntityRenderState).accessories$headItem(prevState);
    }
}
