package io.wispforest.accessories.mixin.client;

import I;
import io.wispforest.accessories.pond.ScissorStackManipulation;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_332;
import net.minecraft.class_8030;

@Mixin(class_332.class)
public abstract class GuiGraphicsMixin implements ScissorStackManipulation {

    @Shadow @Final public class_332.class_8214 scissorStack;

    @Override
    public void accessories$renderWithoutEntries(Runnable runnable, @Nullable Integer levels) {
        ((ScissorStackManipulation) this.scissorStack).accessories$renderWithoutEntries(runnable, levels);
    }

    @Mixin(class_332.class_8214.class)
    public abstract static class ScissorStackMixin implements ScissorStackManipulation {
        @Shadow @Final private Deque<class_8030> stack;

        @Override
        public void accessories$renderWithoutEntries(Runnable runnable, @Nullable Integer levels) {
            Deque<class_8030> stackCopy = new ArrayDeque<>(stack);

            if (levels != null) {
                for (var i = 0; i < levels; i++) {
                    stack.pollLast();
                }

                runnable.run();

                stack.clear();
            } else {
                stack.clear();

                runnable.run();
            }

            stack.addAll(stackCopy);
        }
    }
}
