package io.wispforest.accessories.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.wispforest.accessories.api.AccessoriesStorageLookup;
import io.wispforest.accessories.api.equip.EquipmentChecking;
import io.wispforest.accessories.api.slot.SlotPathWithStack;
import io.wispforest.accessories.pond.AccessoriesRenderStateAPI;
import io.wispforest.accessories.pond.WingsLayerExtension;
import java.util.List;
import net.minecraft.class_10034;
import net.minecraft.class_10186;
import net.minecraft.class_10192;
import net.minecraft.class_10197;
import net.minecraft.class_11659;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_583;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_979;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_979.class)
public abstract class WingsLayerMixin<S extends class_10034, M extends class_583<S>> implements WingsLayerExtension<S> {


    @Shadow @Final private class_10197 equipmentRenderer;

    @Shadow
    public abstract void submit(class_4587 arg, class_11659 arg2, int i, S arg3, float f, float g);

    @Override
    public void renderStack(class_1799 stack, class_4587 poseStack, class_11659 submitNodeCollector, int i, S humanoidRenderState) {
        var prevItem = humanoidRenderState.field_53418;

        humanoidRenderState.field_53418 = stack;

        this.submit(poseStack, submitNodeCollector, i, humanoidRenderState, humanoidRenderState.field_53447, humanoidRenderState.field_53448);

        humanoidRenderState.field_53418 = prevItem;
    }

    @WrapOperation(method = "submit(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;ILnet/minecraft/client/renderer/entity/state/HumanoidRenderState;FF)V",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;get(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;"))
    private Object accessories$adjustGliderItemstack(class_1799 instance, class_9331 dataComponentType, Operation<Object> original, @Local(argsOnly = true) S humanoidRenderState, @Local(ordinal = 0) LocalRef<class_1799> stack) {
        if (humanoidRenderState instanceof AccessoriesRenderStateAPI extension) {
            var lookup = extension.getStorageLookup();

            if (lookup != null) {
                var gliderItem = lookup.getFirstEquipped(stack1 -> {
                    var equippable = stack1.method_58694(class_9334.field_54196);

                    if (equippable != null && equippable.comp_3176().isPresent()) {
                        var list = ((EquipmentLayerRendererAccessor) this.equipmentRenderer).accessories$equipmentAssetManager()
                                .method_64087(equippable.comp_3176().get())
                                .method_63996(class_10186.class_10190.field_54127);

                        return !list.isEmpty();
                    }

                    return false;
                }, EquipmentChecking.COSMETICALLY_OVERRIDABLE);

                if (gliderItem != null) {
                    stack.set(gliderItem.stack());

                    instance = gliderItem.stack();
                }
            }
        }

        return original.call(instance, dataComponentType);
    }
}
