package io.wispforest.accessories.networking;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.mixin.EntityTrackerAccessor;
import io.wispforest.accessories.mixin.ServerChunkLoadingManagerAccessor;
import io.wispforest.accessories.networking.client.*;
import io.wispforest.accessories.networking.holder.SyncOptionChange;
import io.wispforest.accessories.networking.server.ContainerClose;
import io.wispforest.accessories.networking.server.NukeAccessories;
import io.wispforest.accessories.networking.server.ScreenOpen;
import io.wispforest.accessories.networking.server.SyncCosmeticToggle;
import io.wispforest.owo.network.ClientAccess;
import io.wispforest.owo.network.OwoNetChannel;
import io.wispforest.owo.network.ServerAccess;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_5629;
import net.minecraft.server.MinecraftServer;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class AccessoriesNetworking {

    public static final OwoNetChannel CHANNEL = OwoNetChannel.create(Accessories.of("main"));

    public static void init() {
        CHANNEL.registerServerbound(ScreenOpen.class, ScreenOpen.ENDEC, serverHandler(ScreenOpen::handlePacket));
        CHANNEL.registerServerbound(NukeAccessories.class, NukeAccessories.ENDEC, serverHandler(NukeAccessories::handlePacket));
        CHANNEL.registerServerbound(SyncCosmeticToggle.class, SyncCosmeticToggle.ENDEC, serverHandler(SyncCosmeticToggle::handlePacket));

        CHANNEL.registerServerbound(SyncOptionChange.class, SyncOptionChange.ENDEC, serverHandler(SyncOptionChange::handlePacket));

        CHANNEL.registerServerbound(ContainerClose.class, ContainerClose.ENDEC, serverHandler(ContainerClose::handlePacket));

        //--

        CHANNEL.registerClientboundDeferred(SyncEntireContainer.class, SyncEntireContainer.ENDEC);
        CHANNEL.registerClientboundDeferred(SyncContainerData.class, SyncContainerData.ENDEC);
        CHANNEL.registerClientboundDeferred(SyncPlayerOptions.class, SyncPlayerOptions.ENDEC);
        CHANNEL.registerClientboundDeferred(AccessoryBreak.class, AccessoryBreak.ENDEC);
        CHANNEL.registerClientboundDeferred(InvalidateEntityCache.class, InvalidateEntityCache.ENDEC);
        CHANNEL.registerClientboundDeferred(ScreenVariantPing.class, ScreenVariantPing.ENDEC);

        CHANNEL.registerClientboundDeferred(SyncOptionChange.class, SyncOptionChange.ENDEC);
    }

    //@Environment(EnvType.CLIENT)
    public static void initClient() {
        CHANNEL.registerClientbound(SyncEntireContainer.class, SyncEntireContainer.ENDEC, clientHandler(SyncEntireContainer::handlePacket));
        CHANNEL.registerClientbound(SyncContainerData.class, SyncContainerData.ENDEC, clientHandler(SyncContainerData::handlePacket));
        CHANNEL.registerClientbound(SyncPlayerOptions.class, SyncPlayerOptions.ENDEC, clientHandler(SyncPlayerOptions::handlePacket));
        CHANNEL.registerClientbound(AccessoryBreak.class, AccessoryBreak.ENDEC, clientHandler(AccessoryBreak::handlePacket));
        CHANNEL.registerClientbound(InvalidateEntityCache.class, InvalidateEntityCache.ENDEC, clientHandler(InvalidateEntityCache::handlePacket));
        CHANNEL.registerClientbound(ScreenVariantPing.class, ScreenVariantPing.ENDEC, clientHandler(ScreenVariantPing::handlePacket));

        CHANNEL.registerClientbound(SyncOptionChange.class, SyncOptionChange.ENDEC, clientHandler(SyncOptionChange::handlePacket));
    }

    //@Environment(EnvType.CLIENT)
    public static <R extends Record> OwoNetChannel.ChannelHandler<R, ClientAccess> clientHandler(BiConsumer<R, class_1657> consumer) {
        return (r, access) -> consumer.accept(r, access.player());
    }

    public static <R extends Record> OwoNetChannel.ChannelHandler<R, ServerAccess> serverHandler(BiConsumer<R, class_1657> consumer) {
        return (r, access) -> consumer.accept(r, access.player());
    }

    //@Environment(EnvType.CLIENT)
    public static <R extends Record> void sendToServer(R packet) {
        CHANNEL.clientHandle().send(packet);
    }

    public static <R extends Record> void sendToPlayer(class_3222 player, R packet) {
        CHANNEL.serverHandle(player).send(packet);
    }

    public static <R extends Record> void sendToAllPlayers(MinecraftServer server, R packet){
        for (var player : server.method_3760().method_14571()) sendToPlayer(player, packet);
    }

    public static <R extends Record> void sendToTrackingAndSelf(class_1297 entity, R packet) {
        var targets = new ArrayList<class_3222>();

        if (entity.method_73183().method_8398() instanceof class_3215 chunkCache) {
            var chunkLoadingManager = chunkCache.field_17254;
            var tracker = ((ServerChunkLoadingManagerAccessor) chunkLoadingManager).accessories$getEntityMap().get(entity.method_5628());

            // return an immutable collection to guard against accidental removals.
            if (tracker != null) {
                targets.addAll(
                        tracker.accessories$getSeenBy().stream()
                                .map(class_5629::method_32311)
                                .collect(Collectors.toUnmodifiableSet())
                );
            }
        }

        if (entity instanceof class_3222 serverPlayer) targets.add(serverPlayer);

        CHANNEL.serverHandle(targets).send(packet);
    }
}
