package io.wispforest.accessories.networking.client;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public record AccessoryBreak(int entityId, String slotName, int slotIndex) {

    public static StructEndec<AccessoryBreak> ENDEC = StructEndecBuilder.of(
            Endec.VAR_INT.fieldOf("entityId", AccessoryBreak::entityId),
            Endec.STRING.fieldOf("slotName", AccessoryBreak::slotName),
            Endec.VAR_INT.fieldOf("slotIndex", AccessoryBreak::slotIndex),
            AccessoryBreak::new
    );

    public static AccessoryBreak of(SlotReference slotReference) {
        return new AccessoryBreak(slotReference.entity().method_5628(), slotReference.slotName(), slotReference.index());
    }

    //@Environment(EnvType.CLIENT)
    public static void handlePacket(AccessoryBreak packet, class_1657 player) {
        var entity = player.method_73183().method_8469(packet.entityId());

        if(!(entity instanceof class_1309 livingEntity)) {
            throw new IllegalStateException("Unable to handle a Break call due to the passed entity id not corresponding to a LivingEntity!");
        }

        var slotReference = SlotReference.of(livingEntity, packet.slotName(), packet.slotIndex());

        var capability = livingEntity.accessoriesCapability();

        var container = capability.getContainer(slotReference.type());

        var stack = container.getAccessories().method_5438(slotReference.index());

        var accessory = AccessoryRegistry.getAccessoryOrDefault(stack);

        if(accessory != null) accessory.onBreak(stack, slotReference);
    }
}
