package io.wispforest.accessories.networking.client;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.impl.caching.AccessoriesHolderLookupCache;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import org.slf4j.Logger;

public record InvalidateEntityCache(int entityId) {

    private static final Logger LOGGER = LogUtils.getLogger();

    public static final StructEndec<InvalidateEntityCache> ENDEC = StructEndecBuilder.of(
            Endec.VAR_INT.fieldOf("entityId", InvalidateEntityCache::entityId),
            InvalidateEntityCache::new
    );

    //@Environment(EnvType.CLIENT)
    public static void handlePacket(InvalidateEntityCache packet, class_1657 player) {
        var level = player.method_73183();
        var entity = level.method_8469(packet.entityId());

        if(entity == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as it is null on the Client! [EntityId: {}]", packet.entityId());

            return;
        }

        if(!(entity instanceof class_1309 livingEntity)) return;

        var capability = AccessoriesCapability.get(livingEntity);

        if(capability == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as its Capability is null on the Client! [EntityId: {}]", packet.entityId());

            return;
        }

        var cache = AccessoriesHolderImpl.getHolder(capability).getLookupCache();

        if(cache != null) cache.clearCache();
    }
}
