package io.wispforest.accessories.pond;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import net.minecraft.class_169;

public interface AccessoriesRenderStateAPImpl extends AccessoriesRenderStateAPI {

    Reference2ObjectMap<class_169<?>, Object> contextKeyToContextData();

    @Override
    default <T> T getStateData(class_169<T> key) {
        return (T) this.contextKeyToContextData().get(key);
    }

    @Override
    default <T> void setStateData(class_169<T> key, T data) {
        var map = this.contextKeyToContextData();

        if (data == null) {
            map.remove(key);
        } else {
            map.put(key, data);
        }
    }

    @Override
    default <T> boolean hasStateData(class_169<T> key) {
        return this.contextKeyToContextData().containsKey(key);
    }

    @Override
    default void clearExtraData() {
        this.contextKeyToContextData().clear();
    }
}
