package io.wispforest.accessories.pond;

import Z;
import io.wispforest.accessories.menu.ArmorSlotTypes;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;

public interface CosmeticArmorLookupTogglable {

    // TODO: HOPE THAT WITHIN THE FUTURE THIS WRAPPER METHODS WILL NOT BE NEEDED
    static <T> T runWithLookupToggle(class_1297 entity, Supplier<T> runnable) {
        var bl = entity instanceof CosmeticArmorLookupTogglable;

        if (bl) ((CosmeticArmorLookupTogglable) entity).setLookupToggle(true);

        var t = runnable.get();

        if (bl) ((CosmeticArmorLookupTogglable) entity).setLookupToggle(false);

        return t;
    }

    static void runWithLookupToggle(class_1297 entity, Runnable runnable) {
        var bl = entity instanceof CosmeticArmorLookupTogglable;

        if (bl) ((CosmeticArmorLookupTogglable) entity).setLookupToggle(true);

        runnable.run();

        if (bl) ((CosmeticArmorLookupTogglable) entity).setLookupToggle(false);
    }

    default void setLookupToggle(boolean value) {
        throw new IllegalStateException("Interface injected method not implemented!");
    }

    default boolean getLookupToggle() {
        throw new IllegalStateException("Interface injected method not implemented!");
    }

    static void getAlternativeStack(class_1309 livingEntity, class_1304 equipmentSlot, Consumer<class_1799> consumer) {
        if(!((CosmeticArmorLookupTogglable)livingEntity).getLookupToggle()) return;

        var cosmetic = ArmorSlotTypes.getAlternativeStack(livingEntity, equipmentSlot);

        if(cosmetic == null) return;

        consumer.accept(cosmetic);
    }
}
