package io.wispforest.accessories.utils;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_5131;
import org.slf4j.Logger;

public class AttributeUtils {
    public static final Logger LOGGER = LogUtils.getLogger();

    public static void addTransientAttributeModifiers(class_1309 livingEntity, AccessoryAttributeBuilder attributes) {
        if(attributes.isEmpty()) return;

        var attributeMap = livingEntity.method_6127();
        var capability = livingEntity.accessoriesCapability();

        var containers = capability.getContainers();

        attributes.getSlotModifiers().asMap().forEach((s, modifiers) -> {
            var container = containers.get(s);

            if(container == null) return;

            modifiers.stream()
                    .filter(modifier -> !container.hasModifier(modifier.comp_2447()))
                    .forEach(container::addTransientModifier);
        });

        attributes.getAttributeModifiers(true).asMap().forEach((holder, modifiers) -> {
            var instance = attributeMap.method_45329(holder);

            if(instance == null) return;

            modifiers.stream()
                    .filter(modifier -> !instance.method_6196(modifier.comp_2447()))
                    .forEach(instance::method_26835);
        });
    }

    public static void removeTransientAttributeModifiers(class_1309 livingEntity, AccessoryAttributeBuilder attributes) {
        if(attributes.isEmpty()) return;

        var attributeMap = livingEntity.method_6127();
        var capability = livingEntity.accessoriesCapability();

        var containers = capability.getContainers();

        attributes.getSlotModifiers().asMap().forEach((s, modifiers) -> {
            var container = containers.get(s);

            if(container == null) return;

            modifiers.stream()
                    .map(class_1322::comp_2447)
                    .forEach(container::removeModifier);
        });

        attributes.getAttributeModifiers(true).asMap().forEach((holder, modifiers) -> {
            var instance = attributeMap.method_45329(holder);

            if(instance == null) return;

            modifiers.stream()
                    .map(class_1322::comp_2447)
                    .forEach(instance::method_6200);
        });
    }

    public static final StructEndec<class_1322> ATTRIBUTE_MODIFIER_ENDEC = StructEndecBuilder.of(
            MinecraftEndecs.IDENTIFIER.fieldOf("id", class_1322::comp_2447),
            Endec.DOUBLE.fieldOf("amount", class_1322::comp_2449),
            EndecUtils.forEnumStringRepresentable(class_1322.class_1323.class).fieldOf("operation", class_1322::comp_2450),
            class_1322::new
    );
}
