package io.wispforest.accessories.utils;

import io.wispforest.owo.util.EventSource;
import io.wispforest.owo.util.EventStream;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_11343;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_11372.class_11373;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1657;
import net.minecraft.class_1737;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_9875;

public class BaseContainer implements class_1263, class_1737 {
    private final int size;
    private final class_2371<class_1799> items;

    @Nullable
    private EventStream<class_1265> onContainerChange = null;

    public BaseContainer(int size) {
        this.size = size;
        this.items = class_2371.method_10213(size, class_1799.field_8037);
    }

    public BaseContainer(class_1799... items) {
        this.size = items.length;
        this.items = class_2371.method_10212(class_1799.field_8037, items);
    }

    /**
     * Add a listener that will be notified when any item in this inventory is modified.
     */
    public EventSource.Subscription addListener(class_1265 listener) {
        if (this.onContainerChange == null) {
            this.onContainerChange = new EventStream<>(invokers -> container -> invokers.forEach(listenerEntry -> listenerEntry.method_5453(container)));
        }

        return this.onContainerChange.source().subscribe(listener);
    }

    public List<class_1799> getItems() {
        return items;
    }

    @Override
    public class_1799 method_5438(int slot) {
        return slot >= 0 && slot < this.items.size()
            ? this.items.get(slot)
            : class_1799.field_8037;
    }

    public List<class_1799> removeAllItems() {
        var list = this.items.stream().filter(itemStack -> !itemStack.method_7960()).collect(Collectors.toList());

        this.method_5448();

        return list;
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        var itemStack = class_1262.method_5430(this.items, slot, amount);

        if (!itemStack.method_7960()) this.method_5431();

        return itemStack;
    }

    public class_1799 removeItemType(class_1792 item, int amount) {
        var itemStack = new class_1799(item, 0);

        for (int i = this.size - 1; i >= 0; i--) {
            var itemStack2 = this.method_5438(i);

            if (itemStack2.method_7909().equals(item)) {
                int j = amount - itemStack.method_7947();

                var itemStack3 = itemStack2.method_7971(j);

                itemStack.method_7933(itemStack3.method_7947());

                if (itemStack.method_7947() == amount) break;
            }
        }

        if (!itemStack.method_7960()) this.method_5431();

        return itemStack;
    }

    public class_1799 addItem(class_1799 stack) {
        if (stack.method_7960()) return class_1799.field_8037;

        var itemStack = stack.method_7972();
        this.moveItemToOccupiedSlotsWithSameType(itemStack);

        if (itemStack.method_7960()) return class_1799.field_8037;

        this.moveItemToEmptySlots(itemStack);
        return itemStack.method_7960() ? class_1799.field_8037 : itemStack;
    }

    public boolean canAddItem(class_1799 stack) {
        boolean bl = false;

        for (var itemStack : this.items) {
            if (itemStack.method_7960() || class_1799.method_31577(itemStack, stack) && itemStack.method_7947() < itemStack.method_7914()) {
                bl = true;
                break;
            }
        }

        return bl;
    }

    @Override
    public class_1799 method_5441(int slot) {
        var itemStack = this.items.get(slot);

        if (itemStack.method_7960()) return class_1799.field_8037;

        this.items.set(slot, class_1799.field_8037);

        return itemStack;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        this.items.set(slot, stack);

        stack.method_58408(this.method_58350(stack));

        this.method_5431();
    }

    @Override
    public int method_5439() {
        return this.size;
    }

    @Override
    public boolean method_5442() {
        for (class_1799 itemStack : this.items) {
            if (!itemStack.method_7960()) return false;
        }

        return true;
    }

    @Override
    public void method_5431() {
        if (this.onContainerChange != null) {
            this.onContainerChange.sink().method_5453(this);
        }
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return true;
    }

    @Override
    public void method_5448() {
        this.items.clear();
        this.method_5431();
    }

    @Override
    public void method_7683(class_9875 stackedItemContents) {
        for (var itemStack : this.items) stackedItemContents.method_61541(itemStack);
    }

    public String toString() {
        return this.items.stream()
            .filter(itemStack -> !itemStack.method_7960())
            .toList()
            .toString();
    }

    private void moveItemToEmptySlots(class_1799 stack) {
        for (int i = 0; i < this.size; i++) {
            var itemStack = this.method_5438(i);

            if (itemStack.method_7960()) {
                this.method_5447(i, stack.method_51164());
                return;
            }
        }
    }

    private void moveItemToOccupiedSlotsWithSameType(class_1799 stack) {
        for (int i = 0; i < this.size; i++) {
            var itemStack = this.method_5438(i);

            if (class_1799.method_31577(itemStack, stack)) {
                this.moveItemsBetweenStacks(stack, itemStack);

                if (stack.method_7960()) return;
            }
        }
    }

    private void moveItemsBetweenStacks(class_1799 stack, class_1799 other) {
        int i = this.method_58350(other);
        int j = Math.min(stack.method_7947(), i - other.method_7947());
        if (j > 0) {
            other.method_7933(j);
            stack.method_7934(j);
            this.method_5431();
        }
    }

    public final void saveAllItems(class_11372 valueOutput) {
        var typedOutputList = valueOutput.method_71467("Items", class_11343.field_60354);

        saveItemsToList(typedOutputList);
    }

    public final void loadAllItems(class_11368 valueInput) {
        loadItemsFromList(valueInput.method_71437("Items", class_11343.field_60354));
    }

    public void saveItemsToList(class_11372.class_11373<class_11343> valueOutput) {
        saveItemsToList().forEach(valueOutput::method_71484);
    }

    public void loadItemsFromList(class_11368.class_11369<class_11343> valueInput) {
        loadItemsFromList(valueInput.method_71456().toList());
    }

    //--

    public List<class_11343> saveItemsToList() {
        var slottedStacks = new ArrayList<class_11343>();

        for (int i = 0; i < items.size(); i++) {
            var itemStack = items.get(i);
            if (!itemStack.method_7960()) {
                slottedStacks.add(new class_11343(i, itemStack));
            }
        }

        return slottedStacks;
    }

    public void loadItemsFromList(Collection<class_11343> slottedStacks) {
        for (var slottedStack : slottedStacks) {
            if (slottedStack.method_71368(size)) {
                this.items.set(slottedStack.comp_4211(), slottedStack.comp_4212());
            }
        }
    }

    public interface ErrorableGetter<T> {
        T getEntry(Consumer<String> errorConsumer);
    }
}
