package io.wispforest.accessories.utils;

import com.google.gson.*;
import com.mojang.logging.LogUtils;
import org.slf4j.Logger;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7654;

public class JsonUtils {

    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();

    private static final Logger LOGGER = LogUtils.getLogger();

    public record FileResourceData(class_2960 fileLocation, JsonObject obj, class_3298 resource){}

    public static <T> Map<class_2960, class_3298> scanDirectoryWithReplace(class_3300 resourceManager, class_7654 fileToIdConverter) {
        var outputResources = new LinkedHashMap<class_2960, FileResourceData>();

        for(var entry : fileToIdConverter.method_45116(resourceManager).entrySet()) {
            var filePath = entry.getKey();
            var resourceLocation = fileToIdConverter.method_45115(entry.getKey());

            for (class_3298 resource : entry.getValue()) {
                try(Reader reader = resource.method_43039()) {
                    var jsonElement = class_3518.method_15276(GSON, reader, JsonElement.class);

                    if(!(jsonElement instanceof JsonObject jsonObject)){
                        LOGGER.warn("File was found not to be parsed as a valid JsonObject, it will be skipped: [Location: " + filePath + "]");
                        continue;
                    }

                    if(outputResources.containsKey(resourceLocation)){
                        var jsonObject2 = outputResources.get(resourceLocation).obj().getAsJsonObject();

                        //TODO: SHOULD THIS OVERWRITE ENTRIES OR REPLACE THE OBJECT????
                        if(class_3518.method_15270(jsonObject, "replace")){
                            jsonObject.asMap().forEach(jsonObject2::add);
                        }
                    } else {
                        outputResources.put(resourceLocation, new FileResourceData(filePath, jsonObject, resource));
                    }
                } catch (IllegalArgumentException | IOException | JsonParseException var14) {
                    LOGGER.error("Couldn't parse data file {} from {}", resourceLocation, filePath, var14);
                }
            }
        }

        return outputResources.entrySet().stream().collect(
                Collectors.toMap(
                        entry -> entry.getValue().fileLocation(),
                        entry -> entry.getValue().resource(),
                        (object, object2) -> object,
                        LinkedHashMap::new
                )
        );
    }
}
