/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import com.google.common.collect.Multimap;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesStorageLookup;
import io.wispforest.accessories.api.AccessoriesStorageLookupUtils;
import io.wispforest.accessories.api.caching.ItemStackBasedPredicate;
import io.wispforest.accessories.api.caching.ItemStackPredicate;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.equip.EquipAction;
import io.wispforest.accessories.api.equip.EquipCheck;
import io.wispforest.accessories.api.equip.EquipmentChecking;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.caching.AccessoriesHolderLookupCache;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AccessoriesCapability
extends AccessoriesStorageLookup {
    @Nullable
    public static AccessoriesCapability get(@NotNull class_1309 livingEntity) {
        return livingEntity.accessoriesCapability();
    }

    public static Optional<AccessoriesCapability> getOptionally(@NotNull class_1309 livingEntity) {
        return Optional.ofNullable(AccessoriesCapability.get(livingEntity));
    }

    public static Collection<SlotType> getUsedSlotsFor(class_1657 player) {
        return AccessoriesCapability.getUsedSlotsFor((class_1309)player, (class_1263)player.method_31548());
    }

    public static Collection<SlotType> getUsedSlotsFor(class_1309 entity, class_1263 container) {
        AccessoriesCapability capability = entity.accessoriesCapability();
        return capability != null ? capability.getUsedSlotsFor(container) : Set.of();
    }

    public class_1309 entity();

    public void reset(boolean var1);

    public Map<String, AccessoriesContainer> getContainers();

    @Override
    @Nullable
    default public AccessoriesContainer getContainer(SlotType slotType) {
        return this.getContainers().get(slotType.name());
    }

    @Override
    @Nullable
    default public AccessoriesContainer getContainer(SlotTypeReference reference) {
        return this.getContainers().get(reference.slotName());
    }

    default public Collection<SlotType> getUsedSlotsFor(class_1263 container) {
        class_1309 entity = this.entity();
        HashSet<SlotType> slots = new HashSet<SlotType>();
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (stack.method_7960()) continue;
            slots.addAll(SlotPredicateRegistry.getValidSlotTypes(entity, stack));
        }
        for (SlotEntryReference ref : this.getAllEquipped()) {
            slots.addAll(SlotPredicateRegistry.getValidSlotTypes(entity, ref.stack()));
        }
        slots.addAll(SlotTypeLoader.getUsedSlotsByRegistryItem(entity));
        return slots;
    }

    public void updateContainers();

    @Nullable
    default public SlotReference attemptToEquipAccessory(class_1799 stack) {
        Pair<SlotReference, Optional<class_1799>> result = this.attemptToEquipAccessory(stack, false);
        return result != null ? (SlotReference)result.first() : null;
    }

    @Nullable
    default public Pair<SlotReference, Optional<class_1799>> attemptToEquipAccessory(class_1799 stack, boolean allowSwapping) {
        Pair<SlotReference, EquipAction> result = this.canEquipAccessory(stack, allowSwapping, (slotStack, slotReference) -> true);
        return result != null ? Pair.of((Object)((SlotReference)result.first()), ((EquipAction)result.second()).equipStack(stack)) : null;
    }

    default public Pair<SlotReference, EquipAction> canEquipAccessory(class_1799 stack, boolean allowSwapping) {
        return this.canEquipAccessory(stack, allowSwapping, (slotStack, slotReference) -> true);
    }

    @Nullable
    public Pair<SlotReference, EquipAction> canEquipAccessory(class_1799 var1, boolean var2, EquipCheck var3);

    @Override
    @Nullable
    default public SlotEntryReference getFirstEquipped(class_1792 item) {
        return this.getFirstEquipped(item, EquipmentChecking.ACCESSORIES_ONLY);
    }

    @Override
    @Nullable
    default public SlotEntryReference getFirstEquipped(class_1792 item, EquipmentChecking check) {
        return this.getFirstEquipped(ItemStackBasedPredicate.ofItem(item), check);
    }

    @Override
    @Nullable
    default public SlotEntryReference getFirstEquipped(Predicate<class_1799> predicate) {
        return this.getFirstEquipped((Predicate)predicate, EquipmentChecking.ACCESSORIES_ONLY);
    }

    @Override
    @Nullable
    default public SlotEntryReference getFirstEquipped(Predicate<class_1799> predicate, EquipmentChecking check) {
        return this.getFirstEquipped(ItemStackBasedPredicate.ofPredicate(predicate), check);
    }

    @Override
    @Nullable
    default public SlotEntryReference getFirstEquipped(ItemStackBasedPredicate predicate, EquipmentChecking check) {
        AccessoriesHolderLookupCache cache = AccessoriesHolderImpl.getHolder(this).getLookupCache();
        if (cache != null && !(predicate instanceof ItemStackPredicate)) {
            return cache.firstEquipped(predicate, check);
        }
        return AccessoriesStorageLookupUtils.getFirstEquipped(this.getContainers(), (path, stack) -> new SlotEntryReference(this.entity(), (SlotPath)path, (class_1799)stack), predicate, check);
    }

    default public List<SlotEntryReference> getEquipped(class_1792 item) {
        return this.getEquipped(ItemStackBasedPredicate.ofItem(item));
    }

    default public List<SlotEntryReference> getEquipped(Predicate<class_1799> predicate) {
        return this.getEquipped(ItemStackBasedPredicate.ofPredicate(predicate));
    }

    default public List<SlotEntryReference> getEquipped(ItemStackBasedPredicate predicate) {
        return this.getAllEquipped().stream().filter(reference -> predicate.test(reference.stack())).toList();
    }

    default public List<SlotEntryReference> getAllEquipped() {
        AccessoriesHolderLookupCache cache = AccessoriesHolderImpl.getHolder(this).getLookupCache();
        if (cache != null) {
            return cache.getAllEquipped();
        }
        return AccessoriesStorageLookupUtils.getAllEquipped(this.getContainers(), (path, stack) -> new SlotEntryReference(this.entity(), (SlotPath)path, (class_1799)stack));
    }

    public void addTransientSlotModifiers(Multimap<String, class_1322> var1);

    public void addPersistentSlotModifiers(Multimap<String, class_1322> var1);

    public void removeSlotModifiers(Multimap<String, class_1322> var1);

    public Multimap<String, class_1322> getSlotModifiers();

    public void clearSlotModifiers();

    public void clearCachedSlotModifiers();

    @Deprecated
    @Nullable
    default public Pair<SlotReference, List<class_1799>> equipAccessory(class_1799 stack) {
        return this.equipAccessory(stack, false);
    }

    @Deprecated
    default public Pair<SlotReference, List<class_1799>> equipAccessory(class_1799 stack, boolean allowSwapping) {
        class_1799 stackCopy = stack.method_7972();
        Pair<SlotReference, Optional<class_1799>> result = this.attemptToEquipAccessory(stackCopy, allowSwapping);
        if (result == null) {
            return null;
        }
        ArrayList<class_1799> returnStacks = new ArrayList<class_1799>();
        if (!stackCopy.method_7960()) {
            returnStacks.add(stackCopy);
        }
        ((Optional)result.second()).ifPresent(returnStacks::add);
        return Pair.of((Object)((SlotReference)result.first()), returnStacks);
    }

    @Deprecated
    @Nullable
    default public Pair<SlotReference, List<class_1799>> equipAccessory(class_1799 stack, boolean allowSwapping, TriFunction<Accessory, class_1799, SlotReference, Boolean> additionalCheck) {
        return this.equipAccessory(stack, allowSwapping);
    }

    @Deprecated(forRemoval=true)
    default public boolean isAnotherEquipped(SlotReference slotReference, class_1792 item) {
        return this.isAnotherEquipped(slotReference.getStack(), (SlotPath)slotReference, item);
    }

    @Deprecated(forRemoval=true)
    default public boolean isAnotherEquipped(SlotReference slotReference, Predicate<class_1799> predicate) {
        return this.isAnotherEquipped(slotReference.getStack(), (SlotPath)slotReference, predicate);
    }
}

