/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.rendering;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesStorageLookup;
import io.wispforest.accessories.api.client.AccessoriesRenderStateKeys;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import io.wispforest.accessories.api.client.rendering.RenderingFunction;
import io.wispforest.accessories.api.client.rendering.TransformOps;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.client.ClientDelayedCache;
import io.wispforest.accessories.data.CustomRendererLoader;
import java.lang.ref.SoftReference;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_10444;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_11659;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3730;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_583;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_811;
import net.minecraft.class_8113;
import net.minecraft.class_824;
import net.minecraft.class_8942;
import net.minecraft.class_898;
import net.minecraft.class_9334;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;

@ApiStatus.Experimental
public class RenderingFunctionOps {
    private static final ClientDelayedCache<ParticleTimeKey> PARTICLE_UPDATE_CACHE = new ClientDelayedCache();
    private static final Map<class_1299, EntityData> ENTITY_CACHE = new HashMap<class_1299, EntityData>();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void handleFunctions(class_1799 stack, SlotPath path, class_4587 matrices, class_583<? extends class_10042> model, class_10042 renderState, class_11659 collector, int light, float partialTicks, @Nullable class_1306 arm, int packedLight, int packedOverlay, int color, List<RenderingFunction> functions) {
        RenderingFunctionOps.handleFunctions(class_1799.method_57355((class_1799)stack), stack, path, matrices, model, renderState, collector, light, partialTicks, arm, packedLight, packedOverlay, color, functions);
    }

    public static void handleFunctions(int uniqueKey, class_1799 stack, SlotPath path, class_4587 matrices, class_583<? extends class_10042> model, class_10042 renderState, class_11659 collector, int light, float partialTicks, @Nullable class_1306 arm, int packedLight, int packedOverlay, int color, List<RenderingFunction> functions) {
        for (RenderingFunction function : functions) {
            RenderingFunctionOps.handleFunction(uniqueKey, stack, path, matrices, model, renderState, collector, light, partialTicks, arm, packedLight, packedOverlay, color, function);
        }
    }

    public static void handleFunction(int uniqueKey, class_1799 stack, SlotPath path, class_4587 matrices, class_583<? extends class_10042> model, class_10042 renderState, class_11659 collector, int light, float partialTicks, @Nullable class_1306 arm, int packedLight, int packedOverlay, int color, RenderingFunction renderingFunction) {
        class_310 client = class_310.method_1551();
        class_638 level = client.field_1687;
        class_12075 cameraState = (class_12075)renderState.getStateData(AccessoriesRenderStateKeys.CAMERA_STATE);
        RenderingFunction renderingFunction2 = renderingFunction;
        Objects.requireNonNull(renderingFunction2);
        RenderingFunction renderingFunction3 = renderingFunction2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RenderingFunction.Transformations.class, RenderingFunction.Block.class, RenderingFunction.Entity.class, RenderingFunction.Item.class, RenderingFunction.Model.class, RenderingFunction.Particle.class, RenderingFunction.Compound.class, RenderingFunction.RawRenderer.class, RenderingFunction.DeferredRenderer.class}, (Object)renderingFunction3, n)) {
            case 0: {
                RenderingFunction.Transformations transformation = (RenderingFunction.Transformations)renderingFunction3;
                TransformOps.transformStack(transformation.transformations(), matrices, model, () -> RenderingFunctionOps.handleFunction(uniqueKey, stack, path, matrices, model, renderState, collector, light, partialTicks, arm, packedLight, packedOverlay, color, transformation.renderingFunction()));
                break;
            }
            case 1: {
                RenderingFunction.Block blockData = (RenderingFunction.Block)renderingFunction3;
                class_2680 state = blockData.state();
                class_2586 blockEntity = blockData.type() != null ? class_2586.method_11005((class_2338)class_2338.field_10980, (class_2680)blockData.state(), (class_2487)blockData.data(), (class_7225.class_7874)level.method_30349()) : null;
                matrices.method_22903();
                matrices.method_22904(-0.5, 0.0, -0.5);
                RenderingFunctionOps.renderBlock(client, state, blockEntity, cameraState, 0.0f, matrices, collector, packedLight, packedOverlay, color);
                matrices.method_22909();
                break;
            }
            case 2: {
                RenderingFunction.Entity entityData = (RenderingFunction.Entity)renderingFunction3;
                try {
                    EntityData currentEntityData = ENTITY_CACHE.computeIfAbsent(entityData.entityType(), entityType -> {
                        class_1297 entity = entityData.entityType().method_5883((class_1937)level, class_3730.field_16467);
                        if (entity != null) {
                            class_2487 defaultData = Accessories.handleIoError("rendering_function_default_entity_data", scopedCollector -> {
                                class_11362 valueOutput = class_11362.method_71459((class_8942)scopedCollector, (class_7225.class_7874)level.method_30349());
                                entity.method_5647((class_11372)valueOutput);
                                return valueOutput.method_71475();
                            });
                            return new EntityData(new SoftReference<class_1297>(entity), defaultData, true);
                        }
                        return new EntityData(null, new class_2487(), false);
                    });
                    if (!currentEntityData.wasSpawnable()) {
                        return;
                    }
                    if (!currentEntityData.canBeGotten()) {
                        currentEntityData.createNewReference(entityData.entityType(), (class_1937)level);
                    }
                    if (!currentEntityData.wasSpawnable()) {
                        return;
                    }
                    class_1297 entity = currentEntityData.reference().get();
                    if (entity == null) {
                        return;
                    }
                    boolean customData = false;
                    if (!entityData.data().method_33133()) {
                        customData = true;
                        Accessories.handleIoError("rendering_function_entity_data", scopedCollector -> entity.method_5651(class_11352.method_71417((class_8942)scopedCollector, (class_7225.class_7874)level.method_30349(), (class_2487)entityData.data())));
                    }
                    if (entityData.allowTicking() || entity instanceof class_8113) {
                        entity.method_5773();
                    }
                    class_898 dispatcher = client.method_1561();
                    class_10017 state = dispatcher.method_72977(entity, partialTicks);
                    dispatcher.method_72976(state, cameraState, 0.0, 0.0, 0.0, matrices, collector);
                    if (!customData) break;
                    currentEntityData.resetEntity((class_1937)level);
                }
                catch (Exception currentEntityData) {}
                break;
            }
            case 3: {
                RenderingFunction.Item itemData = (RenderingFunction.Item)renderingFunction3;
                class_1799 renderStack = itemData.stack();
                class_10444 state = new class_10444();
                client.method_65386().method_65598(state, renderStack, class_811.field_4317, null, null, Objects.hash(itemData, uniqueKey));
                state.method_65604(matrices, collector, packedLight, packedOverlay, 0);
                break;
            }
            case 4: {
                RenderingFunction.Model modelData = (RenderingFunction.Model)renderingFunction3;
                class_1799 modelStack = class_1802.field_8542.method_7854();
                modelStack.method_57379(class_9334.field_54199, (Object)modelData.id());
                class_10444 state = new class_10444();
                client.method_65386().method_65598(state, modelStack, class_811.field_4317, null, null, Objects.hash(modelData, uniqueKey));
                break;
            }
            case 5: {
                RenderingFunction.Particle particleData = (RenderingFunction.Particle)renderingFunction3;
                if (!PARTICLE_UPDATE_CACHE.hasAllottedTime(new ParticleTimeKey(renderState.getEntityUUIDForState(), uniqueKey, particleData), particleData.delay())) {
                    return;
                }
                Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f).mulPosition((Matrix4fc)matrices.method_23760().method_23761()).add((Vector3fc)class_310.method_1551().field_1773.method_19418().method_19326().method_46409());
                RenderingFunctionOps.renderParticle((class_1937)level, particleData, pos.x(), pos.y(), pos.z());
                break;
            }
            case 6: {
                RenderingFunction.Compound compoundFunction = (RenderingFunction.Compound)renderingFunction3;
                if (arm != null && !compoundFunction.firstPersonArmTarget().hasArm(arm)) {
                    return;
                }
                RenderingFunctionOps.handleFunctions(uniqueKey, stack, path, matrices, model, renderState, collector, light, partialTicks, arm, packedLight, packedOverlay, color, compoundFunction.renderingFunctions());
                break;
            }
            case 7: {
                RenderingFunction.RawRenderer data = (RenderingFunction.RawRenderer)renderingFunction3;
                RenderingFunction renderFunction = CustomRendererLoader.getOrResolveRawRenderer(data, !CustomRendererLoader.isConstantResolveTarget());
                if (renderFunction == null) {
                    return;
                }
                RenderingFunctionOps.handleFunction(uniqueKey, stack, path, matrices, model, renderState, collector, light, partialTicks, arm, packedLight, packedOverlay, color, renderFunction);
                break;
            }
            case 8: {
                RenderingFunction.DeferredRenderer renderer = (RenderingFunction.DeferredRenderer)renderingFunction3;
                Either<AccessoryRenderer, RenderingFunction> renderFunction = CustomRendererLoader.getOrResolveRenderer(renderer, !CustomRendererLoader.isConstantResolveTarget());
                if (renderFunction == null) {
                    return;
                }
                AccessoriesStorageLookup lookup = (AccessoriesStorageLookup)renderState.getStateData(AccessoriesRenderStateKeys.STORAGE_LOOKUP);
                renderFunction.ifLeft(accessoryRenderer -> {}).ifRight(function1 -> RenderingFunctionOps.handleFunction(uniqueKey, stack, path, matrices, model, renderState, collector, light, partialTicks, arm, packedLight, packedOverlay, color, function1));
                break;
            }
            default: {
                throw new IllegalStateException("Unimplemented RendererFunc: " + renderingFunction.key());
            }
        }
    }

    private static void renderParticle(class_1937 level, RenderingFunction.Particle particle, double x, double y, double z) {
        class_5819 random = level.method_8409();
        try {
            if (particle.count() == 0) {
                double xSpd = particle.speed() * particle.delta().x();
                double ySpd = particle.speed() * particle.delta().y();
                double zSpd = particle.speed() * particle.delta().z();
                level.method_8466(particle.particleData(), particle.overrideLimiter(), particle.alwaysShow(), x, y, z, xSpd, ySpd, zSpd);
            } else {
                for (int i = 0; i < particle.count(); ++i) {
                    double g = random.method_43059() * (double)particle.delta().x();
                    double h = random.method_43059() * (double)particle.delta().y();
                    double j = random.method_43059() * (double)particle.delta().z();
                    double k = random.method_43059() * (double)particle.speed();
                    double l = random.method_43059() * (double)particle.speed();
                    double m = random.method_43059() * (double)particle.speed();
                    level.method_8466(particle.particleData(), particle.overrideLimiter(), particle.alwaysShow(), x + g, y + h, z + j, k, l, m);
                }
            }
        }
        catch (Throwable var16) {
            LOGGER.warn("Could not spawn particle effect {}", (Object)particle.particleData());
        }
    }

    private static void renderBlock(class_310 client, class_2680 state, @Nullable class_2586 blockEntity, class_12075 cameraState, float partialTick, class_4587 matrices, class_11659 collector, int packedLight, int packedOverlay, int color) {
        class_824 dispatcher;
        class_11954 \u043c\u0435\u0434\u0432\u0435\u0434\u044c;
        if (state.method_26217() != class_2464.field_11455) {
            collector.method_73481(matrices, state, packedLight, packedOverlay, 0);
        }
        if (blockEntity != null && (\u043c\u0435\u0434\u0432\u0435\u0434\u044c = (dispatcher = client.method_31975()).method_74348(blockEntity, partialTick, null)) != null) {
            dispatcher.method_3555(\u043c\u0435\u0434\u0432\u0435\u0434\u044c, matrices, collector, cameraState);
        }
    }

    public static boolean shouldRender(class_1799 stack, SlotPath path, AccessoriesStorageLookup storageLookup, class_1309 entity, class_10042 entityState, List<RenderingFunction> renderingFunctions) {
        for (RenderingFunction function : renderingFunctions) {
            Boolean result = RenderingFunctionOps.shouldRender(stack, path, storageLookup, entity, entityState, function);
            if (result == null || !result.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Boolean shouldRender(class_1799 stack, SlotPath path, AccessoriesStorageLookup storageLookup, class_1309 entity, class_10042 entityState, RenderingFunction renderingFunction) {
        if (renderingFunction instanceof RenderingFunction.ArmedTargeted) {
            RenderingFunction.ArmedTargeted armedTargeted = (RenderingFunction.ArmedTargeted)((Object)renderingFunction);
            if (entityState.hasStateData(AccessoriesRenderStateKeys.ARM) && armedTargeted.firstPersonArmTarget().hasArm((class_1306)entityState.getStateData(AccessoriesRenderStateKeys.ARM))) {
                return true;
            }
        }
        RenderingFunction renderingFunction2 = renderingFunction;
        Objects.requireNonNull(renderingFunction2);
        RenderingFunction renderingFunction3 = renderingFunction2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RenderingFunction.Transformations.class, RenderingFunction.Compound.class, RenderingFunction.RawRenderer.class, RenderingFunction.DeferredRenderer.class}, (Object)renderingFunction3, n)) {
            case 0 -> {
                RenderingFunction.Transformations transformation = (RenderingFunction.Transformations)renderingFunction3;
                yield RenderingFunctionOps.shouldRender(stack, path, storageLookup, entity, entityState, transformation.renderingFunction());
            }
            case 1 -> {
                RenderingFunction.Compound compoundFunction = (RenderingFunction.Compound)renderingFunction3;
                yield RenderingFunctionOps.shouldRender(stack, path, storageLookup, entity, entityState, compoundFunction.renderingFunctions());
            }
            case 2 -> {
                RenderingFunction.RawRenderer data = (RenderingFunction.RawRenderer)renderingFunction3;
                RenderingFunction renderFunction = CustomRendererLoader.getOrResolveRawRenderer(data, !CustomRendererLoader.isConstantResolveTarget());
                if (renderFunction == null) {
                    yield null;
                }
                yield RenderingFunctionOps.shouldRender(stack, path, storageLookup, entity, entityState, renderFunction);
            }
            case 3 -> {
                RenderingFunction.DeferredRenderer renderer = (RenderingFunction.DeferredRenderer)renderingFunction3;
                Either<AccessoryRenderer, RenderingFunction> possibleRenderer = CustomRendererLoader.getOrResolveRenderer(renderer, !CustomRendererLoader.isConstantResolveTarget());
                if (possibleRenderer == null) {
                    yield null;
                }
                yield (Boolean)Either.unwrap((Either)possibleRenderer.mapBoth(accessoryRenderer -> accessoryRenderer.shouldRender(stack, path, storageLookup, entity, entityState, true), renderFunction -> RenderingFunctionOps.shouldRender(stack, path, storageLookup, entity, entityState, renderFunction)));
            }
            default -> null;
        };
    }

    private static final class EntityData {
        private final class_2487 defaultData;
        @Nullable
        private SoftReference<class_1297> reference;
        private boolean wasSpawnable;

        private EntityData(@Nullable SoftReference<class_1297> reference, class_2487 defaultData, boolean wasSpawnable) {
            this.reference = reference;
            this.defaultData = defaultData;
            this.wasSpawnable = wasSpawnable;
        }

        private boolean canBeGotten() {
            return this.reference != null && this.reference.get() != null;
        }

        @Nullable
        public SoftReference<class_1297> reference() {
            return this.reference;
        }

        public void resetEntity(class_1937 level) {
            if (this.reference == null) {
                return;
            }
            class_1297 entity = this.reference.get();
            if (entity == null) {
                return;
            }
            try {
                Accessories.handleIoError("rendering_function_entity_data", scopedCollector -> entity.method_5651(class_11352.method_71417((class_8942)scopedCollector, (class_7225.class_7874)level.method_30349(), (class_2487)this.defaultData)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void createNewReference(class_1299 type, class_1937 level) {
            class_1297 entity = type.method_5883(level, class_3730.field_16467);
            if (entity == null) {
                this.wasSpawnable = false;
                return;
            }
            this.reference = new SoftReference<class_1297>(entity);
        }

        public class_2487 defaultData() {
            return this.defaultData;
        }

        public boolean wasSpawnable() {
            return this.wasSpawnable;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            EntityData that = (EntityData)obj;
            return Objects.equals(this.reference, that.reference) && Objects.equals(this.defaultData, that.defaultData) && this.wasSpawnable == that.wasSpawnable;
        }

        public int hashCode() {
            return Objects.hash(this.reference, this.defaultData, this.wasSpawnable);
        }

        public String toString() {
            return "EntityData[reference=" + String.valueOf(this.reference) + ", defaultData=" + String.valueOf(this.defaultData) + ", wasSpawnable=" + this.wasSpawnable + "]";
        }
    }

    private record ParticleTimeKey(UUID entityUUID, int uniqueKey) {
        private ParticleTimeKey(UUID entityUUID, int uniqueKey, RenderingFunction.Particle particleData) {
            this(entityUUID, Objects.hash(uniqueKey, particleData));
        }
    }
}

