/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.components;

import com.mojang.serialization.Codec;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.CodecUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public final class AccessoryMobEffectsComponent {
    public static final AccessoryMobEffectsComponent EMPTY = new AccessoryMobEffectsComponent(new ArrayList<class_1293>(), new HashMap<Integer, List<class_1293>>());
    private static final Endec<List<class_1293>> MOB_EFFECT_INSTANCES = CodecUtils.toEndecWithRegistries((Codec)class_1293.field_48821, (class_9139)class_1293.field_49207).listOf();
    private static final Endec<Map<Integer, List<class_1293>>> MAP_ENDEC = StructEndecBuilder.of((StructField)Endec.INT.fieldOf("delay", Map.Entry::getKey), (StructField)MOB_EFFECT_INSTANCES.fieldOf("effect_instances", Map.Entry::getValue), Map::entry).listOf().xmap(entries -> entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (instances1, instances2) -> {
        ArrayList list = new ArrayList(instances1);
        list.addAll(instances2);
        return list;
    }, LinkedHashMap::new)), kvMap -> List.copyOf(kvMap.entrySet()));
    public static Endec<AccessoryMobEffectsComponent> ENDEC = StructEndecBuilder.of((StructField)MOB_EFFECT_INSTANCES.fieldOf("constant_effects", AccessoryMobEffectsComponent::constantMobEffects), (StructField)MAP_ENDEC.fieldOf("delayed_effects", AccessoryMobEffectsComponent::delayedMobEffects), AccessoryMobEffectsComponent::new);
    private final List<class_1293> constantMobEffects;
    private final Map<Integer, List<class_1293>> delayedMobEffects;
    private final Map<Integer, Long> delayToTimer = new HashMap<Integer, Long>();

    public AccessoryMobEffectsComponent(List<class_1293> constantMobEffects, Map<Integer, List<class_1293>> mobEffects) {
        this.constantMobEffects = constantMobEffects;
        this.delayedMobEffects = mobEffects;
    }

    public List<class_1293> constantMobEffects() {
        return Collections.unmodifiableList(this.constantMobEffects);
    }

    public Map<Integer, List<class_1293>> delayedMobEffects() {
        return Collections.unmodifiableMap(this.delayedMobEffects);
    }

    public AccessoryMobEffectsComponent addEffect(class_1293 instance) {
        ArrayList<class_1293> effects = new ArrayList<class_1293>(this.constantMobEffects);
        effects.add(instance);
        return new AccessoryMobEffectsComponent(effects, this.delayedMobEffects);
    }

    public AccessoryMobEffectsComponent addEffect(class_1293 instance, int applyDelay) {
        HashMap<Integer, List<class_1293>> map = new HashMap<Integer, List<class_1293>>(this.delayedMobEffects);
        map.computeIfAbsent(applyDelay, integer -> new ArrayList()).add(instance);
        return new AccessoryMobEffectsComponent(this.constantMobEffects, map);
    }

    public void handleApplyingConstantEffects(class_1309 livingEntity) {
        for (class_1293 constantMobEffect : this.constantMobEffects) {
            livingEntity.method_6092(constantMobEffect);
        }
    }

    public void handleReapplyingEffects(class_1309 livingEntity, long time) {
        for (Integer i : this.delayedMobEffects.keySet()) {
            Long lastApply = this.delayToTimer.getOrDefault(i, null);
            if (lastApply == null || time - lastApply > (long)i.intValue()) {
                for (class_1293 mobEffectInstance : this.delayedMobEffects.get(i)) {
                    livingEntity.method_6092(mobEffectInstance);
                }
            }
            this.delayToTimer.put(i, time);
        }
    }

    public void handleRemovingEffects(class_1309 livingEntity) {
        for (List<class_1293> value : this.delayedMobEffects.values()) {
            for (class_1293 mobEffectInstance : value) {
                livingEntity.method_6016(mobEffectInstance.method_5579());
            }
        }
        for (class_1293 mobEffectInstance : this.constantMobEffects) {
            livingEntity.method_6016(mobEffectInstance.method_5579());
        }
        this.delayToTimer.clear();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AccessoryMobEffectsComponent that = (AccessoryMobEffectsComponent)obj;
        return Objects.equals(this.delayedMobEffects, that.delayedMobEffects);
    }

    public int hashCode() {
        return Objects.hash(this.delayedMobEffects);
    }

    public String toString() {
        return "AccessoryMobEffectsComponent[mobEffects=" + String.valueOf(this.delayedMobEffects) + "]";
    }
}

