/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.events.extra;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.events.extra.AllowWalkingOnSnow;
import io.wispforest.accessories.api.events.extra.FortuneAdjustment;
import io.wispforest.accessories.api.events.extra.IsGazeDisguised;
import io.wispforest.accessories.api.events.extra.PiglinNeutralInducer;
import io.wispforest.accessories.api.events.extra.ShouldFreezeEntity;
import io.wispforest.accessories.api.events.extra.v2.LootingAdjustment;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_3489;
import net.minecraft.class_47;

public class ExtraEventHandler {
    private static final LoadingCache<Integer, Map<Integer, TriState>> gazeDisguiseCache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(Duration.ofSeconds(1L)).weakKeys().build(CacheLoader.from(() -> new HashMap()));

    public static int lootingAdjustments(class_1309 entity, class_47 context, int currentLevel) {
        class_1297 class_12972;
        class_1282 damageSource = (class_1282)context.method_65013(class_181.field_1231);
        if (damageSource != null && (class_12972 = damageSource.method_5529()) instanceof class_1309) {
            class_1309 targetEntity = (class_1309)class_12972;
            AccessoriesCapability capability = AccessoriesCapability.get(entity);
            if (capability != null) {
                for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                    SlotReference reference = entryRef.reference();
                    class_1799 stack = entryRef.stack();
                    Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
                    currentLevel += ((LootingAdjustment)LootingAdjustment.EVENT.invoker()).getLootingAdjustment(stack, reference, targetEntity, context, damageSource, currentLevel);
                    if (!(accessory instanceof LootingAdjustment)) continue;
                    LootingAdjustment lootingAdjustment = (LootingAdjustment)((Object)accessory);
                    currentLevel += lootingAdjustment.getLootingAdjustment(stack, reference, targetEntity, context, damageSource, currentLevel);
                }
            }
        }
        return currentLevel;
    }

    public static int fortuneAdjustment(class_47 context, int currentLevel) {
        class_1309 livingEntity;
        AccessoriesCapability capability;
        Object object = context.method_65013(class_181.field_1226);
        if (object instanceof class_1309 && (capability = AccessoriesCapability.get(livingEntity = (class_1309)object)) != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                SlotReference reference = entryRef.reference();
                class_1799 stack = entryRef.stack();
                Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
                if (accessory instanceof FortuneAdjustment) {
                    FortuneAdjustment fortuneAdjustment = (FortuneAdjustment)((Object)accessory);
                    currentLevel += fortuneAdjustment.getFortuneAdjustment(stack, reference, context, currentLevel);
                }
                currentLevel += ((FortuneAdjustment)FortuneAdjustment.EVENT.invoker()).getFortuneAdjustment(stack, reference, context, currentLevel);
            }
        }
        return currentLevel;
    }

    public static TriState isPiglinsNeutral(class_1309 entity) {
        TriState state = TriState.DEFAULT;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                PiglinNeutralInducer inducer;
                SlotReference reference = entryRef.reference();
                class_1799 stack = entryRef.stack();
                Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
                if (accessory instanceof PiglinNeutralInducer && (state = (inducer = (PiglinNeutralInducer)((Object)accessory)).makePiglinsNeutral(stack, reference)) != TriState.DEFAULT) {
                    return state;
                }
                state = ((PiglinNeutralInducer)PiglinNeutralInducer.EVENT.invoker()).makePiglinsNeutral(stack, reference);
                if (state != TriState.DEFAULT) {
                    return state;
                }
                if (!stack.method_31573(class_3489.field_54058)) continue;
                return TriState.TRUE;
            }
        }
        return state;
    }

    public static TriState allowWalkingOnSnow(class_1309 entity) {
        TriState state = TriState.DEFAULT;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                AllowWalkingOnSnow event;
                SlotReference reference = entryRef.reference();
                class_1799 stack = entryRef.stack();
                Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
                if (accessory instanceof AllowWalkingOnSnow && (state = (event = (AllowWalkingOnSnow)((Object)accessory)).allowWalkingOnSnow(stack, reference)) != TriState.DEFAULT) {
                    return state;
                }
                state = ((AllowWalkingOnSnow)AllowWalkingOnSnow.EVENT.invoker()).allowWalkingOnSnow(stack, reference);
                if (state == TriState.DEFAULT) continue;
                return state;
            }
        }
        return state;
    }

    public static TriState canFreezeEntity(class_1309 entity) {
        TriState state = TriState.DEFAULT;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                ShouldFreezeEntity check;
                SlotReference reference = entryRef.reference();
                class_1799 stack = entryRef.stack();
                Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
                if (accessory instanceof ShouldFreezeEntity && (state = (check = (ShouldFreezeEntity)((Object)accessory)).shouldFreeze(stack, reference)) != TriState.DEFAULT) {
                    return state;
                }
                state = ((ShouldFreezeEntity)ShouldFreezeEntity.EVENT.invoker()).shouldFreeze(stack, reference);
                if (state != TriState.DEFAULT) {
                    return state;
                }
                if (!stack.method_31573(class_3489.field_28041)) continue;
                return TriState.FALSE;
            }
        }
        return state;
    }

    public static TriState isGazedBlocked(class_1309 lookingEntity, class_1309 targetEntity) {
        if (lookingEntity.method_5864().method_20210(AccessoriesTags.GAZE_DISGUISED_BLACKLIST)) {
            return TriState.DEFAULT;
        }
        Map cache = (Map)gazeDisguiseCache.getIfPresent((Object)targetEntity.method_5628());
        if (cache != null && cache.containsKey(lookingEntity.method_5628())) {
            return (TriState)cache.get(lookingEntity.method_5628());
        }
        TriState state = TriState.DEFAULT;
        AccessoriesCapability capability = AccessoriesCapability.get(targetEntity);
        if (capability != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                IsGazeDisguised masked;
                SlotReference reference = entryRef.reference();
                class_1799 stack = entryRef.stack();
                Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
                if (accessory instanceof IsGazeDisguised && (state = (masked = (IsGazeDisguised)((Object)accessory)).isWearDisguise(lookingEntity, stack, reference)) != TriState.DEFAULT) {
                    return state;
                }
                state = ((IsGazeDisguised)IsGazeDisguised.EVENT.invoker()).isWearDisguise(lookingEntity, stack, reference);
                if (state != TriState.DEFAULT) {
                    return state;
                }
                if (!stack.method_31573(class_3489.field_54554)) continue;
                return TriState.TRUE;
            }
        }
        ((Map)gazeDisguiseCache.getUnchecked((Object)targetEntity.method_5628())).put(lookingEntity.method_5628(), state);
        return state;
    }
}

