/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.menu;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.events.AllowEntityModificationCallback;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import io.wispforest.accessories.menu.SlotTypeAccessible;
import io.wispforest.accessories.pond.AccessoriesLivingEntityExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AccessoriesBasedSlot
extends class_1735
implements SlotTypeAccessible {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final class_1309 entity;
    public final AccessoriesContainer accessoriesContainer;

    public AccessoriesBasedSlot(AccessoriesContainer accessoriesContainer, ExpandedContainer container, int slot, int x, int y) {
        super((class_1263)container, slot, x, y);
        this.accessoriesContainer = accessoriesContainer;
        this.entity = accessoriesContainer.capability().entity();
    }

    @Nullable
    public static AccessoriesBasedSlot of(class_1309 livingEntity, SlotType slotType, int x, int y) {
        return AccessoriesBasedSlot.of(livingEntity, slotType, 0, x, y);
    }

    @Nullable
    public static AccessoriesBasedSlot of(class_1309 livingEntity, SlotType slotType, int slot, int x, int y) {
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        if (capability == null) {
            LOGGER.error("Unable to locate a capability for the given livingEntity meaning it does not have a valid Accessory Inventory [EntityType: {}]", (Object)livingEntity.method_5864());
            return null;
        }
        Map<String, SlotType> validEntitySlots = EntitySlotLoader.getEntitySlots(livingEntity);
        if (!validEntitySlots.containsKey(slotType.name())) {
            LOGGER.error("Unable to create Accessory Slot due to the given LivingEntity not having the given SlotType bound to it! [EntityType: {}, SlotType: {}]", (Object)livingEntity.method_5864(), (Object)slotType.name());
            return null;
        }
        AccessoriesContainer container = capability.getContainer(slotType);
        if (container == null) {
            LOGGER.error("Unable to locate the given container for the passed slotType. [SlotType:{}]", (Object)slotType.name());
            return null;
        }
        return new AccessoriesBasedSlot(container, container.getAccessories(), slot, x, y);
    }

    @Override
    public AccessoriesContainer getContainer() {
        return this.accessoriesContainer;
    }

    @Override
    public int index() {
        return this.field_7874;
    }

    @Deprecated
    public int method_7675() {
        return super.method_7675();
    }

    public int method_7676(class_1799 stack) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        return accessory.maxStackSize(stack);
    }

    public void method_7673(class_1799 stack) {
        super.method_7673(stack);
    }

    public void method_48931(class_1799 newStack, class_1799 oldStack) {
        ((AccessoriesLivingEntityExtension)this.entity).onEquipItem(this.accessoriesContainer.createReference(this.method_34266()), oldStack, newStack);
        super.method_48931(newStack, oldStack);
    }

    public boolean method_7680(class_1799 stack) {
        return SlotPredicateRegistry.canInsertIntoSlot(stack, SlotReference.of(this.entity, this.accessoriesContainer.getSlotName(), this.method_34266()));
    }

    public boolean method_7674(class_1657 player) {
        if (!this.entity.equals((Object)player)) {
            SlotReference ref = this.accessoriesContainer.createReference(this.method_34266());
            TriState result = ((AllowEntityModificationCallback)AllowEntityModificationCallback.EVENT.invoker()).allowModifications(this.entity, player, ref);
            if (!result.orElse(false)) {
                return false;
            }
        }
        return AccessoryRegistry.canUnequip(this.method_7677(), SlotReference.of(this.entity, this.accessoriesContainer.getSlotName(), this.method_34266()));
    }

    public class_2960 method_7679() {
        SlotType slotType = this.accessoriesContainer.slotType();
        return slotType != null ? slotType.icon() : SlotType.EMPTY_SLOT_ICON;
    }

    public List<class_2561> getTooltipData() {
        ArrayList<class_2561> tooltipData = new ArrayList<class_2561>();
        SlotType slotType = this.accessoriesContainer.slotType();
        tooltipData.add((class_2561)class_2561.method_43471((String)Accessories.translationKey("slot.tooltip.singular")).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)slotType.translation()).method_27692(class_124.field_1078)));
        return tooltipData;
    }
}

