/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.AccessoriesRenderStateKeys;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderState;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.client.AccessoriesFunkyRenderingState;
import io.wispforest.accessories.client.AccessoryRendererErrorCache;
import io.wispforest.accessories.client.gui.AccessoriesScreenBase;
import io.wispforest.accessories.compat.config.AccessoriesConfig;
import io.wispforest.accessories.menu.AccessoriesInternalSlot;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_11659;
import net.minecraft.class_11890;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_746;
import org.joml.Vector3d;

public class AccessoriesRenderLayer<S extends class_10042, M extends class_583<S>>
extends class_3887<S, M> {
    private static final float increment = 0.1f;
    private static final Map<SlotPath, Float> brightnessMap = new HashMap<SlotPath, Float>();
    private static final Map<SlotPath, Float> opacityMap = new HashMap<SlotPath, Float>();
    private static long lastUpdated20th = 0L;

    public AccessoriesRenderLayer(class_3883<S, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void submit(class_4587 poseStack, class_11659 submitNodeCollector, int light, S entityState, float f, float g) {
        AccessoriesInternalSlot accessoriesInternalSlot;
        class_437 class_4372;
        boolean shouldUpdate;
        class_310 client = class_310.method_1551();
        Map states = (Map)entityState.getStateData(AccessoriesRenderStateKeys.ACCESSORY_RENDER_STATES);
        if (states == null) {
            return;
        }
        entityState.setStateData(AccessoriesRenderStateKeys.LIGHT, (Object)light);
        AccessoriesFunkyRenderingState funkyRenderState = AccessoriesFunkyRenderingState.INSTANCE;
        boolean isRenderingLineTarget = funkyRenderState.isIsRenderingLineTarget();
        boolean renderingLines = funkyRenderState.isCollectAccessoryPositions();
        Map<SlotPath, Vector3d> positions = funkyRenderState.getNotVeryNicePositions();
        if (!renderingLines && !positions.isEmpty()) {
            positions.clear();
        }
        float scale = (float)(1.0 + 0.5 * (0.75 + Math.sin((double)System.currentTimeMillis() / 250.0)));
        Calendar calendar = Calendar.getInstance();
        long current20th = calendar.getTimeInMillis() / 50L;
        boolean bl = shouldUpdate = lastUpdated20th != current20th;
        if (shouldUpdate) {
            lastUpdated20th = current20th;
        }
        if ((class_4372 = client.field_1755) instanceof AccessoriesScreenBase) {
            AccessoriesScreenBase screenBase = (AccessoriesScreenBase)class_4372;
            accessoriesInternalSlot = screenBase.getSelectedSlotIf(AccessoriesInternalSlot.class);
        } else {
            accessoriesInternalSlot = null;
        }
        AccessoriesInternalSlot selected = accessoriesInternalSlot;
        boolean preventHovering = selected != null && selected.method_7677().method_7960();
        AccessoriesConfig.ScreenOptions_.UnHoveredOptions_ unHoveredOptions = Accessories.config().screenOptions.unHoveredOptions;
        AccessoriesConfig.ScreenOptions_.HoveredOptions_ hoveredOptions = Accessories.config().screenOptions.hoveredOptions;
        boolean isFunnyDate = calendar.get(2) + 1 == 5 && calendar.get(5) == 16;
        SlotPath selectedPath = selected != null ? selected.slotPath() : null;
        states.forEach((path, accessoryRenderState) -> {
            boolean isSelected = path.equals(selectedPath);
            if (shouldUpdate) {
                Float currentBrightness = brightnessMap.getOrDefault(path, Float.valueOf(1.0f));
                Float currentOpacity = opacityMap.getOrDefault(path, Float.valueOf(1.0f));
                if (selectedPath != null && !isSelected && !preventHovering) {
                    brightnessMap.put((SlotPath)path, Float.valueOf(Math.max(unHoveredOptions.darkenedBrightness(), currentBrightness.floatValue() - 0.1f)));
                    opacityMap.put((SlotPath)path, Float.valueOf(Math.max(unHoveredOptions.darkenedOpacity(), currentOpacity.floatValue() - 0.1f)));
                } else {
                    brightnessMap.put((SlotPath)path, Float.valueOf(Math.min(1.0f, currentBrightness.floatValue() + 0.1f)));
                    opacityMap.put((SlotPath)path, Float.valueOf(Math.min(1.0f, currentOpacity.floatValue() + 0.1f)));
                }
            }
            class_1799 stack = accessoryRenderState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);
            AccessoryRenderer renderer = AccessoriesRendererRegistry.getRenderer(stack);
            if (isSelected || selectedPath == null || unHoveredOptions.renderUnHovered()) {
                poseStack.method_22903();
                try {
                    renderer.render((AccessoryRenderState)accessoryRenderState, entityState, this.method_17165(), poseStack, submitNodeCollector);
                }
                catch (Throwable e) {
                    AccessoryRendererErrorCache.logIfTimeAllotted(entityState.getEntityUUIDForState(), stack, renderer, e);
                }
                poseStack.method_22909();
            }
        });
    }

    public static <A extends class_11890> void submitFirstPersonAsClientPlayer(class_1007<A> avatarRender, class_572<class_10055> model, class_4587 matrices, int combinedLight, class_11659 submitNodeCollector, class_1306 arm) {
        class_746 player = class_310.method_1551().field_1724;
        AccessoriesRenderLayer.submitFirstPerson(player, avatarRender, model, matrices, combinedLight, submitNodeCollector, arm);
    }

    public static <A extends class_11890> void submitFirstPerson(A entity, class_1007<A> avatarRender, class_572<class_10055> model, class_4587 matrices, int combinedLight, class_11659 submitNodeCollector, class_1306 arm) {
        class_1937 level = entity.method_73183();
        float partialTicks = class_310.method_1551().method_61966().method_60637(!level.method_54719().method_54746(entity));
        class_10055 entityState = (class_10055)avatarRender.method_62425(entity, partialTicks);
        entityState.setStateData(AccessoriesRenderStateKeys.LIGHT, (Object)combinedLight);
        AccessoriesRenderStateKeys.setupStateForAccessories((class_10017)entityState, entity, partialTicks, arm);
        Map states = (Map)entityState.getStateData(AccessoriesRenderStateKeys.ACCESSORY_RENDER_STATES);
        if (states == null) {
            return;
        }
        states.forEach((slotPath, accessoryRenderState) -> {
            matrices.method_22903();
            class_1799 stack = accessoryRenderState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);
            AccessoryRenderer renderer = AccessoriesRendererRegistry.getRenderer(stack);
            try {
                renderer.render((AccessoryRenderState)accessoryRenderState, entityState, model, matrices, submitNodeCollector);
            }
            catch (Throwable e) {
                AccessoryRendererErrorCache.logIfTimeAllotted(entityState.getEntityUUIDForState(), stack, renderer, e);
            }
            matrices.method_22909();
        });
    }
}

