/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui.components;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.client.DrawUtils;
import io.wispforest.accessories.client.gui.AccessoriesScreen;
import io.wispforest.accessories.client.gui.components.ArrowComponent;
import io.wispforest.accessories.menu.SlotTypeAccessible;
import io.wispforest.accessories.menu.variants.AccessoriesMenu;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.server.SyncCosmeticToggle;
import io.wispforest.accessories.pond.ScissorStackManipulation;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.util.NinePatchTexture;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_1058;
import net.minecraft.class_10725;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class ComponentUtils {
    private static final class_2960 SLOT = class_2960.method_60656((String)"textures/gui/sprites/container/slot.png");
    private static final class_2960 DARK_SLOT = Accessories.of("textures/gui/theme/dark/slot.png");
    public static final Surface BACKGROUND_SLOT_RENDERING_SURFACE = (context, component) -> {
        ArrayList<AccessoriesScreen.ExtendedSlotComponent> slotComponents = new ArrayList<AccessoriesScreen.ExtendedSlotComponent>();
        ComponentUtils.recursiveSearchSlots(component, slotComponents::add);
        context.push().translate((float)component.x(), (float)component.y());
        class_2960 texture = ComponentUtils.getSlotTexture();
        for (AccessoriesScreen.ExtendedSlotComponent slotComponent : slotComponents) {
            DrawUtils.blit((class_332)context, texture, slotComponent.x() - component.x() - 1, slotComponent.y() - component.y() - 1, 18, 18);
        }
        context.pop();
        ComponentUtils.renderSpectrumOutlines(context, slotComponents);
    };
    public static final Surface SPECTRUM_SLOT_OUTLINE = (context, component) -> {
        ArrayList<AccessoriesScreen.ExtendedSlotComponent> slotComponents = new ArrayList<AccessoriesScreen.ExtendedSlotComponent>();
        ComponentUtils.recursiveSearchSlots(component, slotComponents::add);
        ComponentUtils.renderSpectrumOutlines(context, slotComponents);
    };
    public static final ScrollContainer.Scrollbar VANILLA = (context, x, y, width, height, trackX, trackY, trackWidth, trackHeight, lastInteractTime, direction, active) -> {
        NinePatchTexture.draw((class_2960)Accessories.of("theme/" + ComponentUtils.checkMode("light", "dark") + "/scrollbar/track"), (OwoUIDrawContext)context, (int)trackX, (int)trackY, (int)trackWidth, (int)trackHeight);
        NinePatchTexture.draw((class_2960)ComponentUtils.getScrollabarTexture(direction, active), (OwoUIDrawContext)context, (int)(x + 1), (int)(y + 1), (int)(width - 2), (int)(height - 2));
    };
    public static final Surface PANEL_INSET = (context, component) -> NinePatchTexture.draw((class_2960)Accessories.of("theme/" + ComponentUtils.checkMode("light", "dark") + "/inset"), (OwoUIDrawContext)context, (PositionedRectangle)component);
    public static final Surface PANEL = (context, component) -> NinePatchTexture.draw((class_2960)Accessories.of("theme/" + ComponentUtils.checkMode("light", "dark") + "/panel"), (OwoUIDrawContext)context, (PositionedRectangle)component);
    private static final ButtonComponent.Renderer BUTTON_RENDERER = (context, button, delta) -> NinePatchTexture.draw((class_2960)ComponentUtils.getBtnTexture(button), (OwoUIDrawContext)context, (int)button.method_46426(), (int)button.method_46427(), (int)button.width(), (int)button.height());
    private static final Map<Object, ThemeHook<?, ?>> activeHooks = new WeakHashMap();
    private static boolean hookSetup = false;

    public static void renderSpectrumOutlines(OwoUIDrawContext context, List<AccessoriesScreen.ExtendedSlotComponent> slotComponents) {
        for (AccessoriesScreen.ExtendedSlotComponent slotComponent : slotComponents) {
            SlotTypeAccessible slotTypeAccessible;
            class_1735 slot = slotComponent.slot();
            if (!(slot instanceof SlotTypeAccessible) || !(slotTypeAccessible = (SlotTypeAccessible)slot).isCosmeticSlot()) continue;
            DrawUtils.drawRectOutlineWithSpectrum(context, slotComponent.x(), slotComponent.y(), 16, 16, 0.35f, false);
        }
    }

    public static class_2960 getScrollabarTexture(ScrollContainer.ScrollDirection direction, boolean active) {
        String scrollBarType = (direction == ScrollContainer.ScrollDirection.VERTICAL ? "vertical" : "horizontal") + (active ? "" : "_disabled");
        String themeType = ComponentUtils.checkMode("light", "dark");
        return Accessories.of("theme/" + themeType + "/scrollbar/vanilla_" + scrollBarType);
    }

    private static class_2960 getBtnTexture(ButtonComponent btn) {
        String btnType = btn.method_37303() ? (btn.method_49606() ? "hovered" : "active") : "disabled";
        String themeType = ComponentUtils.checkMode("light", "dark");
        return Accessories.of("theme/" + themeType + "/button/" + btnType);
    }

    public static <T> T checkMode(T lightMode, T darkMode) {
        return Accessories.config().screenOptions.isDarkMode() ? darkMode : lightMode;
    }

    public static <O, T> void addModeCheckHook(T lightMode, T darkMode, O o, Predicate<O> isValidStill, BiConsumer<O, T> setCallback) {
        Function<Boolean, Object> getterFunc = isDarkMode -> isDarkMode != false ? darkMode : lightMode;
        activeHooks.put(o, new ThemeHook<O, T>(isValidStill, setCallback));
        if (!hookSetup) {
            hookSetup = true;
            Accessories.config().screenOptions.subscribeToIsDarkMode(isDarkMode -> {
                for (Object object : activeHooks.keySet()) {
                    ThemeHook<?, ?> hook = activeHooks.get(object);
                    if (!hook.isHookValid(object)) {
                        activeHooks.remove(object);
                        continue;
                    }
                    hook.setValue(object, getterFunc.apply((Boolean)isDarkMode));
                }
            });
        }
        setCallback.accept(o, getterFunc.apply(Accessories.config().screenOptions.isDarkMode()));
    }

    public static class_2960 getSlotTexture() {
        return ComponentUtils.checkMode(SLOT, DARK_SLOT);
    }

    public static Surface getPanelSurface() {
        return PANEL;
    }

    public static Surface getInsetPanelSurface() {
        return PANEL_INSET;
    }

    public static Surface getPanelWithInset(int insetWidth) {
        return (context, component) -> {
            class_2960 location = Accessories.of("theme/" + ComponentUtils.checkMode("light", "dark") + "/inset");
            NinePatchTexture.draw((class_2960)location, (OwoUIDrawContext)context, (int)(component.x() + insetWidth), (int)(component.y() + insetWidth), (int)(component.width() - insetWidth * 2), (int)(component.height() - insetWidth * 2));
        };
    }

    public static ButtonComponent.Renderer getButtonRenderer() {
        return BUTTON_RENDERER;
    }

    public static ScrollContainer.Scrollbar getScrollbarRenderer() {
        return VANILLA;
    }

    public static void recursiveSearchSlots(ParentComponent parentComponent, Consumer<AccessoriesScreen.ExtendedSlotComponent> action) {
        ComponentUtils.recursiveSearch(parentComponent, AccessoriesScreen.ExtendedSlotComponent.class, action);
    }

    public static <C extends Component> void recursiveSearch(ParentComponent parentComponent, Class<C> target, Consumer<C> action) {
        if (parentComponent == null) {
            return;
        }
        for (Component child : parentComponent.children()) {
            if (target.isInstance(child)) {
                action.accept(child);
            }
            if (!(child instanceof ParentComponent)) continue;
            ParentComponent childParent = (ParentComponent)child;
            ComponentUtils.recursiveSearch(childParent, target, action);
        }
    }

    public static <S extends class_1735> Pair<Component, PositionedRectangle> createSlotWithToggle(S slot, Function<Integer, AccessoriesScreen.ExtendedSlotComponent> slotBuilder) {
        return ComponentUtils.createSlotWithToggle(slot, slotBuilder, true);
    }

    public static <S extends class_1735> Pair<Component, @Nullable PositionedRectangle> createSlotWithToggle(S slot, Function<Integer, AccessoriesScreen.ExtendedSlotComponent> slotBuilder, boolean createButton) {
        Positioning btnPosition = Positioning.absolute((int)14, (int)-1);
        ButtonComponent toggleBtn = null;
        if (createButton) {
            toggleBtn = (ButtonComponent)ComponentUtils.createSlotToggle(slot).configure(component -> component.sizing(Sizing.fixed((int)5)).positioning(btnPosition));
        }
        FlowLayout combinedLayout = Containers.verticalFlow((Sizing)Sizing.fixed((int)18), (Sizing)Sizing.fixed((int)18)).child((Component)slotBuilder.apply(slot.field_7874).margins(Insets.of((int)1)));
        if (toggleBtn != null) {
            combinedLayout.child((Component)toggleBtn);
        }
        return Pair.of((Object)combinedLayout, (Object)toggleBtn);
    }

    public static <S extends class_1735> ButtonComponent createSlotToggle(S slot) {
        return ComponentUtils.createToggle(() -> ((SlotTypeAccessible)slot).getContainer().shouldRender(slot.method_34266()), btn -> {
            class_1309 entity = ((SlotTypeAccessible)slot).getContainer().capability().entity();
            AccessoriesNetworking.sendToServer(SyncCosmeticToggle.of(entity.equals((Object)class_310.method_1551().field_1724) ? null : entity, ((SlotTypeAccessible)slot).slotType(), slot.method_34266()));
        }, (context, button, delta) -> {});
    }

    public static Component createGroupToggle(AccessoriesScreen screen, SlotGroup group) {
        ArrayList<class_5250> tooltipData = new ArrayList<class_5250>();
        tooltipData.add(class_2561.method_43471((String)group.translation()));
        if (UniqueSlotHandling.isUniqueGroup(group.name(), true)) {
            tooltipData.add(class_2561.method_43470((String)group.name()).method_27695(new class_124[]{class_124.field_1078, class_124.field_1056}));
        }
        return ComponentUtils.createToggle(() -> ((AccessoriesMenu)screen.method_17577()).isGroupSelected(group), buttonComponent -> {
            ((AccessoriesMenu)screen.method_17577()).toggleSelectedGroup(group);
            screen.rebuildAccessoriesComponent();
        }, (context, button, delta) -> {
            class_1058 textureAtlasSprite = class_310.method_1551().method_72703().method_73025(class_10725.field_56385).method_4608(group.icon());
            DrawUtils.blitSpriteWithColor((class_332)context, textureAtlasSprite, button.x() + 3, button.y() + 3, 8, 8, Color.WHITE);
        }).sizing(Sizing.fixed((int)14)).tooltip(tooltipData);
    }

    public static ButtonComponent createToggle(Supplier<Boolean> stateSupplier, Consumer<ButtonComponent> onToggle, ButtonComponent.Renderer extraRendering) {
        ButtonComponent.Renderer texturedRenderer = (context, btn, delta) -> {
            Boolean state = (Boolean)stateSupplier.get();
            String btnType = (state != false ? "enabled" : "disabled") + (btn.method_49606() ? "_hovered" : "");
            String themeType = ComponentUtils.checkMode("light", "dark");
            class_2960 texture = Accessories.of("theme/" + themeType + "/button/toggle/rounded/" + btnType);
            context.push();
            Runnable drawCall = () -> {
                NinePatchTexture.draw((class_2960)texture, (OwoUIDrawContext)context, (int)btn.method_46426(), (int)btn.method_46427(), (int)btn.width(), (int)btn.height());
                extraRendering.draw(context, btn, delta);
            };
            ((ScissorStackManipulation)context).accessories$renderWithoutAny(drawCall);
            context.pop();
        };
        return Components.button((class_2561)class_2561.method_43473(), onToggle).renderer(texturedRenderer);
    }

    public static Component createIconButton(Consumer<ButtonComponent> action, int size, Consumer<ButtonComponent> builder, Function<ButtonComponent, class_2960> textureGetter) {
        return ComponentUtils.createIconButton(action, size, null, builder, (context, buttonComponent) -> (class_2960)textureGetter.apply((ButtonComponent)buttonComponent));
    }

    public static Component createIconButton(Consumer<ButtonComponent> action, int size, Consumer<ButtonComponent> builder, BiFunction<OwoUIDrawContext, ButtonComponent, class_2960> textureGetter) {
        return ComponentUtils.createIconButton(action, size, null, builder, textureGetter);
    }

    public static Component createIconButton(Consumer<ButtonComponent> action, int size, String id, Consumer<ButtonComponent> builder, BiFunction<OwoUIDrawContext, ButtonComponent, class_2960> textureGetter) {
        return Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(((ButtonComponent)Components.button((class_2561)class_2561.method_43473(), action).sizing(Sizing.fixed((int)size)).configure(builder)).renderer((ctx, btn, delta) -> {
            ctx.push();
            DrawUtils.blit((class_332)ctx, (class_2960)textureGetter.apply(ctx, btn), btn.method_46426(), btn.method_46427(), btn.width(), btn.height());
            ctx.pop();
        }).id(id));
    }

    public static <C extends BaseOwoHandledScreen.SlotComponent> Component createCraftingComponent(int start, Function<Integer, C> componentFactory, Consumer<Integer> slotEnabler, boolean isVertical) {
        for (int i = start; i < 5 + start; ++i) {
            slotEnabler.accept(i);
        }
        FlowLayout craftingLayout = isVertical ? Containers.verticalFlow((Sizing)Sizing.fixed((int)36), (Sizing)Sizing.content()) : Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)36));
        craftingLayout.child((Component)(!isVertical ? Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()) : Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content())).child((Component)((BaseOwoHandledScreen.SlotComponent)componentFactory.apply(start + 1)).margins(Insets.of((int)1))).child((Component)((BaseOwoHandledScreen.SlotComponent)componentFactory.apply(start + 2)).margins(Insets.of((int)1)))).child((Component)(!isVertical ? Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()) : Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content())).child((Component)((BaseOwoHandledScreen.SlotComponent)componentFactory.apply(start + 3)).margins(Insets.of((int)1))).child((Component)((BaseOwoHandledScreen.SlotComponent)componentFactory.apply(start + 4)).margins(Insets.of((int)1)))).child(new ArrowComponent(isVertical ? ArrowComponent.Direction.DOWN : ArrowComponent.Direction.RIGHT).centered(true).margins(Insets.of((int)3, (int)3, (int)1, (int)1)).id("crafting_arrow")).child((Component)(!isVertical ? Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.expand()) : Containers.horizontalFlow((Sizing)Sizing.expand(), (Sizing)Sizing.content())).child((Component)((BaseOwoHandledScreen.SlotComponent)componentFactory.apply(start)).margins(Insets.of((int)1))).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER)).allowOverflow(true).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        return Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)craftingLayout).padding(Insets.of((int)7, (int)7, (int)4, (int)7));
    }

    public static <C extends BaseOwoHandledScreen.SlotComponent> Component createPlayerInv(int start, int end, Function<Integer, C> componentFactory, Consumer<Integer> slotEnabler) {
        FlowLayout playerLayout = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        int row = 0;
        FlowLayout rowLayout = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).configure(layout -> layout.allowOverflow(true));
        int rowCount = 0;
        for (int i = start; i < end; ++i) {
            BaseOwoHandledScreen.SlotComponent slotComponent = (BaseOwoHandledScreen.SlotComponent)componentFactory.apply(i);
            slotEnabler.accept(i);
            rowLayout.child((Component)slotComponent.margins(Insets.of((int)1)));
            if (row >= 8) {
                playerLayout.child((Component)rowLayout);
                rowLayout = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).configure(layout -> layout.allowOverflow(true));
                if (++rowCount == 3) {
                    rowLayout.margins(Insets.top((int)4));
                }
                row = 0;
                continue;
            }
            ++row;
        }
        return playerLayout.allowOverflow(true);
    }

    private record ThemeHook<O, T>(Predicate<O> isValidStill, BiConsumer<O, T> setCallback) {
        private boolean isHookValid(Object hookedObject) {
            return this.isValidStill.test(hookedObject);
        }

        private void setValue(Object hookedObject, Object themeResult) {
            this.setCallback.accept(hookedObject, themeResult);
        }
    }

    public static interface OnCreativeTabChange {
        public void onTabChange(class_1761 var1);
    }

    public static interface CreativeScreenExtension {
        public Event<OnCreativeTabChange> getEvent();

        public class_1761 getTab();
    }
}

