/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui.components;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.client.gui.AccessoriesScreen;
import io.wispforest.accessories.client.gui.components.AccessoriesContainingLayout;
import io.wispforest.accessories.client.gui.components.ComponentUtils;
import io.wispforest.accessories.impl.option.PlayerOptions;
import io.wispforest.accessories.menu.variants.AccessoriesMenu;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.util.Observable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class PaginatedAccessoriesLayout
extends AccessoriesContainingLayout<RawPageData> {
    private Observable<Integer> pageIndex;

    private PaginatedAccessoriesLayout(AccessoriesScreen screen, RawPageData data) {
        super(screen, data);
    }

    @Nullable
    public static PaginatedAccessoriesLayout createOrNull(AccessoriesScreen screen) {
        RawPageData data = PaginatedAccessoriesLayout.buildPageData(screen);
        if (data == null) {
            return null;
        }
        return new PaginatedAccessoriesLayout(screen, data);
    }

    @Nullable
    private static RawPageData buildPageData(AccessoriesScreen screen) {
        AccessoriesMenu menu = (AccessoriesMenu)screen.method_17577();
        List<class_1735> slots = menu.getVisibleAccessoriesSlots();
        Boolean sideBySide = (Boolean)screen.getDefaultedData(PlayerOptions.SIDE_BY_SIDE_SLOTS);
        Integer maxColumnCount = (Integer)screen.getDefaultedData(PlayerOptions.COLUMN_AMOUNT);
        int maxRowCount = 6;
        int totalRowCount = (int)Math.ceil((float)slots.size() / 2.0f / (float)maxColumnCount.intValue());
        if (totalRowCount <= 0) {
            return null;
        }
        int pageCount = 1;
        if (totalRowCount > 7) {
            pageCount = (int)Math.ceil((float)totalRowCount / (float)maxRowCount);
        } else {
            maxRowCount = 7;
        }
        int pageStartingSlotIndex = 0;
        LinkedHashMap<Integer, AccessoriesContainingLayout.BaseLayoutGroup> slotPages = new LinkedHashMap<Integer, AccessoriesContainingLayout.BaseLayoutGroup>();
        for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
            if (pageIndex != 0) {
                pageStartingSlotIndex += maxRowCount * maxColumnCount * 2;
            }
            int rowCount = totalRowCount < 0 ? maxRowCount + totalRowCount : maxRowCount;
            totalRowCount -= maxRowCount;
            slotPages.put(pageIndex, PaginatedAccessoriesLayout.createBaseLayoutGroup(screen, slots, rowCount, maxColumnCount, pageStartingSlotIndex, sideBySide));
        }
        return new RawPageData(slotPages, maxColumnCount, maxRowCount, sideBySide);
    }

    @Override
    protected AccessoriesContainingLayout.BaseLayoutGroup getCurrentGroup() {
        return this.getCurrentPageOrDefault();
    }

    @Override
    protected void buildLayout(RawPageData layoutData) {
        int minimumLayoutHeight = layoutData.height() + (layoutData.pages().size() > 1 ? 30 : 0);
        AccessoriesContainingLayout.BaseLayoutGroup currentPage = this.getCurrentPageOrDefault();
        FlowLayout holder = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).configure(layout -> layout.gap(3).id("accessories_container_holder"));
        if (layoutData.sideBySide) {
            holder.child((Component)currentPage.getLayout(false));
            if (this.screen.showCosmeticState()) {
                holder.child(0, (Component)currentPage.getLayout(this.screen.showCosmeticState()));
            }
        } else {
            holder.child((Component)currentPage.getLayout(this.screen.showCosmeticState()));
        }
        FlowLayout accessoriesMainLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(2).child((Component)holder).horizontalAlignment(HorizontalAlignment.RIGHT).surface(ComponentUtils.getPanelSurface().and(ComponentUtils.BACKGROUND_SLOT_RENDERING_SURFACE)).padding(Insets.of((int)7)).id("accessories_layout");
        if (layoutData.pages().size() <= 1) {
            this.child((Component)accessoriesMainLayout);
            return;
        }
        LabelComponent pageLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)((Integer)this.pageIndex().get() + 1 + "/" + layoutData.pages().size()))).configure(labelComponent -> ComponentUtils.addModeCheckHook(Color.ofFormatting((class_124)class_124.field_1063), Color.ofFormatting((class_124)class_124.field_1068), labelComponent, component -> component.parent() != null, LabelComponent::color));
        this.pageIndex().observe(integer -> pageLabel.text((class_2561)class_2561.method_43470((String)((Integer)this.pageIndex().get() + 1 + "/" + layoutData.pages().size()))));
        Component titleBar = Containers.horizontalFlow((Sizing)Sizing.fixed((int)currentPage.width(this.screen.showCosmeticState(), layoutData.sideBySide())), (Sizing)Sizing.content()).child((Component)Containers.horizontalFlow((Sizing)Sizing.expand((int)100), (Sizing)Sizing.content()).child((Component)pageLabel).horizontalAlignment(HorizontalAlignment.CENTER)).child(ComponentUtils.createIconButton(btn -> this.switchPage(-1), 10, btn -> btn.mouseScroll().subscribe((mouseX, mouseY, amount) -> {
            this.switchPage((int)Math.round(amount));
            return true;
        }), btn -> Accessories.of("textures/gui/accessories_back_icon" + (btn.method_49606() ? "_hovered" : "") + ".png")).margins(Insets.of((int)0, (int)0, (int)0, (int)2))).child(ComponentUtils.createIconButton(btn -> this.switchPage(1), 10, btn -> btn.mouseScroll().subscribe((mouseX, mouseY, amount) -> {
            this.switchPage((int)Math.round(amount));
            return true;
        }), (ctx, btn) -> {
            ctx.getMatrixStack().rotateAbout((float)Math.toRadians(180.0), (float)btn.method_46426() + (float)btn.width() / 2.0f, (float)btn.method_46427() + (float)btn.height() / 2.0f);
            return Accessories.of("textures/gui/accessories_back_icon" + (btn.method_49606() ? "_hovered" : "") + ".png");
        }).margins(Insets.of((int)0, (int)0, (int)0, (int)0))).horizontalAlignment(HorizontalAlignment.RIGHT).verticalAlignment(VerticalAlignment.CENTER).id("page_title_bar");
        accessoriesMainLayout.child(0, titleBar);
        this.sizing(Sizing.content(), Sizing.fixed((int)minimumLayoutHeight));
        this.child((Component)accessoriesMainLayout);
        this.child((Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.expand()));
    }

    private void switchPage(int pageOffset) {
        this.switchPage((Integer)this.pageIndex().get() + pageOffset, this.screen.showCosmeticState());
    }

    private void switchPage(int nextPageIndex, boolean showCosmeticState) {
        if (nextPageIndex >= 0 && nextPageIndex < ((RawPageData)this.layoutData).pages().size()) {
            Integer prevPageIndex = (Integer)this.pageIndex().get();
            this.pageIndex().set((Object)nextPageIndex);
            AccessoriesContainingLayout.BaseLayoutGroup prevGroup = ((RawPageData)this.layoutData).pages().get(prevPageIndex);
            AccessoriesContainingLayout.BaseLayoutGroup currentGroup = ((RawPageData)this.layoutData).pages.get(nextPageIndex);
            FlowLayout titleBarComponent = (FlowLayout)this.childById(FlowLayout.class, "page_title_bar");
            FlowLayout gridContainer = (FlowLayout)titleBarComponent.parent().childById(FlowLayout.class, "accessories_container_holder");
            boolean sideBySide = ((RawPageData)this.layoutData).sideBySide();
            titleBarComponent.horizontalSizing(Sizing.fixed((int)currentGroup.width(showCosmeticState, sideBySide)));
            Consumer<Boolean> consumer = isCosmetic -> {
                FlowLayout lastGrid = prevGroup.getLayout((boolean)isCosmetic);
                FlowLayout activeGrid = currentGroup.getLayout((boolean)isCosmetic);
                ComponentUtils.recursiveSearchSlots((ParentComponent)lastGrid, slotComponent -> this.screen.hideSlot(slotComponent.slot()));
                gridContainer.removeChild((Component)lastGrid);
                gridContainer.child(0, (Component)activeGrid);
            };
            if (sideBySide) {
                consumer.accept(false);
                if (showCosmeticState) {
                    consumer.accept(true);
                }
            } else {
                consumer.accept(showCosmeticState);
            }
            this.updatePadding();
        }
    }

    public Observable<Integer> pageIndex() {
        if (this.pageIndex == null) {
            this.pageIndex = Observable.of((Object)0);
        }
        return this.pageIndex;
    }

    private AccessoriesContainingLayout.BaseLayoutGroup getCurrentPageOrDefault() {
        return ((RawPageData)this.layoutData).pages().getOrDefault(this.pageIndex().get(), AccessoriesContainingLayout.BaseLayoutGroup.DEFAULT);
    }

    @Override
    public void onCosmeticToggle(boolean showCosmeticState) {
        FlowLayout gridContainer = (FlowLayout)this.childById(FlowLayout.class, "accessories_container_holder");
        AccessoriesContainingLayout.BaseLayoutGroup currentPage = this.getCurrentPageOrDefault();
        boolean sideBySide = ((RawPageData)this.layoutData).sideBySide;
        FlowLayout titleBarComponent = (FlowLayout)this.childById(FlowLayout.class, "page_title_bar");
        if (titleBarComponent != null) {
            titleBarComponent.horizontalSizing(Sizing.fixed((int)currentPage.width(showCosmeticState, sideBySide)));
        }
        gridContainer.clearChildren();
        int pageIndex = (Integer)this.pageIndex().get();
        int currentIndex = 0;
        for (AccessoriesContainingLayout.BaseLayoutGroup pageLayout : ((RawPageData)this.layoutData).pages().values()) {
            boolean selectedPage;
            boolean bl = selectedPage = pageIndex == currentIndex;
            if (sideBySide) {
                this.toggleSlotStates((ParentComponent)pageLayout.getLayout(true), showCosmeticState, selectedPage);
            } else {
                FlowLayout lastGrid = pageLayout.getLayout(!showCosmeticState);
                this.swapSlotStates((ParentComponent)lastGrid, (ParentComponent)pageLayout.getLayout(showCosmeticState), selectedPage);
            }
            ++currentIndex;
        }
        if (sideBySide) {
            gridContainer.child(0, (Component)currentPage.accessoriesLayout());
            if (showCosmeticState) {
                gridContainer.child(0, (Component)currentPage.cosmeticLayout());
            }
            this.screen.setupPadding();
        } else {
            FlowLayout activeGrid = currentPage.getLayout(showCosmeticState);
            gridContainer.child((Component)activeGrid);
        }
        this.updatePadding();
    }

    @Override
    protected Iterable<PositionedRectangle> getAlternativeChecks(boolean showingCosmetics) {
        return this.getCurrentPageOrDefault().getAlternativeChecks(showingCosmetics);
    }

    private void swapSlotStates(ParentComponent prevComp, ParentComponent newComp, boolean selectedPage) {
        this.toggleSlotStates(prevComp, false, selectedPage);
        this.toggleSlotStates(newComp, true, selectedPage);
    }

    private void toggleSlotStates(ParentComponent component, boolean showSlots, boolean selectedPage) {
        if (!showSlots) {
            ComponentUtils.recursiveSearchSlots(component, slotComponent -> this.screen.disableSlot(slotComponent.slot()));
        } else {
            ComponentUtils.recursiveSearchSlots(component, slotComponent -> {
                if (!selectedPage) {
                    this.screen.hideSlot(slotComponent.slot());
                }
                this.screen.enableSlot(slotComponent.slot());
            });
        }
    }

    protected record RawPageData(Map<Integer, AccessoriesContainingLayout.BaseLayoutGroup> pages, int maxColumnCount, int maxRowCount, boolean sideBySide) implements AccessoriesContainingLayout.LayoutData
    {
    }
}

