/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.attributes.SlotAttribute;
import io.wispforest.accessories.api.client.rendering.RenderingFunction;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryCustomRendererComponent;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessoryMobEffectsComponent;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.components.AccessorySlotValidationComponent;
import io.wispforest.accessories.api.components.AccessoryStackSettings;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.commands.AccessoriesItemCommands;
import io.wispforest.accessories.commands.AccessoriesMixedSlotArgument;
import io.wispforest.accessories.commands.ResourceExtendedArgument;
import io.wispforest.accessories.commands.SlotArgumentType;
import io.wispforest.accessories.commands.api.CommandGenerators;
import io.wispforest.accessories.commands.api.CommandTreeGenerator;
import io.wispforest.accessories.commands.api.base.BranchedCommandGenerator;
import io.wispforest.accessories.commands.api.base.CommandTreeBuilder;
import io.wispforest.accessories.commands.api.core.NamedArgumentGetter;
import io.wispforest.accessories.commands.api.core.RecordArgumentTypeInfo;
import io.wispforest.accessories.data.CustomRendererLoader;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.mixin.CommandSelectionAccessor;
import io.wispforest.accessories.mixin.ResourceArgumentAccessor;
import io.wispforest.endec.Endec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2178;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2240;
import net.minecraft.class_2287;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AccessoriesCommands
implements CommandTreeGenerator.Branched {
    public static final AccessoriesCommands INSTANCE = new AccessoriesCommands();
    public static final SimpleCommandExceptionType NON_LIVING_ENTITY_TARGET = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"accessories.argument.livingEntities.nonLiving"));
    public static final SimpleCommandExceptionType INVALID_SLOT_TYPE = new SimpleCommandExceptionType((Message)new LiteralMessage("Invalid Slot Type"));
    public static final SimpleCommandExceptionType ERROR_CAPABILITY_MISSING = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Unable to get the needed capability from the given target!"));
    public static final DynamicCommandExceptionType ERROR_CONTAINER_MISSING = new DynamicCommandExceptionType(obj -> class_2561.method_43470((String)("Unable to get the needed Container from the given target! [Container: " + String.valueOf(obj) + "]")));
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Dynamic3CommandExceptionType ERROR_MODIFIER_ALREADY_PRESENT = new Dynamic3CommandExceptionType((var1, var2, var3) -> class_2561.method_54159((String)"accessories.commands.attribute.failed.modifier_already_present_itemstack", (Object[])new Object[]{var1, var2, var3}));
    private static final Dynamic3CommandExceptionType ERROR_NO_SUCH_MODIFIER = new Dynamic3CommandExceptionType((var1, var2, var3) -> class_2561.method_54159((String)"accessories.commands.attribute.failed.no_modifier_itemstack", (Object[])new Object[]{var1, var2, var3}));

    private AccessoriesCommands() {
    }

    public static void init() {
        CommandGenerators.create("accessories", INSTANCE, registration -> {
            registration.register(Accessories.of("slot_type"), SlotArgumentType.class, RecordArgumentTypeInfo.of(ctx -> SlotArgumentType.INSTANCE));
            registration.register(Accessories.of("resource"), ResourceExtendedArgument.class, RecordArgumentTypeInfo.of(ResourceExtendedArgument::attributes));
            registration.register(Accessories.of("slot_path"), AccessoriesMixedSlotArgument.class, RecordArgumentTypeInfo.of(Endec.STRING, "entity_argument_name", AccessoriesMixedSlotArgument::entityArgumentName, AccessoriesMixedSlotArgument::new));
        });
    }

    public static class_1309 getOrThrowLivingEntity(CommandContext<class_2168> ctx, String name) throws CommandSyntaxException {
        class_1297 entity = class_2186.method_9313(ctx, (String)name);
        if (!(entity instanceof class_1309)) {
            throw NON_LIVING_ENTITY_TARGET.create();
        }
        class_1309 livingEntity = (class_1309)entity;
        return livingEntity;
    }

    public static AccessoriesCapability getCapability(class_1297 entity) throws CommandSyntaxException {
        if (!(entity instanceof class_1309)) {
            throw NON_LIVING_ENTITY_TARGET.create();
        }
        class_1309 livingEntity = (class_1309)entity;
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        if (capability == null) {
            throw ERROR_CAPABILITY_MISSING.create();
        }
        return capability;
    }

    public static AccessoriesContainer getContainer(class_1297 entity, String slot) throws CommandSyntaxException {
        AccessoriesCapability capability = AccessoriesCommands.getCapability(entity);
        AccessoriesContainer container = capability.getContainers().get(slot);
        if (container == null) {
            throw ERROR_CONTAINER_MISSING.create((Object)slot);
        }
        return container;
    }

    @Override
    public <T> NamedArgumentGetter<class_2168, T> getArgumentGetter(ArgumentType<T> type) {
        NamedArgumentGetter<class_2168, ?> getter = AccessoriesCommands.getArgumentGetterErased(type);
        return getter != null ? getter : CommandTreeGenerator.Branched.super.getArgumentGetter(type);
    }

    @Nullable
    public static <T> NamedArgumentGetter<class_2168, ?> getArgumentGetterErased(ArgumentType<T> type) {
        if (type instanceof class_2232) {
            return class_2232::method_9443;
        }
        if (type instanceof class_2178) {
            return class_2178::method_67416;
        }
        if (type instanceof BoolArgumentType) {
            return BoolArgumentType::getBool;
        }
        if (type instanceof SlotArgumentType) {
            return SlotArgumentType::getSlot;
        }
        if (type instanceof DoubleArgumentType) {
            return DoubleArgumentType::getDouble;
        }
        if (type instanceof IntegerArgumentType) {
            return IntegerArgumentType::getInteger;
        }
        if (type instanceof ResourceExtendedArgument) {
            return ResourceExtendedArgument::getResource;
        }
        if (type instanceof class_7733) {
            class_7733 resourceArgument = (class_7733)type;
            class_5321 key = ((ResourceArgumentAccessor)resourceArgument).registryKey();
            return (ctx, name) -> class_7733.method_45602((CommandContext)ctx, (String)name, (class_5321)key);
        }
        if (type instanceof AccessoriesMixedSlotArgument) {
            return AccessoriesMixedSlotArgument::getSlot;
        }
        if (type instanceof class_2240) {
            return class_2240::method_9469;
        }
        return null;
    }

    @Override
    public void generateTrees(BranchedCommandGenerator root, class_7157 context, class_2170.class_5364 environment) {
        root.modifyRootNode(builder -> builder.requires(stack -> stack.method_9259(2)));
        if (((CommandSelectionAccessor)environment).accessories$includeIntegrated()) {
            root.branch("rendering", renderingBranch -> ((CommandTreeBuilder.BranchedCommandTreeBuilder)renderingBranch.leaves("create-renderer-stack", this.required("renderer_id", class_2232.method_9441()), this.required("item_model_id", class_2232.method_9441()), this.required("custom_name", class_2178.method_9281((class_7157)context)), this.defaulted("is_bundle", BoolArgumentType.bool(), false), (ctx, rendererId, itemModelId, component, isBundle) -> {
                AccessoriesCommands.createRenderStack((CommandContext<class_2168>)ctx, rendererId, itemModelId, component, isBundle);
                return 0;
            })).leaves("listen-to-renderer", this.defaulted("item_model_id", class_2232.method_9441(), null), (ctx, id) -> {
                CustomRendererLoader.constantFileResolving(((class_2168)ctx.getSource()).method_9211(), id);
                return 1;
            }));
        }
        root.leaves("edit", this.defaulted("entity", (ArgumentType<?>)class_2186.method_9309(), AccessoriesCommands::getOrThrowLivingEntity, null), (ctx, livingEntity) -> {
            Accessories.askPlayerForVariant(((class_2168)ctx.getSource()).method_9207(), livingEntity);
            return 1;
        });
        List<String> validLoggingBranches = List.of("slots", "groups", "entity_bindings");
        DynamicCommandExceptionType logFailureType = new DynamicCommandExceptionType(branch -> class_2561.method_43469((String)"accessories.commands.dump.failure", (Object[])new Object[]{branch, validLoggingBranches.toString()}));
        root.leaves("dump", this.branches(validLoggingBranches), (ctx, branch) -> {
            switch (branch) {
                case "slots": {
                    LOGGER.info("All given Slots registered:");
                    for (SlotType slotType : SlotTypeLoader.INSTANCE.getEntries((class_1937)((class_2168)ctx.getSource()).method_9225()).values()) {
                        LOGGER.info(slotType.dumpData());
                    }
                    break;
                }
                case "groups": {
                    LOGGER.info("All given Slot Groups registered:");
                    for (SlotGroup group : SlotGroupLoader.getGroups((class_1937)((class_2168)ctx.getSource()).method_9225())) {
                        LOGGER.info(group.dumpData());
                    }
                    break;
                }
                case "entity_bindings": {
                    LOGGER.info("All given Entity Bindings registered:");
                    EntitySlotLoader.INSTANCE.getEntitySlotData(false).forEach((type, slots) -> LOGGER.info("[EntityType: {}] <-> [Slots: {}]", type, slots.keySet()));
                    break;
                }
                default: {
                    throw logFailureType.create(branch);
                }
            }
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43469((String)"accessories.commands.dump.success", (Object[])new Object[]{branch}));
            return 1;
        });
        AccessoriesItemCommands.INSTANCE.generateTrees(root, context, environment);
        root.branch("slot", slotBranch -> ((CommandTreeBuilder.BranchedCommandTreeBuilder)slotBranch.leaves("get", this.required("entity", (ArgumentType<?>)class_2186.method_9309(), class_2186::method_9313), this.required("slot", SlotArgumentType.INSTANCE), this.defaulted("scale", DoubleArgumentType.doubleArg(), 1.0), (ctx, entity, slot, scale) -> {
            AccessoriesContainer container = AccessoriesCommands.getContainer(entity, slot);
            int size = container.getSize();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"accessories.commands.slot.value.get.success", (Object[])new Object[]{class_2561.method_43471((String)Accessories.translationKey("slot." + slot.replace(":", "."))), entity.method_5477(), size}), false);
            return (int)((double)size * scale);
        })).branch("modifier", modiferBranch -> ((CommandTreeBuilder.BranchedCommandTreeBuilder)modiferBranch.leaves("clear", this.required("entity", (ArgumentType<?>)class_2186.method_9309(), class_2186::method_9313), this.defaulted("slot", SlotArgumentType.INSTANCE, ""), (ctx, entity, s) -> {
            if (s.isBlank()) {
                AccessoriesCapability capability = AccessoriesCommands.getCapability(entity);
                capability.clearSlotModifiers();
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"accessories.commands.slot.modifier.clear.all.success", (Object[])new Object[]{entity.method_5477()}), false);
            } else {
                AccessoriesContainer container = AccessoriesCommands.getContainer(entity, s);
                container.clearModifiers();
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"accessories.commands.slot.modifier.clear.container.success", (Object[])new Object[]{s, entity.method_5477()}), false);
            }
            return 1;
        })).branch(this.required("entity", (ArgumentType<?>)class_2186.method_9309(), class_2186::method_9313), this.required("slot", SlotArgumentType.INSTANCE), this.required("id", class_2232.method_9441()), branchBuilder -> branchBuilder.leaves("add", this.required("amount", DoubleArgumentType.doubleArg()), this.branches(List.of("add_value", "add_multiplied_base", "add_multiplied_total"), (String operationTypeStr) -> Arrays.stream(class_1322.class_1323.values()).filter(value -> value.method_15434().equals(operationTypeStr)).findFirst().orElse(null)), this.defaulted("is_persistent", BoolArgumentType.bool(), true), (ctx, entity, slot, id, amount, operation, isPersistent) -> {
            AccessoriesContainer container = AccessoriesCommands.getContainer(entity, slot);
            class_1322 modifier = new class_1322(id, amount.doubleValue(), operation);
            if (isPersistent.booleanValue()) {
                container.addPersistentModifier(modifier);
            } else {
                container.addTransientModifier(modifier);
            }
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43469((String)"accessories.commands.slot.modifier.addition", (Object[])new Object[]{id, slot, entity.method_5476()}));
            return 1;
        }).leaves("remove", (ctx, entity, slot, id) -> {
            AccessoriesContainer container = AccessoriesCommands.getContainer(entity, slot);
            boolean doseExist = container.hasModifier((class_2960)id);
            if (doseExist) {
                container.removeModifier((class_2960)id);
            }
            String messageType = doseExist ? "accessories.commands.slot.modifier.removed.success" : "accessories.commands.slot.modifier.removed.failure";
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43469((String)messageType, (Object[])new Object[]{id, slot, entity.method_5476()}));
            return 1;
        }).leaves("get", this.defaulted("scale", DoubleArgumentType.doubleArg(), 1.0), (ctx, entity, slot, id, scale) -> {
            AccessoriesContainer container = AccessoriesCommands.getContainer(entity, slot);
            Map<class_2960, class_1322> modifiers = container.getModifiers();
            class_6880<class_1320> attribute = SlotAttribute.getAttributeHolder(container.slotType());
            if (!modifiers.containsKey(id)) {
                throw ERROR_NO_SUCH_MODIFIER.create((Object)entity.method_5477(), (Object)AccessoriesCommands.getAttributeDescription(attribute), id);
            }
            double d = modifiers.get(id).comp_2449();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.attribute.modifier.value.get.success", (Object[])new Object[]{class_2561.method_54154((class_2960)id), AccessoriesCommands.getAttributeDescription(attribute), entity.method_5477(), d}), false);
            return (int)(d * scale);
        }))));
        root.branch("components", itemComponentBranch -> {
            itemComponentBranch.leaves("effect/add", this.required("effect", class_7733.method_45603((class_7157)context, (class_5321)class_7924.field_41208)), this.defaulted("applyDelay", IntegerArgumentType.integer((int)1, (int)1000000), null), this.defaulted("seconds", IntegerArgumentType.integer((int)1, (int)1000000), -1), this.defaulted("amplifier", IntegerArgumentType.integer((int)0, (int)255), 1), this.defaulted("hideParticles", BoolArgumentType.bool(), null), this.defaulted("hideIcon", BoolArgumentType.bool(), null), (ctx, effect, applyDelay, seconds, amplifier, hideParticles, hideIcon) -> {
                if (seconds == -1 && hideParticles == null) {
                    hideParticles = true;
                }
                if (hideIcon == null) {
                    hideIcon = false;
                }
                class_1293 effectInstance = new class_1293((class_6880)effect, seconds.intValue(), amplifier.intValue(), false, hideParticles == false, hideIcon == false);
                class_3222 player = ((class_2168)ctx.getSource()).method_9207();
                player.method_6047().method_57368(AccessoriesDataComponents.MOB_EFFECTS, (Object)AccessoryMobEffectsComponent.EMPTY, data -> applyDelay != null ? data.addEffect(effectInstance, (int)applyDelay) : data.addEffect(effectInstance));
                return 1;
            });
            itemComponentBranch.leaves("nest", this.required("item", (ArgumentType<?>)class_2287.method_9776((class_7157)context), (ctx, name) -> class_2287.method_9777((CommandContext)ctx, (String)name).method_9781(1, false)), (ctx, innerStack) -> {
                class_3222 player = ((class_2168)ctx.getSource()).method_9207();
                player.method_6047().method_57368(AccessoriesDataComponents.NESTED_ACCESSORIES, (Object)AccessoryNestContainerContents.EMPTY, data -> data.addStack((class_1799)innerStack));
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43471((String)"accessories.commands.nest.addition"));
                return 1;
            });
            itemComponentBranch.leaves("slot", this.branches("add", "remove"), this.branches("valid", "invalid"), this.required("slot", SlotArgumentType.INSTANCE), (ctx, operation, condition, slot) -> AccessoriesCommands.adjustSlotValidationOnStack(condition, Objects.equals(operation, "add"), slot, (CommandContext<class_2168>)ctx));
            itemComponentBranch.branch("stack-sizing", branchBuilder -> ((CommandTreeBuilder.BranchedCommandTreeBuilder)branchBuilder.leaves("useStackSize", this.required("value", BoolArgumentType.bool()), (ctx, bl) -> {
                class_3222 player = ((class_2168)ctx.getSource()).method_9207();
                player.method_6047().method_57368(AccessoriesDataComponents.STACK_SETTINGS, (Object)AccessoryStackSettings.DEFAULT, component -> component.useStackSize((boolean)bl));
                return 1;
            })).leaves(this.required("size", IntegerArgumentType.integer()), (ctx, size) -> {
                class_3222 player = ((class_2168)ctx.getSource()).method_9207();
                player.method_6047().method_57368(AccessoriesDataComponents.STACK_SETTINGS, (Object)AccessoryStackSettings.DEFAULT, component -> component.sizeOverride((int)size));
                return 1;
            }));
            itemComponentBranch.branch("attribute", this.required("attribute", ResourceExtendedArgument.attributes(context)), this.required("id", class_2232.method_9441()), branchBuilder -> branchBuilder.leaves("add", this.required("amount", DoubleArgumentType.doubleArg()), this.branches(List.of("add_value", "add_multiplied_base", "add_multiplied_total"), (String operationTypeStr) -> Arrays.stream(class_1322.class_1323.values()).filter(value -> value.method_15434().equals(operationTypeStr)).findFirst().orElse(null)), this.required("slot", SlotArgumentType.INSTANCE), this.required("isStackable", BoolArgumentType.bool()), this.defaulted("usedInSlotValidation", BoolArgumentType.bool(), false), AccessoriesCommands::addModifier).leaves("remove", AccessoriesCommands::removeModifier).leaves("get", this.defaulted("scale", DoubleArgumentType.doubleArg(), 1.0), AccessoriesCommands::getAttributeModifier));
        });
    }

    private static int getAttributeModifier(CommandContext<class_2168> ctx, class_6880<class_1320> holder, class_2960 resourceLocation, double d) throws CommandSyntaxException {
        class_2168 commandSourceStack = (class_2168)ctx.getSource();
        class_3222 livingEntity = ((class_2168)ctx.getSource()).method_9207();
        class_1799 stack = livingEntity.method_6047();
        AccessoryItemAttributeModifiers component = (AccessoryItemAttributeModifiers)stack.method_58695(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY);
        class_1322 modifier = component.getModifier(holder, resourceLocation);
        if (modifier == null) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)stack.method_7954(), (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)resourceLocation);
        }
        double e = modifier.comp_2449();
        commandSourceStack.method_9226(() -> class_2561.method_43469((String)"accessories.commands.attribute.modifier.value.get.success_itemstack", (Object[])new Object[]{class_2561.method_54154((class_2960)resourceLocation), AccessoriesCommands.getAttributeDescription(holder), stack.method_7954(), e}), false);
        return (int)(e * d);
    }

    private static int addModifier(CommandContext<class_2168> ctx, class_6880<class_1320> holder, class_2960 resourceLocation, double d, class_1322.class_1323 operation, String slotName, boolean isStackable, boolean usedInSlotValidation) throws CommandSyntaxException {
        class_2168 commandSourceStack = (class_2168)ctx.getSource();
        if (operation == null) {
            commandSourceStack.method_9213((class_2561)class_2561.method_43470((String)"Unable to locate AttributeModifier Operation type passed to the command!"));
            return -1;
        }
        class_3222 livingEntity = ((class_2168)ctx.getSource()).method_9207();
        class_1799 stack = livingEntity.method_6047();
        AccessoryItemAttributeModifiers component = (AccessoryItemAttributeModifiers)stack.method_58695(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY);
        if (component.hasModifier(holder, resourceLocation)) {
            throw ERROR_MODIFIER_ALREADY_PRESENT.create((Object)resourceLocation, (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)stack.method_7954());
        }
        stack.method_57379(AccessoriesDataComponents.ATTRIBUTES, (Object)component.withModifierAdded(holder, new class_1322(resourceLocation, d, operation), slotName, isStackable, usedInSlotValidation));
        commandSourceStack.method_9226(() -> class_2561.method_43469((String)"accessories.commands.attribute.modifier.add.success_itemstack", (Object[])new Object[]{class_2561.method_54154((class_2960)resourceLocation), AccessoriesCommands.getAttributeDescription(holder), stack.method_7954()}), false);
        return 1;
    }

    private static int removeModifier(CommandContext<class_2168> ctx, class_6880<class_1320> holder, class_2960 location) throws CommandSyntaxException {
        class_2168 commandSourceStack = (class_2168)ctx.getSource();
        class_3222 livingEntity = ((class_2168)ctx.getSource()).method_9207();
        MutableBoolean removedModifier = new MutableBoolean(false);
        class_1799 stack = livingEntity.method_6047();
        stack.method_57368(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY, component -> {
            int size = component.modifiers().size();
            if (size != (component = component.withoutModifier(holder, location)).modifiers().size()) {
                removedModifier.setTrue();
            }
            return component;
        });
        if (!removedModifier.getValue().booleanValue()) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)location, (Object)stack.method_7954(), (Object)AccessoriesCommands.getAttributeDescription(holder));
        }
        commandSourceStack.method_9226(() -> class_2561.method_43469((String)"accessories.commands.attribute.modifier.remove.success_itemstack", (Object[])new Object[]{class_2561.method_54154((class_2960)location), AccessoriesCommands.getAttributeDescription(holder), stack.method_7954()}), false);
        return 1;
    }

    private static class_2561 getAttributeDescription(class_6880<class_1320> attribute) {
        return class_2561.method_43471((String)((class_1320)attribute.comp_349()).method_26830());
    }

    private static int adjustSlotValidationOnStack(String branch, boolean addSlot, String slotName, CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 targetEntity = ((class_2168)ctx.getSource()).method_9207();
        targetEntity.method_6047().method_57368(AccessoriesDataComponents.SLOT_VALIDATION, (Object)AccessorySlotValidationComponent.EMPTY, component -> Objects.equals(branch, "valid") ? (addSlot ? component.addValidSlot(slotName) : component.removeValidSlot(slotName)) : (addSlot ? component.addInvalidSlot(slotName) : component.removeInvalidSlot(slotName)));
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43469((String)("accessories.commands.slot.validation." + (addSlot ? "added" : "removed") + "." + branch), (Object[])new Object[]{slotName}));
        return 1;
    }

    private static int createRenderStack(CommandContext<class_2168> ctx, class_2960 rendererId, class_2960 modelId, class_2561 component, boolean isBundle) throws CommandSyntaxException {
        class_1792 item = class_1802.field_8600;
        try {
            if (((Boolean)ctx.getArgument("is_bundle", Boolean.class)).booleanValue()) {
                item = class_1802.field_27023;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        class_1799 itemStack = item.method_7854();
        itemStack.method_57379(class_9334.field_50239, (Object)component);
        itemStack.method_57379(AccessoriesDataComponents.CUSTOM_RENDERER, (Object)new AccessoryCustomRendererComponent(List.of(new RenderingFunction.DeferredRenderer(rendererId, Map.of(), RenderingFunction.ArmTarget.BOTH)), null, false));
        itemStack.method_57379(class_9334.field_54199, (Object)modelId);
        itemStack.method_57379(AccessoriesDataComponents.SLOT_VALIDATION, (Object)new AccessorySlotValidationComponent(Set.of("any"), Set.of()));
        ((class_2168)ctx.getSource()).method_9207().method_7270(itemStack);
        return 1;
    }
}

