/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.commands.AccessoriesCommands;
import io.wispforest.accessories.commands.AccessoriesMixedSlotArgument;
import io.wispforest.accessories.commands.api.CommandTreeGenerator;
import io.wispforest.accessories.commands.api.base.Argument;
import io.wispforest.accessories.commands.api.base.BranchedCommandGenerator;
import io.wispforest.accessories.commands.api.base.CommandTreeBuilder;
import io.wispforest.accessories.commands.api.core.NamedArgumentGetter;
import java.util.Optional;
import net.minecraft.class_117;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2240;
import net.minecraft.class_2262;
import net.minecraft.class_2287;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5630;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_9433;

public class AccessoriesItemCommands
implements CommandTreeGenerator.Branched {
    public static final AccessoriesItemCommands INSTANCE = new AccessoriesItemCommands();
    private static final Dynamic3CommandExceptionType ERROR_TARGET_NOT_A_CONTAINER = new Dynamic3CommandExceptionType((object, object2, object3) -> class_2561.method_54159((String)"commands.item.target.not_a_container", (Object[])new Object[]{object, object2, object3}));
    private static final Dynamic3CommandExceptionType ERROR_SOURCE_NOT_A_CONTAINER = new Dynamic3CommandExceptionType((object, object2, object3) -> class_2561.method_54159((String)"commands.item.source.not_a_container", (Object[])new Object[]{object, object2, object3}));
    private static final DynamicCommandExceptionType ERROR_TARGET_INAPPLICABLE_SLOT = new DynamicCommandExceptionType(object -> class_2561.method_54159((String)"commands.item.target.no_such_slot", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType ERROR_SOURCE_INAPPLICABLE_SLOT = new DynamicCommandExceptionType(object -> class_2561.method_54159((String)"commands.item.source.no_such_slot", (Object[])new Object[]{object}));
    private static final SuggestionProvider<class_2168> SUGGEST_MODIFIER = (commandContext, suggestionsBuilder) -> class_2172.method_71777((CommandContext)commandContext, (SuggestionsBuilder)suggestionsBuilder, (class_5321)class_7924.field_50080, (class_2172.class_7078)class_2172.class_7078.field_37263);
    public static final Dynamic2CommandExceptionType ERROR_INVALID_SLOT_INDEX = new Dynamic2CommandExceptionType((ob1, ob2) -> class_2561.method_43470((String)("The given path for [" + String.valueOf(ob1) + "] container is invalid: [Path: " + String.valueOf(ob2) + "]")));

    private AccessoriesItemCommands() {
    }

    @Override
    public <T> NamedArgumentGetter<class_2168, T> getArgumentGetter(ArgumentType<T> type) {
        NamedArgumentGetter<class_2168, ?> getter = AccessoriesCommands.getArgumentGetterErased(type);
        return getter != null ? getter : CommandTreeGenerator.Branched.super.getArgumentGetter(type);
    }

    @Override
    public void generateTrees(BranchedCommandGenerator generator, class_7157 context, class_2170.class_5364 environment) {
        Argument slotArg = this.required("slot", class_2240.method_9473());
        Argument<class_2338> blockArg = this.required("pos", (ArgumentType<?>)class_2262.method_9698(), class_2262::method_9696);
        Argument<Object> modifierArg = this.defaulted("modifier", (ArgumentType<?>)class_9433.method_58486((class_7157)context), class_9433::method_58485, null, SUGGEST_MODIFIER);
        Argument sourceSlotArg = this.required("sourceSlot", class_2240.method_9473());
        ((CommandTreeBuilder.BranchedCommandTreeBuilder)((CommandTreeBuilder.BranchedCommandTreeBuilder)generator.branch("item")).branch("replace", replaceBranch -> ((CommandTreeBuilder.BranchedCommandTreeBuilder)replaceBranch.branch("block", blockArg, slotArg, blockBranch -> blockBranch.branch("from", fromBranch -> fromBranch.leaves("entity", this.required("source_entity", (ArgumentType<?>)class_2186.method_9309(), class_2186::method_9313), this.required("source_path", AccessoriesMixedSlotArgument.slot("source_entity")), modifierArg, (ctx, targetPos, targetSlot, sourceEntity, sourceSlot, modifier) -> modifier == null ? AccessoriesItemCommands.entityToBlock((class_2168)ctx.getSource(), sourceEntity, (Either<SlotPath, Integer>)sourceSlot, targetPos, targetSlot) : AccessoriesItemCommands.entityToBlock((class_2168)ctx.getSource(), sourceEntity, (Either<SlotPath, Integer>)sourceSlot, targetPos, targetSlot, (class_6880<class_117>)modifier))))).branch("entity", this.required("entity", (ArgumentType<?>)class_2186.method_9309(), class_2186::method_9313), this.required("path", AccessoriesMixedSlotArgument.slot("entity")), entityBranch -> entityBranch.leaves("with", this.required("item", (ArgumentType<?>)class_2287.method_9776((class_7157)context), (ctx, name) -> class_2287.method_9777((CommandContext)ctx, (String)name).method_9781(1, false)), this.defaulted("count", IntegerArgumentType.integer((int)1, (int)99), 1), (ctx, entity, slot, stack, count) -> {
            stack.method_7939(count.intValue());
            return AccessoriesItemCommands.setEntityItem((class_2168)ctx.getSource(), entity, (Either<SlotPath, Integer>)slot, stack);
        }).branch("from", fromBranch -> fromBranch.leaves("block", this.required("source", (ArgumentType<?>)class_2262.method_9698(), class_2262::method_9696), sourceSlotArg, modifierArg, (ctx, targetPos, targetSlot, sourcePos, sourceSlot, modifier) -> modifier == null ? AccessoriesItemCommands.blockToEntity((class_2168)ctx.getSource(), sourcePos, sourceSlot, targetPos, (Either<SlotPath, Integer>)targetSlot) : AccessoriesItemCommands.blockToEntity((class_2168)ctx.getSource(), sourcePos, sourceSlot, targetPos, (Either<SlotPath, Integer>)targetSlot, (class_6880<class_117>)modifier)).leaves("entity", this.required("source_entity", (ArgumentType<?>)class_2186.method_9309(), class_2186::method_9313), this.required("source_path", AccessoriesMixedSlotArgument.slot("source_entity")), modifierArg, (ctx, targetEntity, targetPath, sourceEntity, sourcePath, modifier) -> modifier == null ? AccessoriesItemCommands.entityToEntity((class_2168)ctx.getSource(), sourceEntity, (Either<SlotPath, Integer>)sourcePath, targetEntity, (Either<SlotPath, Integer>)targetPath) : AccessoriesItemCommands.entityToEntity((class_2168)ctx.getSource(), sourceEntity, (Either<SlotPath, Integer>)sourcePath, targetEntity, (Either<SlotPath, Integer>)targetPath, (class_6880<class_117>)modifier)))))).branch("modify", modifyBranch -> modifyBranch.leaves("entity", this.required("entity", (ArgumentType<?>)class_2186.method_9309(), class_2186::method_9313), this.required("path", AccessoriesMixedSlotArgument.slot("entity")), modifierArg, (ctx, entity, path, modifier) -> AccessoriesItemCommands.modifyEntityItem((class_2168)ctx.getSource(), entity, (Either<SlotPath, Integer>)path, (class_6880<class_117>)modifier)));
    }

    private static int blockToEntity(class_2168 source, class_2338 pos, int sourceSlot, class_1297 target, Either<SlotPath, Integer> slot) throws CommandSyntaxException {
        return AccessoriesItemCommands.setEntityItem(source, target, slot, AccessoriesItemCommands.getBlockItem(source, pos, sourceSlot));
    }

    private static int blockToEntity(class_2168 source, class_2338 pos, int sourceSlot, class_1297 target, Either<SlotPath, Integer> slot, class_6880<class_117> modifier) throws CommandSyntaxException {
        return AccessoriesItemCommands.setEntityItem(source, target, slot, AccessoriesItemCommands.applyModifier(source, modifier, AccessoriesItemCommands.getBlockItem(source, pos, sourceSlot)));
    }

    private static int entityToBlock(class_2168 source, class_1297 sourceEntity, Either<SlotPath, Integer> sourceSlot, class_2338 pos, int slot) throws CommandSyntaxException {
        return AccessoriesItemCommands.setBlockItem(source, pos, slot, AccessoriesItemCommands.getEntityItem(sourceEntity, sourceSlot));
    }

    private static int entityToBlock(class_2168 source, class_1297 sourceEntity, Either<SlotPath, Integer> sourceSlot, class_2338 pos, int slot, class_6880<class_117> modifier) throws CommandSyntaxException {
        return AccessoriesItemCommands.setBlockItem(source, pos, slot, AccessoriesItemCommands.applyModifier(source, modifier, AccessoriesItemCommands.getEntityItem(sourceEntity, sourceSlot)));
    }

    private static int entityToEntity(class_2168 source, class_1297 sourceEntity, Either<SlotPath, Integer> sourceSlot, class_1297 targetEntity, Either<SlotPath, Integer> targetSlot) throws CommandSyntaxException {
        return AccessoriesItemCommands.setEntityItem(source, targetEntity, targetSlot, AccessoriesItemCommands.getEntityItem(sourceEntity, sourceSlot));
    }

    private static int entityToEntity(class_2168 source, class_1297 sourceEntity, Either<SlotPath, Integer> sourceSlot, class_1297 targetEntity, Either<SlotPath, Integer> targetSlot, class_6880<class_117> modifier) throws CommandSyntaxException {
        return AccessoriesItemCommands.setEntityItem(source, targetEntity, targetSlot, AccessoriesItemCommands.applyModifier(source, modifier, AccessoriesItemCommands.getEntityItem(sourceEntity, sourceSlot)));
    }

    private static class_1799 applyModifier(class_2168 source, class_6880<class_117> modifier, class_1799 originalStack) {
        class_8567 lootParams = new class_8567.class_8568(source.method_9225()).method_51874(class_181.field_24424, (Object)source.method_9222()).method_51877(class_181.field_1226, (Object)source.method_9228()).method_51875(class_173.field_20761);
        class_47 lootContext = new class_47.class_48(lootParams).method_309(Optional.empty());
        lootContext.method_298(class_47.method_51186((class_117)((class_117)modifier.comp_349())));
        class_1799 modifiedStack = (class_1799)((class_117)modifier.comp_349()).apply((Object)originalStack, (Object)lootContext);
        modifiedStack.method_58408(modifiedStack.method_7914());
        return modifiedStack;
    }

    private static class_1799 getEntityItem(class_1297 entity, Either<SlotPath, Integer> slot) throws CommandSyntaxException {
        if (slot.right().isPresent()) {
            Integer index = (Integer)slot.right().get();
            class_5630 slotAccess = entity.method_32318(index.intValue());
            if (slotAccess == class_5630.field_27860) {
                throw ERROR_SOURCE_INAPPLICABLE_SLOT.create(slot);
            }
            return slotAccess.method_32327().method_7972();
        }
        if (!(entity instanceof class_1309)) {
            throw AccessoriesCommands.NON_LIVING_ENTITY_TARGET.create();
        }
        class_1309 livingEntity = (class_1309)entity;
        if (livingEntity.accessoriesCapability() == null) {
            throw AccessoriesCommands.ERROR_CAPABILITY_MISSING.create();
        }
        SlotPath slotPath = (SlotPath)slot.left().get();
        SlotReference reference = SlotReference.of(livingEntity, slotPath);
        AccessoriesContainer container = reference.slotContainer();
        if (container == null) {
            throw AccessoriesCommands.ERROR_CONTAINER_MISSING.create((Object)reference.slotName());
        }
        class_1799 stack = reference.getStack();
        if (stack == null) {
            throw ERROR_INVALID_SLOT_INDEX.create((Object)slotPath.slotName(), (Object)slotPath);
        }
        return stack.method_7972();
    }

    private static int setEntityItem(class_2168 source, class_1297 entity, Either<SlotPath, Integer> slot, class_1799 stack) throws CommandSyntaxException {
        if (slot.right().isPresent()) {
            Integer index = (Integer)slot.right().get();
            class_5630 slotAccess = entity.method_32318(index.intValue());
            if (slotAccess == class_5630.field_27860) {
                throw ERROR_SOURCE_INAPPLICABLE_SLOT.create(slot);
            }
            slotAccess.method_32332(stack);
        } else {
            if (!(entity instanceof class_1309)) {
                throw AccessoriesCommands.NON_LIVING_ENTITY_TARGET.create();
            }
            class_1309 livingEntity = (class_1309)entity;
            SlotPath slotPath = (SlotPath)slot.left().get();
            SlotReference reference = SlotReference.of(livingEntity, slotPath);
            AccessoriesContainer container = reference.slotContainer();
            if (container == null) {
                throw AccessoriesCommands.ERROR_CONTAINER_MISSING.create((Object)reference.slotName());
            }
            if (reference.setStack(stack)) {
                throw ERROR_INVALID_SLOT_INDEX.create((Object)slotPath.slotName(), (Object)slotPath);
            }
        }
        return 1;
    }

    private static class_1799 getBlockItem(class_2168 source, class_2338 pos, int slot) throws CommandSyntaxException {
        class_1263 container = AccessoriesItemCommands.getContainer(source, pos, ERROR_SOURCE_NOT_A_CONTAINER);
        if (slot >= 0 && slot < container.method_5439()) {
            return container.method_5438(slot).method_7972();
        }
        throw ERROR_SOURCE_INAPPLICABLE_SLOT.create((Object)slot);
    }

    private static int setBlockItem(class_2168 source, class_2338 pos, int slot, class_1799 item) throws CommandSyntaxException {
        class_1263 container = AccessoriesItemCommands.getContainer(source, pos, ERROR_TARGET_NOT_A_CONTAINER);
        if (slot >= 0 && slot < container.method_5439()) {
            container.method_5447(slot, item);
            source.method_9226(() -> class_2561.method_43469((String)"commands.item.block.set.success", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260(), item.method_7954()}), true);
            return 1;
        }
        throw ERROR_TARGET_INAPPLICABLE_SLOT.create((Object)slot);
    }

    private static class_1263 getContainer(class_2168 source, class_2338 pos, Dynamic3CommandExceptionType exception) throws CommandSyntaxException {
        class_2586 class_25862 = source.method_9225().method_8321(pos);
        if (class_25862 instanceof class_1263) {
            class_1263 container = (class_1263)class_25862;
            return container;
        }
        throw exception.create((Object)pos.method_10263(), (Object)pos.method_10264(), (Object)pos.method_10260());
    }

    private static int modifyEntityItem(class_2168 source, class_1297 target, Either<SlotPath, Integer> slot, class_6880<class_117> modifer) throws CommandSyntaxException {
        class_1799 modifiedStack = AccessoriesItemCommands.applyModifier(source, modifer, AccessoriesItemCommands.getEntityItem(target, slot).method_7972());
        AccessoriesItemCommands.setEntityItem(source, target, slot, modifiedStack);
        source.method_9226(() -> class_2561.method_43469((String)"commands.item.entity.set.success.single", (Object[])new Object[]{target.method_5476(), modifiedStack.method_7954()}), true);
        return 1;
    }
}

