/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_9010;
import net.minecraft.class_9348;
import net.minecraft.class_9349;
import org.jetbrains.annotations.Nullable;

public record AccessoriesMixedSlotArgument(String entityArgumentName) implements ArgumentType<Either<SlotPath, Integer>>
{
    private static final Collection<String> EXAMPLES = Arrays.asList("back/1", "charm/1", "feet.1", "weapon");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_SLOT = new DynamicCommandExceptionType(object -> class_2561.method_54159((String)"slot.unknown", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType ERROR_ONLY_SINGLE_SLOT_ALLOWED = new DynamicCommandExceptionType(object -> class_2561.method_54159((String)"slot.only_single_allowed", (Object[])new Object[]{object}));

    public static AccessoriesMixedSlotArgument slot(String entityArgumentName) {
        return new AccessoriesMixedSlotArgument(entityArgumentName);
    }

    public static Either<SlotPath, Integer> getSlot(CommandContext<class_2168> context, String name) {
        return (Either)context.getArgument(name, Either.class);
    }

    public Either<SlotPath, Integer> parse(StringReader reader) throws CommandSyntaxException {
        String string = class_9010.method_58128((StringReader)reader, c -> c != ' ');
        SlotPath slotPath = SlotPath.fromString(string);
        if (slotPath != null) {
            return Either.left((Object)slotPath);
        }
        Integer vanillaSlot = this.parseVanillaSlot(reader, string);
        if (vanillaSlot != null) {
            return Either.right((Object)vanillaSlot);
        }
        throw ERROR_UNKNOWN_SLOT.createWithContext((ImmutableStringReader)reader, (Object)string);
    }

    @Nullable
    public Integer parseVanillaSlot(StringReader reader, String string) throws CommandSyntaxException {
        class_9348 slotRange = class_9349.method_58080((String)string);
        if (slotRange == null) {
            return null;
        }
        if (slotRange.method_58077() != 1) {
            throw ERROR_ONLY_SINGLE_SLOT_ALLOWED.createWithContext((ImmutableStringReader)reader, (Object)string);
        }
        return slotRange.method_58075().getInt(0);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        CompletableFuture completableFuture;
        Object object = commandContext.getSource();
        if (object instanceof class_2168) {
            ArrayList<Object> suggestions = new ArrayList<Object>();
            try {
                class_1309 livingEntity;
                AccessoriesCapability capability;
                class_1297 entityTarget = class_2186.method_9313(commandContext, (String)this.entityArgumentName);
                if (entityTarget instanceof class_1309 && (capability = (livingEntity = (class_1309)entityTarget).accessoriesCapability()) != null) {
                    suggestions.addAll(EntitySlotLoader.getEntitySlots(livingEntity).values().stream().flatMap(slotType -> {
                        ArrayList<String> slotPaths = new ArrayList<String>();
                        AccessoriesContainer container = capability.getContainer((SlotType)slotType);
                        if (container != null) {
                            for (int i = 0; i < container.getSize(); ++i) {
                                slotPaths.add(SlotPath.createBaseSlotPath(slotType, i));
                            }
                        }
                        return slotPaths.stream();
                    }).toList());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            suggestions.addAll(class_9349.method_58088().toList());
            return class_2172.method_9265(suggestions, (SuggestionsBuilder)suggestionsBuilder);
        }
        if (object instanceof class_2172) {
            class_2172 sharedSuggestionProvider = (class_2172)object;
            completableFuture = sharedSuggestionProvider.method_9261(commandContext);
        } else {
            completableFuture = Suggestions.empty();
        }
        return completableFuture;
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

