/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.data;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import io.wispforest.accessories.api.client.rendering.RenderingFunction;
import io.wispforest.accessories.data.api.SimpleManagedEndecDataLoader;
import io.wispforest.accessories.utils.HashUtils;
import io.wispforest.endec.format.gson.GsonDeserializer;
import io.wispforest.owo.Owo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7654;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Experimental
public class CustomRendererLoader
extends SimpleManagedEndecDataLoader<RenderingFunction.RawRenderer> {
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private class_2960 constantResolveTarget = null;
    public static final CustomRendererLoader CLIENT_OVERRIDES = new CustomRendererLoader(class_3264.field_14188);
    public static final CustomRendererLoader PRIMARY = new CustomRendererLoader(class_3264.field_14190);
    private final Map<UUID, RenderingFunction.Compound> resolvedClient = new HashMap<UUID, RenderingFunction.Compound>();
    private final Map<UUID, RenderingFunction.Compound> resolvedServer = new HashMap<UUID, RenderingFunction.Compound>();
    private boolean alwaysResolveFlag = false;
    private final Set<class_2960> missingRenderersClient = new HashSet<class_2960>();
    private final Set<class_2960> missingRenderersServer = new HashSet<class_2960>();
    private static final Cache<class_2960, Integer> ERROR_CACHE = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(30L)).maximumSize(3000L).build();

    protected CustomRendererLoader(class_3264 packType) {
        super(Accessories.of("rendering_renderer"), "accessories/render/renderer", RenderingFunction.RawRenderer.ENDEC, packType);
    }

    @Nullable
    public static Either<AccessoryRenderer, RenderingFunction> getOrResolveRenderer(RenderingFunction.DeferredRenderer dataRenderer, boolean isClientSide) {
        AccessoryRenderer renderer = AccessoriesRendererRegistry.getRenderer(dataRenderer.rendererId());
        if (renderer != null) {
            return Either.left((Object)renderer);
        }
        RenderingFunction resolvedRenderer = CustomRendererLoader.getOrResolveDeferredRenderer(dataRenderer, isClientSide);
        if (resolvedRenderer != null) {
            return Either.right((Object)resolvedRenderer);
        }
        return null;
    }

    public static RenderingFunction getOrResolveDeferredRenderer(RenderingFunction.DeferredRenderer deferredRenderer, boolean isClientSide) {
        RenderingFunction.Compound result = CLIENT_OVERRIDES.getOrResolveRendererInitial(deferredRenderer, isClientSide, true);
        if (result != null) {
            return result;
        }
        return PRIMARY.getOrResolveRendererInitial(deferredRenderer, isClientSide, false);
    }

    @Nullable
    public static RenderingFunction getOrResolveRawRenderer(RenderingFunction.RawRenderer dataRenderer, boolean isClientSide) {
        RenderingFunction.Compound result = CLIENT_OVERRIDES.resolveRawData(new ArrayDeque<class_2960>(), Accessories.of("generated"), dataRenderer, new HashMap<String, JsonElement>(), isClientSide);
        if (result != null) {
            return result;
        }
        return PRIMARY.resolveRawData(new ArrayDeque<class_2960>(), Accessories.of("generated"), dataRenderer, new HashMap<String, JsonElement>(), isClientSide);
    }

    @Override
    protected void onSync() {
        this.missingRenderersClient.clear();
        this.missingRenderersServer.clear();
        this.resolvedClient.clear();
        this.resolvedServer.clear();
    }

    @Override
    public Map<class_2960, RenderingFunction.RawRenderer> mapFrom(Map<class_2960, RenderingFunction.RawRenderer> rawData) {
        this.resolvedServer.clear();
        this.missingRenderersServer.clear();
        return super.mapFrom(rawData);
    }

    @Nullable
    private RenderingFunction.Compound getOrResolveRendererInitial(RenderingFunction.DeferredRenderer deferredRenderer, boolean isClientSide, boolean allowMissing) {
        ArrayDeque<class_2960> currentResolveTree = new ArrayDeque<class_2960>();
        HashMap<String, JsonElement> references = new HashMap<String, JsonElement>(deferredRenderer.references());
        RenderingFunction.Compound function = null;
        boolean shouldResetFlagOnResolve = false;
        UUID uuid = deferredRenderer.getUUID();
        if (Objects.equals(this.constantResolveTarget, deferredRenderer.rendererId())) {
            if (!this.alwaysResolveFlag) {
                this.alwaysResolveFlag = true;
                shouldResetFlagOnResolve = true;
            }
        } else if (!this.alwaysResolveFlag) {
            function = (isClientSide ? this.resolvedClient : this.resolvedServer).get(uuid);
        }
        if (function == null) {
            function = this.resolveRenderer(currentResolveTree, deferredRenderer.rendererId(), references, isClientSide, allowMissing);
            (isClientSide ? this.resolvedClient : this.resolvedServer).put(uuid, function);
        }
        if (shouldResetFlagOnResolve) {
            this.alwaysResolveFlag = false;
        }
        return function;
    }

    private RenderingFunction.Compound resolveRenderer(Deque<class_2960> currentResolveTree, class_2960 id, Map<String, JsonElement> references, boolean isClientSide, boolean allowMissing) {
        currentResolveTree.push(id);
        RenderingFunction.RawRenderer rawRenderer = null;
        if (this.alwaysResolveFlag) {
            rawRenderer = this.getDataFromId(id, isClientSide);
        }
        if (rawRenderer == null) {
            rawRenderer = (RenderingFunction.RawRenderer)this.getEntry(id, isClientSide);
        }
        if (rawRenderer == null) {
            if (allowMissing) {
                Set<class_2960> errorSet;
                Set<class_2960> set = errorSet = isClientSide ? this.missingRenderersClient : this.missingRenderersServer;
                if (!errorSet.contains(id)) {
                    LOGGER.error("Unable to resolve renderer [{}] as it was not found within Custom Renderer Registry!", (Object)id);
                    errorSet.add(id);
                }
            }
            return null;
        }
        RenderingFunction.Compound function = this.resolveRawData(currentResolveTree, id, rawRenderer, references, isClientSide);
        currentResolveTree.pop();
        return function;
    }

    @Nullable
    private RenderingFunction.Compound resolveRawData(Deque<class_2960> currentResolveTree, class_2960 id, RenderingFunction function, Map<String, JsonElement> references, boolean isClientSide) {
        if (function instanceof RenderingFunction.RawRenderer) {
            RenderingFunction.RawRenderer data = (RenderingFunction.RawRenderer)function;
            data.references().forEach(references::putIfAbsent);
            if (data.renderingFunctions() != null) {
                ArrayList<RenderingFunction> renderers = new ArrayList<RenderingFunction>();
                for (JsonElement rawRenderingFunc : data.renderingFunctions()) {
                    try {
                        rawRenderingFunc = CustomRendererLoader.resolveReferencesForCopy(references, rawRenderingFunc);
                        RenderingFunction renderingFunc = (RenderingFunction)RenderingFunction.ENDEC.decodeFully(GsonDeserializer::of, (Object)rawRenderingFunc);
                        if (renderingFunc instanceof RenderingFunction.DeferredRenderer) {
                            RenderingFunction.DeferredRenderer renderer = (RenderingFunction.DeferredRenderer)renderingFunc;
                            renderingFunc = this.resolveRawData(currentResolveTree, id.method_45138("."), renderer, references, isClientSide);
                            if (renderingFunc == null) {
                                LOGGER.warn("Unable to resolve inner renderer [{}] for [{}] as it was not found within Custom Renderer Registry!", (Object)renderer.rendererId(), (Object)id);
                                continue;
                            }
                        }
                        renderers.add(renderingFunc);
                    }
                    catch (Exception e) {
                        this.errorIfDifferent(id, e, () -> {
                            LOGGER.error("Unable to decode the a given Render Function with [{}] due the following error: ", (Object)id);
                            this.minimalErroring(e);
                        });
                    }
                }
                RenderingFunction.ArmTarget armTarget = data.firstPersonArmTarget();
                return new RenderingFunction.Compound(Collections.unmodifiableList(renderers), armTarget != null ? armTarget : RenderingFunction.ArmTarget.NONE);
            }
        } else if (function instanceof RenderingFunction.DeferredRenderer) {
            RenderingFunction.DeferredRenderer renderer = (RenderingFunction.DeferredRenderer)function;
            renderer.references().forEach(references::putIfAbsent);
            if (!renderer.rendererId().equals((Object)AccessoriesRendererRegistry.NO_RENDERER_ID)) {
                if (currentResolveTree.contains(renderer.rendererId())) {
                    currentResolveTree.push(renderer.rendererId());
                    LOGGER.error("Recursive loop of Renderer Referencing, unable to resolve such! [{}]", currentResolveTree);
                    currentResolveTree.pop();
                    return null;
                }
                RenderingFunction.Compound renderingFunc = this.resolveRenderer(currentResolveTree, renderer.rendererId(), references, isClientSide, false);
                if (renderingFunc != null && renderer.firstPersonArmTarget() != null) {
                    renderingFunc = new RenderingFunction.Compound(renderingFunc.renderingFunctions(), renderer.firstPersonArmTarget());
                }
                return renderingFunc;
            }
        }
        return null;
    }

    private static JsonElement resolveReferencesForCopy(Map<String, JsonElement> references, JsonElement jsonElement) {
        JsonElement copy = jsonElement.deepCopy();
        CustomRendererLoader.resolveReferences(references, copy);
        return copy;
    }

    private static void resolveReferences(Map<String, JsonElement> references, JsonElement jsonElement) {
        block7: {
            block6: {
                if (!(jsonElement instanceof JsonObject)) break block6;
                JsonObject jsonObject = (JsonObject)jsonElement;
                for (Map.Entry entry : jsonObject.asMap().entrySet()) {
                    String possibleReference;
                    JsonPrimitive jsonPrimitive;
                    String key = (String)entry.getKey();
                    JsonElement childElement = (JsonElement)entry.getValue();
                    if (childElement instanceof JsonObject) {
                        JsonObject innerJsonObject = (JsonObject)childElement;
                        CustomRendererLoader.resolveReferences(references, (JsonElement)innerJsonObject);
                        continue;
                    }
                    if (childElement instanceof JsonArray) {
                        JsonArray innerJsonArray = (JsonArray)childElement;
                        CustomRendererLoader.resolveReferences(references, (JsonElement)innerJsonArray);
                        continue;
                    }
                    if (!(childElement instanceof JsonPrimitive) || !(jsonPrimitive = (JsonPrimitive)childElement).isString() || !(possibleReference = jsonPrimitive.getAsString()).matches("#.*") || !references.containsKey(possibleReference)) continue;
                    jsonObject.add(key, references.get(possibleReference));
                }
                break block7;
            }
            if (!(jsonElement instanceof JsonArray)) break block7;
            JsonArray jsonArray = (JsonArray)jsonElement;
            List list = jsonArray.asList();
            for (int i = 0; i < list.size(); ++i) {
                String possibleReference;
                JsonPrimitive jsonPrimitive;
                JsonElement childElement = (JsonElement)list.get(i);
                if (childElement instanceof JsonObject) {
                    JsonObject innerJsonObject = (JsonObject)childElement;
                    CustomRendererLoader.resolveReferences(references, (JsonElement)innerJsonObject);
                    continue;
                }
                if (childElement instanceof JsonArray) {
                    JsonArray innerJsonArray = (JsonArray)childElement;
                    CustomRendererLoader.resolveReferences(references, (JsonElement)innerJsonArray);
                    continue;
                }
                if (!(childElement instanceof JsonPrimitive) || !(jsonPrimitive = (JsonPrimitive)childElement).isString() || !(possibleReference = jsonPrimitive.getAsString()).matches("#.*") || !references.containsKey(possibleReference)) continue;
                jsonArray.set(i, references.get(possibleReference));
            }
        }
    }

    @ApiStatus.Internal
    public static void constantFileResolving(MinecraftServer server, class_2960 id) {
        if (server.method_3816() && Accessories.DEBUG) {
            return;
        }
        CustomRendererLoader.PRIMARY.constantResolveTarget = id;
    }

    public static boolean isConstantResolveTarget() {
        return CustomRendererLoader.PRIMARY.constantResolveTarget != null;
    }

    @Nullable
    protected RenderingFunction.RawRenderer getDataFromId(class_2960 id, boolean isClientSide) {
        class_2960 fileId = class_7654.method_45114((String)this.type).method_45112(id);
        class_3300 resource = this.getResourceManager(isClientSide);
        if (resource != null) {
            try {
                JsonElement element;
                try (BufferedReader reader = resource.openAsReader(fileId);){
                    element = (JsonElement)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonElement.class);
                }
                return (RenderingFunction.RawRenderer)this.endec.decodeFully(GsonDeserializer::of, (Object)element);
            }
            catch (JsonParseException | IOException | IllegalArgumentException e) {
                this.errorIfDifferent(id, e, () -> this.lambda$getDataFromId$1(id, fileId, (Exception)e));
            }
        }
        return null;
    }

    private void minimalErroring(Throwable throwable) {
        if (!this.alwaysResolveFlag) {
            LOGGER.error("", throwable);
            return;
        }
        if (throwable.getCause() != null) {
            this.minimalErroring(throwable.getCause());
        }
        LOGGER.error(throwable.getMessage());
    }

    private void errorIfDifferent(class_2960 id, Throwable e, Runnable runnable) {
        if (!this.alwaysResolveFlag) {
            runnable.run();
            return;
        }
        Integer prevErrorHash = (Integer)ERROR_CACHE.getIfPresent((Object)id);
        int hash = HashUtils.getHash(e);
        if (!Objects.equals(hash, prevErrorHash)) {
            ERROR_CACHE.put((Object)id, (Object)hash);
            runnable.run();
        }
    }

    @NotNull
    private class_3300 getResourceManager(boolean isClientSide) {
        if (!isClientSide) {
            return Owo.currentServer().method_34864();
        }
        return this.getClientManger();
    }

    private class_3300 getClientManger() {
        return class_310.method_1551().method_1478();
    }

    private /* synthetic */ void lambda$getDataFromId$1(class_2960 id, class_2960 fileId, Exception e) {
        LOGGER.error("Couldn't parse data file {} from {}", (Object)id, (Object)fileId);
        this.minimalErroring(e);
    }
}

