/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.data.api;

import com.google.common.base.Objects;
import io.wispforest.accessories.data.api.CustomForwardingSet;
import io.wispforest.accessories.data.api.SequencedBiMap;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.SequencedMap;
import java.util.SequencedSet;
import org.jetbrains.annotations.NotNull;

final class SequencedBiMapImpl<K, V>
implements SequencedBiMap<K, V> {
    private final SequencedMap<K, V> baseMap;
    private final SequencedMap<V, K> inverseMap;
    private final SequencedBiMapImpl<V, K> inverseView;

    SequencedBiMapImpl(SequencedMap<K, V> baseMap, SequencedMap<V, K> inverseMap, SequencedBiMapImpl<V, K> inverseView) {
        this.baseMap = baseMap;
        this.inverseMap = inverseMap;
        this.inverseView = inverseView;
    }

    SequencedBiMapImpl(SequencedMap<K, V> baseMap, SequencedMap<V, K> inverseMap) {
        this.baseMap = baseMap;
        this.inverseMap = inverseMap;
        this.inverseView = new SequencedBiMapImpl<K, V>(inverseMap, baseMap, this);
    }

    SequencedBiMapImpl(SequencedBiMap.SequencedMapFactory factory) {
        this(factory.create(0), factory.create(0));
    }

    @Override
    public int size() {
        return this.baseMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.baseMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.baseMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.inverseMap.containsKey(value);
    }

    @Override
    public V get(Object key) {
        return this.baseMap.get(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        map.forEach(this::put);
    }

    @Override
    public V put(K key, V value) {
        return this.putInBothMaps(key, value, false, MapPutOperation.PUT);
    }

    @Override
    public V putLast(K key, V value) {
        return this.putInBothMaps(key, value, false, MapPutOperation.PUT_LAST);
    }

    @Override
    public V putFirst(K key, V value) {
        return this.putInBothMaps(key, value, false, MapPutOperation.PUT_FIRST);
    }

    @Override
    public V forcePut(K key, V value) {
        return this.putInBothMaps(key, value, true, MapPutOperation.PUT);
    }

    @Override
    public V forcePutLast(K key, V value) {
        return this.putInBothMaps(key, value, true, MapPutOperation.PUT_LAST);
    }

    @Override
    public V forcePutFirst(K key, V value) {
        return this.putInBothMaps(key, value, true, MapPutOperation.PUT_FIRST);
    }

    private V putInBothMaps(K key, V value, boolean force, MapPutOperation operation) {
        boolean containedKey = this.containsKey(key);
        if (containedKey && Objects.equal(value, this.get(key))) {
            return value;
        }
        if (force) {
            this.inverse().remove(value);
        } else if (this.containsValue(value)) {
            throw new IllegalArgumentException("value already present: " + String.valueOf(value));
        }
        V oldValue = operation.put(this.baseMap, key, value);
        if (containedKey) {
            this.inverseMap.remove(oldValue);
        }
        operation.put(this.inverseMap, value, key);
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        V value = null;
        if (this.baseMap.containsKey(key)) {
            value = this.baseMap.remove(key);
            this.inverseMap.remove(value);
        }
        return value;
    }

    @Override
    public void clear() {
        this.baseMap.clear();
        this.inverseMap.clear();
    }

    @Override
    @NotNull
    public SequencedSet<K> keySet() {
        return new CustomForwardingSet(this, map -> map.baseMap.sequencedKeySet(), key -> {
            if (!this.containsKey(key)) {
                return false;
            }
            this.remove(key);
            return true;
        });
    }

    @Override
    public SequencedSet<V> values() {
        return new CustomForwardingSet(this, map -> map.inverseView.sequencedKeySet(), key -> {
            V value = this.get(key);
            if (!this.containsValue(value)) {
                return false;
            }
            return this.remove(key, value);
        });
    }

    @Override
    @NotNull
    public SequencedSet<Map.Entry<K, V>> entrySet() {
        return new CustomForwardingSet(this, map -> map.baseMap.sequencedEntrySet(), key -> {
            V value = this.get(key);
            if (!this.containsValue(value)) {
                return false;
            }
            return this.remove(key, value);
        });
    }

    @Override
    public SequencedBiMap<V, K> inverse() {
        return this.inverseView;
    }

    @Override
    public SequencedSet<Map.Entry<K, V>> sequencedEntrySet() {
        return this.entrySet();
    }

    @Override
    public SequencedCollection<V> sequencedValues() {
        return this.values();
    }

    @Override
    public SequencedSet<K> sequencedKeySet() {
        return this.keySet();
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return this.wrapEntry(this.baseMap.pollLastEntry());
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        return this.wrapEntry(this.baseMap.pollFirstEntry());
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.wrapEntry(this.baseMap.lastEntry());
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.wrapEntry(this.baseMap.firstEntry());
    }

    private Map.Entry<K, V> wrapEntry(final Map.Entry<K, V> entry) {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return entry.getKey();
            }

            @Override
            public V getValue() {
                return entry.getValue();
            }

            @Override
            public V setValue(V value) {
                return SequencedBiMapImpl.this.put(this.getKey(), value);
            }

            @Override
            public boolean equals(Object obj) {
                return entry.equals(obj);
            }

            @Override
            public int hashCode() {
                return entry.hashCode();
            }
        };
    }

    @Override
    public SequencedBiMap<K, V> reversed() {
        return new SequencedBiMapImpl<K, V>(this.baseMap.reversed(), this.inverseMap.reversed());
    }

    @Override
    public boolean equals(Object o) {
        Map m;
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map) || (m = (Map)o).size() != this.size()) {
            return false;
        }
        return this.baseMap.equals(m);
    }

    @Override
    public int hashCode() {
        return this.baseMap.hashCode();
    }

    public String toString() {
        return this.baseMap.toString();
    }

    private static interface MapPutOperation {
        public static final MapPutOperation PUT = Map::put;
        public static final MapPutOperation PUT_LAST = SequencedMap::putLast;
        public static final MapPutOperation PUT_FIRST = SequencedMap::putFirst;

        public <K, V> V put(SequencedMap<K, V> var1, K var2, V var3);
    }
}

