/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.data.api;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.data.api.SyncedDataHelper;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.network.ClientAccess;
import io.wispforest.owo.network.OwoNetChannel;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SyncedDataHelperManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<class_2960, SyncedDataHelper<?>> ALL_SYNCED_LOADERS = new LinkedHashMap();

    public static void registerLoader(SyncedDataHelper<?> loader) {
        if (ALL_SYNCED_LOADERS.containsKey(loader.getId())) {
            throw new IllegalStateException("An already existing SyncedDataLoader has been registered! [Id: " + String.valueOf(loader.getId()) + "]");
        }
        ALL_SYNCED_LOADERS.put(loader.getId(), loader);
    }

    @Nullable
    public static SyncedDataHelper<?> getLoader(class_2960 id) {
        return ALL_SYNCED_LOADERS.get(id);
    }

    @ApiStatus.Internal
    public static void init(OwoNetChannel channel, Consumer<Consumer<class_1657>> hookRegistration) {
        channel.registerClientboundDeferred(SyncAllLoaderDataPacket.class, SyncAllLoaderDataPacket.ENDEC);
        hookRegistration.accept(player -> {
            List endecDataLoaders = ALL_SYNCED_LOADERS.values().stream().collect(Collectors.toList());
            HashSet<class_2960> resolvedIds = new HashSet<class_2960>();
            for (SyncedDataHelper dataLoader2 : endecDataLoaders) {
                resolvedIds.add(dataLoader2.getId());
            }
            ArrayList<SyncedDataHelper> dataLoaders = new ArrayList<SyncedDataHelper>();
            int lastSize = -1;
            while (dataLoaders.size() != lastSize) {
                lastSize = dataLoaders.size();
                Iterator it = endecDataLoaders.iterator();
                while (it.hasNext()) {
                    SyncedDataHelper dataLoader3 = (SyncedDataHelper)it.next();
                    if (!resolvedIds.containsAll(dataLoader3.getDependencyIds())) continue;
                    resolvedIds.add(dataLoader3.getId());
                    dataLoaders.add(dataLoader3);
                    it.remove();
                }
            }
            List<SyncLoaderDataPacket> packets = dataLoaders.stream().map(dataLoader -> {
                class_2960 id = dataLoader.getId();
                Object data = dataLoader.getServerData();
                return new SyncLoaderDataPacket(id, data);
            }).toList();
            channel.serverHandle(player).send((Record)new SyncAllLoaderDataPacket(packets));
        });
    }

    @ApiStatus.Internal
    public static void initClient(OwoNetChannel channel) {
        channel.registerClientbound(SyncAllLoaderDataPacket.class, SyncAllLoaderDataPacket.ENDEC, SyncAllLoaderDataPacket::handle);
    }

    @ApiStatus.Internal
    private record SyncAllLoaderDataPacket(List<SyncLoaderDataPacket> packets) {
        private static final StructEndec<SyncAllLoaderDataPacket> ENDEC = StructEndecBuilder.of((StructField)SyncLoaderDataPacket.ENDEC.listOf().fieldOf("packets", SyncAllLoaderDataPacket::packets), SyncAllLoaderDataPacket::new);

        private static void handle(SyncAllLoaderDataPacket packet, ClientAccess access) {
            for (SyncLoaderDataPacket innerPacket : packet.packets()) {
                SyncLoaderDataPacket.handle(innerPacket, access);
            }
        }
    }

    @ApiStatus.Internal
    private static final class SyncLoaderDataPacket {
        private static final Map<class_2960, StructEndec<SyncLoaderDataPacket>> CACHED_ENDECS = new HashMap<class_2960, StructEndec<SyncLoaderDataPacket>>();
        private static final StructEndec<SyncLoaderDataPacket> ENDEC = Endec.dispatched(id -> {
            SyncedDataHelper<?> loader = SyncedDataHelperManager.getLoader(id);
            if (loader == null) {
                throw new IllegalStateException("Unable to get following Data Loader to handle the given sync packet: " + String.valueOf(id));
            }
            return (Endec)CACHED_ENDECS.computeIfAbsent((class_2960)id, identifier -> StructEndecBuilder.of((StructField)MinecraftEndecs.IDENTIFIER.fieldOf("id", SyncLoaderDataPacket::id), (StructField)loader.syncDataEndec().fieldOf("data", SyncLoaderDataPacket::data), SyncLoaderDataPacket::new));
        }, SyncLoaderDataPacket::id, (Endec)MinecraftEndecs.IDENTIFIER);
        private final class_2960 id;
        private final Object data;

        private SyncLoaderDataPacket(class_2960 id, Object data) {
            this.id = id;
            this.data = data;
        }

        private static void handle(SyncLoaderDataPacket packet, ClientAccess access) {
            SyncedDataHelper<?> loader = SyncedDataHelperManager.getLoader(packet.id());
            Exception exception = loader.onReceivedDataUnsafe(packet.data());
            if (exception != null) {
                LOGGER.error("An error has occured when attempting to send sync data to the given SyncedDataLoader: {}", (Object)packet.id(), (Object)exception);
                throw new RuntimeException(exception);
            }
        }

        public class_2960 id() {
            return this.id;
        }

        public Object data() {
            return this.data;
        }
    }
}

