/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.equip.EquipAction;
import io.wispforest.accessories.api.equip.EquipCheck;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoryAttributeLogic;
import io.wispforest.accessories.impl.core.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import io.wispforest.accessories.impl.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.client.SyncEntireContainer;
import io.wispforest.accessories.utils.InstanceEndec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.util.MapCarrierDecodable;
import io.wispforest.endec.util.MapCarrierEncodable;
import io.wispforest.owo.serialization.RegistriesAttribute;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Internal
public class AccessoriesCapabilityImpl
implements AccessoriesCapability,
InstanceEndec {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final class_1309 entity;
    private boolean updateContainersLock = false;

    public AccessoriesCapabilityImpl(class_1309 entity) {
        this.entity = entity;
    }

    @Override
    public class_1309 entity() {
        return this.entity;
    }

    @Override
    public Map<String, AccessoriesContainer> getContainers() {
        AccessoriesHolderImpl holder = AccessoriesHolderImpl.getHolder(this);
        for (AccessoriesContainer container : holder.getAllSlotContainers().values()) {
            if (this.entity == container.capability().entity()) break;
            ((AccessoriesContainerImpl)container).capability = this;
        }
        return holder.getSlotContainers();
    }

    @Override
    public void reset(boolean loadedFromTag) {
        class_3222 serverPlayer;
        AccessoriesHolderImpl holder;
        block7: {
            block6: {
                Object currentContainers;
                if (this.entity.method_73183().method_8608()) {
                    return;
                }
                holder = AccessoriesInternals.getHolder(this.entity);
                if (!loadedFromTag) {
                    Map<String, AccessoriesContainer> oldContainers = Map.copyOf(holder.getAllSlotContainers());
                    holder.init(this);
                    currentContainers = holder.getAllSlotContainers();
                    oldContainers.forEach((arg_0, arg_1) -> AccessoriesCapabilityImpl.lambda$reset$0((Map)currentContainers, arg_0, arg_1));
                } else {
                    holder.init(this);
                }
                currentContainers = this.entity;
                if (!(currentContainers instanceof class_3222)) break block6;
                serverPlayer = (class_3222)currentContainers;
                if (serverPlayer.field_13987 != null) break block7;
            }
            return;
        }
        NbtMapCarrier carrier = NbtMapCarrier.of();
        holder.encode((MapCarrierEncodable)carrier, SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((class_5455)this.entity.method_73183().method_30349())}));
        AccessoriesNetworking.sendToTrackingAndSelf((class_1297)serverPlayer, new SyncEntireContainer(serverPlayer.method_5628(), carrier));
    }

    @Override
    public void updateContainers() {
        boolean hasUpdateOccurred;
        if (this.updateContainersLock) {
            return;
        }
        Collection<AccessoriesContainer> containers = this.getContainers().values();
        this.updateContainersLock = true;
        do {
            hasUpdateOccurred = false;
            for (AccessoriesContainer container : containers) {
                if (!container.hasChanged()) continue;
                container.update();
                hasUpdateOccurred = true;
            }
        } while (hasUpdateOccurred);
        this.updateContainersLock = false;
    }

    @Override
    public void addTransientSlotModifiers(Multimap<String, class_1322> modifiers) {
        Map<String, AccessoriesContainer> containers = this.getContainers();
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            if (!containers.containsKey(entry.getKey())) continue;
            AccessoriesContainer container = containers.get(entry.getKey());
            ((Collection)entry.getValue()).forEach(container::addTransientModifier);
        }
    }

    @Override
    public void addPersistentSlotModifiers(Multimap<String, class_1322> modifiers) {
        Map<String, AccessoriesContainer> containers = this.getContainers();
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            if (!containers.containsKey(entry.getKey())) continue;
            AccessoriesContainer container = containers.get(entry.getKey());
            ((Collection)entry.getValue()).forEach(container::addPersistentModifier);
        }
    }

    @Override
    public void removeSlotModifiers(Multimap<String, class_1322> modifiers) {
        Map<String, AccessoriesContainer> containers = this.getContainers();
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            if (!containers.containsKey(entry.getKey())) continue;
            AccessoriesContainer container = containers.get(entry.getKey());
            ((Collection)entry.getValue()).forEach(modifier -> container.removeModifier(modifier.comp_2447()));
        }
    }

    @Override
    public Multimap<String, class_1322> getSlotModifiers() {
        HashMultimap modifiers = HashMultimap.create();
        this.getContainers().forEach((arg_0, arg_1) -> AccessoriesCapabilityImpl.lambda$getSlotModifiers$2((Multimap)modifiers, arg_0, arg_1));
        return modifiers;
    }

    @Override
    public void clearSlotModifiers() {
        this.getContainers().forEach((s, container) -> container.clearModifiers());
    }

    @Override
    public void clearCachedSlotModifiers() {
        HashMultimap slotModifiers = HashMultimap.create();
        Map<String, AccessoriesContainer> containers = this.getContainers();
        containers.forEach((name, container) -> {
            Set<class_1322> modifiers = container.getCachedModifiers();
            if (modifiers.isEmpty()) {
                return;
            }
            ExpandedContainer accessories = container.getAccessories();
            for (int i = 0; i < accessories.method_5439(); ++i) {
                class_1799 stack = accessories.method_5438(i);
                if (stack.method_7960()) continue;
                SlotReference slotReference = container.createReference(i);
                slotModifiers.putAll(AccessoryAttributeLogic.getAttributeModifiers(stack, slotReference).getSlotModifiers());
            }
        });
        slotModifiers.asMap().forEach((name, modifiers) -> {
            if (!containers.containsKey(name)) {
                return;
            }
            AccessoriesContainer container = (AccessoriesContainer)containers.get(name);
            modifiers.forEach(container.getCachedModifiers()::remove);
            container.clearCachedModifiers();
        });
    }

    @Override
    @Nullable
    public Pair<SlotReference, EquipAction> canEquipAccessory(class_1799 stack, boolean allowSwapping, EquipCheck extraCheck) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        if (accessory == null) {
            return null;
        }
        HashMap<String, AccessoriesContainer> validContainers = new HashMap<String, AccessoriesContainer>();
        if (stack.method_7960() && allowSwapping) {
            Map<String, AccessoriesContainer> allContainers = this.getContainers();
            EntitySlotLoader.getEntitySlots(this.entity()).forEach((s, slotType) -> validContainers.put((String)s, (AccessoriesContainer)allContainers.get(slotType.name())));
        } else {
            for (AccessoriesContainer container : this.getContainers().values()) {
                boolean isValid;
                if (container.getSize() <= 0 || !(isValid = SlotPredicateRegistry.canInsertIntoSlot(stack, container.createReference(0))) || !ExtraSlotTypeProperties.getProperty(container.getSlotName(), this.entity.method_73183().method_8608()).allowEquipFromUse()) continue;
                if (allowSwapping) {
                    validContainers.put(container.getSlotName(), container);
                }
                ExpandedContainer accessories = container.getAccessories();
                for (int i = 0; i < container.getSize(); ++i) {
                    class_1799 slotStack = accessories.method_5438(i);
                    SlotReference slotReference = container.createReference(i);
                    if (!slotStack.method_7960() || !AccessoryRegistry.canUnequip(slotStack, slotReference) || !SlotPredicateRegistry.canInsertIntoSlot(stack, slotReference) || !extraCheck.isValid(slotStack, false)) continue;
                    return Pair.of((Object)container.createReference(i), newStack -> this.setStack(slotReference, newStack, false));
                }
            }
        }
        for (AccessoriesContainer validContainer : validContainers.values()) {
            ExpandedContainer accessories = validContainer.getAccessories();
            for (int i = 0; i < accessories.method_5439(); ++i) {
                class_1799 slotStack = accessories.method_5438(i).method_7972();
                SlotReference slotReference = validContainer.createReference(i);
                if (slotStack.method_7960() || !AccessoryRegistry.canUnequip(slotStack, slotReference) || !stack.method_7960() && (!SlotPredicateRegistry.canInsertIntoSlot(stack, slotReference) || !extraCheck.isValid(slotStack, true))) continue;
                return Pair.of((Object)slotReference, newStack -> this.setStack(slotReference, newStack, true));
            }
        }
        return null;
    }

    private Optional<class_1799> setStack(SlotReference reference, class_1799 newStack, boolean shouldSwapStacks) {
        class_1799 oldStack = reference.getStack();
        oldStack = oldStack == null ? class_1799.field_8037 : oldStack.method_7972();
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(oldStack);
        if (shouldSwapStacks) {
            class_1799 splitStack;
            class_1799 class_17992 = splitStack = newStack.method_7960() ? class_1799.field_8037 : newStack.method_7971(accessory.maxStackSize(newStack));
            if (!this.entity.method_73183().method_8608()) {
                reference.setStack(splitStack);
            }
            return Optional.of(oldStack);
        }
        if (!this.entity.method_73183().method_8608()) {
            class_1799 splitStack = newStack.method_7971(accessory.maxStackSize(newStack));
            reference.setStack(splitStack);
        }
        return Optional.empty();
    }

    @Override
    public void encode(MapCarrierEncodable carrier, SerializationContext ctx) {
        AccessoriesHolderImpl.getHolder(this).encode(carrier, ctx);
    }

    @Override
    public void decode(MapCarrierDecodable carrier, SerializationContext ctx) {
        AccessoriesHolderImpl.getHolder(this).decode(carrier, ctx);
    }

    private static /* synthetic */ void lambda$getSlotModifiers$2(Multimap modifiers, String s, AccessoriesContainer container) {
        modifiers.putAll((Object)s, container.getModifiers().values());
    }

    private static /* synthetic */ void lambda$reset$0(Map currentContainers, String s, AccessoriesContainer oldContainer) {
        AccessoriesContainer currentContainer = (AccessoriesContainer)currentContainers.get(s);
        currentContainer.getAccessories().setFromPrev(oldContainer.getAccessories());
        currentContainer.markChanged(false);
    }
}

