/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.menu;

import io.wispforest.accessories.compat.config.ScreenType;
import io.wispforest.accessories.menu.AccessoriesMenuTypes;
import io.wispforest.accessories.menu.variants.AccessoriesMenu;
import io.wispforest.accessories.menu.variants.AccessoriesMenuBase;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_3917;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public enum AccessoriesMenuVariant {
    PRIMARY_V2(() -> AccessoriesMenuTypes.PRIAMRY_MENU);

    public final Supplier<class_3917<? extends AccessoriesMenuBase>> supplier;

    private AccessoriesMenuVariant(Supplier<class_3917<? extends AccessoriesMenuBase>> supplier) {
        this.supplier = supplier;
    }

    @Nullable
    public static AccessoriesMenuVariant getVariant(ScreenType screenType) {
        return switch (screenType) {
            case ScreenType.PRIMARY_V2 -> PRIMARY_V2;
            default -> null;
        };
    }

    public static AccessoriesMenuVariant getVariant(class_3917<? extends AccessoriesMenuBase> menuType) {
        for (AccessoriesMenuVariant value : AccessoriesMenuVariant.values()) {
            if (!value.supplier.get().equals(menuType)) continue;
            return value;
        }
        throw new IllegalArgumentException("Unknown MenuType passed to get Accessories Menu Variant! [Type: " + String.valueOf(class_7923.field_41187.method_10221(menuType)) + "]");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static class_1703 openMenu(int i, class_1661 inv, AccessoriesMenuVariant variant, @Nullable class_1309 target, @Nullable class_1799 carriedStack) {
        switch (variant.ordinal()) {
            case 0: {
                return new AccessoriesMenu(i, inv, target, carriedStack);
            }
            default: {
                throw new IllegalArgumentException("Unknown AccessoriesMenuVariant passed to construct Menu! [Variant: " + variant.name() + "]");
            }
        }
    }
}

