/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.wispforest.accessories.pond.stack.PatchedDataComponentMapExtension;
import io.wispforest.accessories.utils.ConcurrentBarrier;
import io.wispforest.accessories.utils.EnhancedEventStream;
import io.wispforest.accessories.utils.ItemStackMutation;
import io.wispforest.owo.util.EventStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9335;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_9335.class})
public abstract class PatchedDataComponentMapMixin
implements PatchedDataComponentMapExtension {
    @Unique
    private boolean changeCheckStack = false;
    @Unique
    @Nullable
    private class_1799 itemStack = null;
    @Unique
    @Nullable
    private EventStream<ItemStackMutation> mutationEvent = null;
    @Unique
    private boolean inApplyPatchLock = false;

    @Override
    public EventStream<ItemStackMutation> accessories$getMutationEvent(class_1799 itemStack) {
        Objects.requireNonNull(itemStack);
        this.itemStack = itemStack;
        if (this.mutationEvent == null) {
            this.mutationEvent = EnhancedEventStream.of((invokers, barrier) -> (stack, types) -> {
                try (ConcurrentBarrier concurrentBarrier = barrier;){
                    invokers.forEach(itemStackMutation -> itemStackMutation.onMutation(stack, types));
                }
            }, () -> {
                this.mutationEvent = null;
            });
        }
        return this.mutationEvent;
    }

    @Override
    public boolean accessories$hasChanged() {
        boolean bl = this.changeCheckStack;
        this.changeCheckStack = false;
        return bl;
    }

    @Inject(method={"set"}, at={@At(value="HEAD")})
    private <T> void accessories$updateChangeValue_set(class_9331<? super T> component, @Nullable T value, CallbackInfoReturnable<T> cir) {
        this.changeCheckStack = true;
        this.accessories$handleMutationEvent(List.of(component));
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    private <T> void accessories$updateChangeValue_remove(class_9331<? super T> component, CallbackInfoReturnable<T> cir) {
        this.changeCheckStack = true;
        this.accessories$handleMutationEvent(List.of(component));
    }

    @WrapMethod(method={"applyPatch(Lnet/minecraft/core/component/DataComponentPatch;)V", "method_57936(Lnet/minecraft/class_9326;)V", "applyChanges(Lnet/minecraft/component/ComponentChanges;)V"}, expect=1, require=1, allow=1)
    private void accessories$updateChangeValue(class_9326 patch, Operation<Void> original) {
        this.changeCheckStack = true;
        this.inApplyPatchLock = true;
        original.call(new Object[]{patch});
        this.inApplyPatchLock = false;
        List<class_9331<?>> changedDataTypes = patch.method_57846().stream().map(Map.Entry::getKey).toList();
        this.accessories$handleMutationEvent(changedDataTypes);
    }

    @Inject(method={"applyPatch(Lnet/minecraft/core/component/DataComponentType;Ljava/util/Optional;)V"}, at={@At(value="HEAD")})
    private void accessories$updateChangeValue_applyPatch(class_9331<?> component, Optional<?> value, CallbackInfo ci) {
        this.changeCheckStack = true;
        if (!this.inApplyPatchLock) {
            this.accessories$handleMutationEvent(List.of(component));
        }
    }

    @Inject(method={"restorePatch"}, at={@At(value="HEAD")})
    private void accessories$updateChangeValue_restorePatch(class_9326 patch, CallbackInfo ci) {
        this.changeCheckStack = true;
        List<class_9331<?>> changedDataTypes = patch.method_57846().stream().map(Map.Entry::getKey).toList();
        this.accessories$handleMutationEvent(changedDataTypes);
    }

    @Unique
    private void accessories$handleMutationEvent(List<class_9331<?>> changedDataTypes) {
        if (this.mutationEvent == null) {
            return;
        }
        ((ItemStackMutation)this.mutationEvent.sink()).onMutation(this.itemStack, changedDataTypes);
    }
}

