/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.mixin.EntityTrackerAccessor;
import io.wispforest.accessories.mixin.ServerChunkLoadingManagerAccessor;
import io.wispforest.accessories.networking.client.AccessoryBreak;
import io.wispforest.accessories.networking.client.InvalidateEntityCache;
import io.wispforest.accessories.networking.client.ScreenVariantPing;
import io.wispforest.accessories.networking.client.SyncContainerData;
import io.wispforest.accessories.networking.client.SyncEntireContainer;
import io.wispforest.accessories.networking.client.SyncPlayerOptions;
import io.wispforest.accessories.networking.holder.SyncOptionChange;
import io.wispforest.accessories.networking.server.ContainerClose;
import io.wispforest.accessories.networking.server.NukeAccessories;
import io.wispforest.accessories.networking.server.ScreenOpen;
import io.wispforest.accessories.networking.server.SyncCosmeticToggle;
import io.wispforest.owo.network.ClientAccess;
import io.wispforest.owo.network.OwoNetChannel;
import io.wispforest.owo.network.ServerAccess;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2802;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_5629;
import net.minecraft.server.MinecraftServer;

public class AccessoriesNetworking {
    public static final OwoNetChannel CHANNEL = OwoNetChannel.create((class_2960)Accessories.of("main"));

    public static void init() {
        CHANNEL.registerServerbound(ScreenOpen.class, ScreenOpen.ENDEC, AccessoriesNetworking.serverHandler(ScreenOpen::handlePacket));
        CHANNEL.registerServerbound(NukeAccessories.class, NukeAccessories.ENDEC, AccessoriesNetworking.serverHandler(NukeAccessories::handlePacket));
        CHANNEL.registerServerbound(SyncCosmeticToggle.class, SyncCosmeticToggle.ENDEC, AccessoriesNetworking.serverHandler(SyncCosmeticToggle::handlePacket));
        CHANNEL.registerServerbound(SyncOptionChange.class, SyncOptionChange.ENDEC, AccessoriesNetworking.serverHandler(SyncOptionChange::handlePacket));
        CHANNEL.registerServerbound(ContainerClose.class, ContainerClose.ENDEC, AccessoriesNetworking.serverHandler(ContainerClose::handlePacket));
        CHANNEL.registerClientboundDeferred(SyncEntireContainer.class, SyncEntireContainer.ENDEC);
        CHANNEL.registerClientboundDeferred(SyncContainerData.class, SyncContainerData.ENDEC);
        CHANNEL.registerClientboundDeferred(SyncPlayerOptions.class, SyncPlayerOptions.ENDEC);
        CHANNEL.registerClientboundDeferred(AccessoryBreak.class, AccessoryBreak.ENDEC);
        CHANNEL.registerClientboundDeferred(InvalidateEntityCache.class, InvalidateEntityCache.ENDEC);
        CHANNEL.registerClientboundDeferred(ScreenVariantPing.class, ScreenVariantPing.ENDEC);
        CHANNEL.registerClientboundDeferred(SyncOptionChange.class, SyncOptionChange.ENDEC);
    }

    public static void initClient() {
        CHANNEL.registerClientbound(SyncEntireContainer.class, SyncEntireContainer.ENDEC, AccessoriesNetworking.clientHandler(SyncEntireContainer::handlePacket));
        CHANNEL.registerClientbound(SyncContainerData.class, SyncContainerData.ENDEC, AccessoriesNetworking.clientHandler(SyncContainerData::handlePacket));
        CHANNEL.registerClientbound(SyncPlayerOptions.class, SyncPlayerOptions.ENDEC, AccessoriesNetworking.clientHandler(SyncPlayerOptions::handlePacket));
        CHANNEL.registerClientbound(AccessoryBreak.class, AccessoryBreak.ENDEC, AccessoriesNetworking.clientHandler(AccessoryBreak::handlePacket));
        CHANNEL.registerClientbound(InvalidateEntityCache.class, InvalidateEntityCache.ENDEC, AccessoriesNetworking.clientHandler(InvalidateEntityCache::handlePacket));
        CHANNEL.registerClientbound(ScreenVariantPing.class, ScreenVariantPing.ENDEC, AccessoriesNetworking.clientHandler(ScreenVariantPing::handlePacket));
        CHANNEL.registerClientbound(SyncOptionChange.class, SyncOptionChange.ENDEC, AccessoriesNetworking.clientHandler(SyncOptionChange::handlePacket));
    }

    public static <R extends Record> OwoNetChannel.ChannelHandler<R, ClientAccess> clientHandler(BiConsumer<R, class_1657> consumer) {
        return (r, access) -> consumer.accept((Object)r, (class_1657)access.player());
    }

    public static <R extends Record> OwoNetChannel.ChannelHandler<R, ServerAccess> serverHandler(BiConsumer<R, class_1657> consumer) {
        return (r, access) -> consumer.accept((Object)r, (class_1657)access.player());
    }

    public static <R extends Record> void sendToServer(R packet) {
        CHANNEL.clientHandle().send(packet);
    }

    public static <R extends Record> void sendToPlayer(class_3222 player, R packet) {
        CHANNEL.serverHandle((class_1657)player).send(packet);
    }

    public static <R extends Record> void sendToAllPlayers(MinecraftServer server, R packet) {
        for (class_3222 player : server.method_3760().method_14571()) {
            AccessoriesNetworking.sendToPlayer(player, packet);
        }
    }

    public static <R extends Record> void sendToTrackingAndSelf(class_1297 entity, R packet) {
        ArrayList<class_3222> targets = new ArrayList<class_3222>();
        class_2802 class_28022 = entity.method_73183().method_8398();
        if (class_28022 instanceof class_3215) {
            class_3215 chunkCache = (class_3215)class_28022;
            class_3898 chunkLoadingManager = chunkCache.field_17254;
            EntityTrackerAccessor tracker = (EntityTrackerAccessor)((ServerChunkLoadingManagerAccessor)chunkLoadingManager).accessories$getEntityMap().get(entity.method_5628());
            if (tracker != null) {
                targets.addAll(tracker.accessories$getSeenBy().stream().map(class_5629::method_32311).collect(Collectors.toUnmodifiableSet()));
            }
        }
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            targets.add(serverPlayer);
        }
        CHANNEL.serverHandle(targets).send(packet);
    }
}

