/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.utils;

import io.wispforest.accessories.utils.ConcurrentBarrier;
import io.wispforest.owo.util.EventStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.mutable.MutableObject;

public class EnhancedEventStream<T>
extends EventStream<T>
implements ConcurrentBarrier {
    private final Set<Runnable> subscriptionUpdates = new HashSet<Runnable>();
    private final Runnable onEmptyCallback;
    private boolean isSinking = false;

    private EnhancedEventStream(Function<List<T>, T> sinkFactory, MutableObject<ConcurrentBarrier> barrierHolder, Runnable onEmptyCallback) {
        super(sinkFactory);
        this.onEmptyCallback = onEmptyCallback;
        barrierHolder.setValue((Object)this);
    }

    public static <T> EnhancedEventStream<T> of(BiFunction<List<T>, ConcurrentBarrier, T> sinkFactory, Runnable onEmptyCallback) {
        MutableObject currentlySinkingFlag = new MutableObject(null);
        return new EnhancedEventStream<Object>(ts -> sinkFactory.apply((List)ts, value -> ((ConcurrentBarrier)currentlySinkingFlag.getValue()).setSinking(value)), (MutableObject<ConcurrentBarrier>)currentlySinkingFlag, onEmptyCallback);
    }

    public T sink() {
        this.isSinking = true;
        return (T)super.sink();
    }

    protected void addSubscriber(T subscriber) {
        if (this.isSinking) {
            this.subscriptionUpdates.add(() -> this.addSubscriber(subscriber));
            return;
        }
        super.addSubscriber(subscriber);
    }

    protected void removeSubscriber(T subscriber) {
        if (this.isSinking) {
            this.subscriptionUpdates.add(() -> this.removeSubscriber(subscriber));
            return;
        }
        super.removeSubscriber(subscriber);
        if (this.subscribers.isEmpty()) {
            this.onEmptyCallback.run();
        }
    }

    @Override
    public void setSinking(boolean value) {
        this.isSinking = value;
        if (!value) {
            for (Runnable subscriptionUpdate : this.subscriptionUpdates) {
                subscriptionUpdate.run();
            }
            this.subscriptionUpdates.clear();
        }
    }
}

