/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories;

import com.google.common.reflect.Reflection;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.AccessoriesLoaderInternals;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.events.AllowEntityModificationCallback;
import io.wispforest.accessories.commands.AccessoriesCommands;
import io.wispforest.accessories.compat.config.AccessoriesConfig;
import io.wispforest.accessories.criteria.AccessoryChangedCriterion;
import io.wispforest.accessories.data.CustomRendererLoader;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.event.VanillaItemPredicates;
import io.wispforest.accessories.impl.option.AccessoriesPlayerOptionsHolder;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.menu.ArmorSlotTypes;
import io.wispforest.accessories.mixin.CriteriaTriggersAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.client.ScreenVariantPing;
import io.wispforest.accessories.networking.client.SyncServerOverrideOption;
import io.wispforest.accessories.utils.EndecUtils;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.slf4j.Logger;

public class Accessories {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation SLOT_LOADER_LOCATION = Accessories.of("slot_loader");
    public static final ResourceLocation ENTITY_SLOT_LOADER_LOCATION = Accessories.of("entity_slot_loader");
    public static final ResourceLocation SLOT_GROUP_LOADER_LOCATION = Accessories.of("slot_group_loader");
    public static final ResourceLocation DATA_RELOAD_HOOK = Accessories.of("data_reload_hook");
    public static final boolean DEBUG;
    public static final String MODID = "accessories";
    private static final AccessoriesConfig CONFIG;
    public static AccessoryChangedCriterion ACCESSORY_EQUIPPED;
    public static AccessoryChangedCriterion ACCESSORY_UNEQUIPPED;

    public static ResourceLocation of(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static ResourceLocation parseLocationOrDefault(String s) {
        ResourceLocation location = ResourceLocation.tryParse((String)s);
        if (location == null) {
            location = Accessories.of(s);
        }
        return location;
    }

    public static String translationKey(String path) {
        return "accessories." + path;
    }

    public static Component translation(String path) {
        return Component.translatable((String)Accessories.translationKey(path));
    }

    public static AccessoriesConfig config() {
        return CONFIG;
    }

    public static void askPlayerForVariant(ServerPlayer player) {
        Accessories.askPlayerForVariant(player, null);
    }

    public static void askPlayerForVariant(ServerPlayer player, @Nullable LivingEntity targetEntity) {
        AccessoriesNetworking.sendToPlayer(player, ScreenVariantPing.of(targetEntity));
    }

    public static boolean attemptOpenScreenPlayer(ServerPlayer player, AccessoriesMenuVariant variant) {
        HitResult result = ProjectileUtil.getHitResultOnViewVector((Entity)player, e -> e instanceof LivingEntity, (double)player.entityInteractionRange());
        if (!(result instanceof EntityHitResult)) {
            return false;
        }
        EntityHitResult entityHitResult = (EntityHitResult)result;
        Accessories.openAccessoriesMenu((Player)player, variant, (LivingEntity)entityHitResult.getEntity());
        return true;
    }

    public static void openAccessoriesMenu(Player player, AccessoriesMenuVariant variant, @Nullable LivingEntity targetEntity) {
        Accessories.openAccessoriesMenu(player, variant, targetEntity, null);
    }

    public static void openAccessoriesMenu(Player player, AccessoriesMenuVariant variant, @Nullable LivingEntity targetEntity, @Nullable ItemStack carriedStack) {
        TriState result;
        if (!(targetEntity == null || player.equals((Object)targetEntity) || (result = ((AllowEntityModificationCallback)AllowEntityModificationCallback.EVENT.invoker()).allowModifications(targetEntity, player, null)).orElse(false) || player.hasPermissions(3))) {
            return;
        }
        AccessoriesInternals.INSTANCE.openAccessoriesMenu(player, variant, targetEntity, carriedStack);
    }

    public static void init() {
        Reflection.initialize((Class[])new Class[]{SlotTypeLoader.class, SlotGroupLoader.class, EntitySlotLoader.class, CustomRendererLoader.class});
        AccessoriesCommands.init();
        AllowEntityModificationCallback.EVENT.register((target, player, reference) -> {
            OwnableEntity ownableEntity;
            boolean isOwnersPet;
            EntityType type = target.getType();
            if (type.is(AccessoriesTags.MODIFIABLE_ENTITY_BLACKLIST)) {
                return TriState.FALSE;
            }
            boolean bl = isOwnersPet = target instanceof OwnableEntity && (ownableEntity = (OwnableEntity)target).getOwner() != null && ownableEntity.getOwner().equals((Object)player);
            if (isOwnersPet || type.is(AccessoriesTags.MODIFIABLE_ENTITY_WHITELIST)) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        });
        ArmorSlotTypes.INSTANCE.init();
        VanillaItemPredicates.init();
        AccessoriesConfig config = Accessories.config();
        AccessoriesConfig.ContentOptions contentOptions = Accessories.config().contentOptions;
        AccessoriesConfig.Keys keys = Accessories.config().keys;
        SyncServerOverrideOption.hookUpdate(contentOptions::subscribeToValidBannerSlots, config, keys.contentOptions_validBannerSlots);
        SyncServerOverrideOption.hookUpdate(contentOptions::subscribeToValidGliderSlots, config, keys.contentOptions_validGliderSlots);
        SyncServerOverrideOption.hookUpdate(contentOptions::subscribeToValidTotemSlots, config, keys.contentOptions_validTotemSlots);
        SyncServerOverrideOption.hookUpdate(contentOptions::subscribeToAllowBannerEquip, config, keys.contentOptions_allowBannerEquip);
        SyncServerOverrideOption.hookUpdate(contentOptions::subscribeToAllowGliderEquip, config, keys.contentOptions_allowGliderEquip);
        SyncServerOverrideOption.hookUpdate(contentOptions::subscribeToAllowTotemEquip, config, keys.contentOptions_allowTotemEquip);
    }

    public static void registerCriteria() {
        ACCESSORY_EQUIPPED = CriteriaTriggersAccessor.accessories$callRegister("accessories:equip_accessory", new AccessoryChangedCriterion());
        ACCESSORY_UNEQUIPPED = CriteriaTriggersAccessor.accessories$callRegister("accessories:unequip_accessory", new AccessoryChangedCriterion());
    }

    public static <T> T handleIoError(String dataName, Function<ProblemReporter.ScopedCollector, T> function) {
        return Accessories.handleIoError(() -> dataName, function);
    }

    public static <T> T handleIoError(ProblemReporter.PathElement pathElement, Function<ProblemReporter.ScopedCollector, T> function) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(pathElement, LOGGER);){
            T t = function.apply(scopedCollector);
            return t;
        }
    }

    public static void handleIoError(String dataName, Consumer<ProblemReporter.ScopedCollector> function) {
        Accessories.handleIoError(() -> dataName, function);
    }

    public static void handleIoError(ProblemReporter.PathElement pathElement, Consumer<ProblemReporter.ScopedCollector> function) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(pathElement, LOGGER);){
            function.accept(scopedCollector);
        }
    }

    static {
        boolean debug = AccessoriesLoaderInternals.INSTANCE.isDevelopmentEnv();
        if (System.getProperty("accessories.debug") != null) {
            debug = Boolean.getBoolean("accessories.debug");
        }
        DEBUG = debug;
        CONFIG = AccessoriesConfig.createAndLoad(serializationBuilder -> {
            serializationBuilder.addEndec(Vector2i.class, EndecUtils.VECTOR_2_I_ENDEC);
            serializationBuilder.addEndec(AccessoriesPlayerOptionsHolder.class, AccessoriesPlayerOptionsHolder.ENDEC);
        });
    }
}

