/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.Map;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface AccessoriesStorage {
    public String getSlotName();

    @Nullable
    default public SlotType slotType() {
        return SlotTypeLoader.INSTANCE.getSlotType(this.isClientSide(), this.getSlotName());
    }

    default public SlotPath createPath(int index) {
        return SlotPath.of(this.getSlotName(), index);
    }

    @ApiStatus.Internal
    public Map<Integer, Boolean> renderOptions();

    default public boolean shouldRender(int index) {
        return this.renderOptions().getOrDefault(index, true);
    }

    public Container getAccessories();

    public Container getCosmeticAccessories();

    public int getSize();

    public boolean isClientSide();

    default public void forEach(StorageStacksConsumer consumer) {
        Container accessories = this.getAccessories();
        Container cosmetics = this.getAccessories();
        for (int i = 0; i < this.getSize(); ++i) {
            ItemStack stack = accessories.getItem(i);
            ItemStack cosmetic = cosmetics.getItem(i);
            consumer.accept(i, stack, cosmetic);
        }
    }

    default public void forEachWithOverride(StorageStacksConsumer consumer) {
        Container accessories = this.getAccessories();
        Container cosmetics = this.getAccessories();
        for (int i = 0; i < this.getSize(); ++i) {
            ItemStack stack = accessories.getItem(i);
            ItemStack cosmetic = cosmetics.getItem(i);
            consumer.accept(i, stack, cosmetic);
        }
    }

    public static interface StorageStacksConsumer {
        public void accept(Integer var1, ItemStack var2, ItemStack var3);
    }
}

