/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import io.wispforest.accessories.api.AccessoriesStorage;
import io.wispforest.accessories.api.AccessoriesStorageLookupUtils;
import io.wispforest.accessories.api.caching.ItemStackBasedPredicate;
import io.wispforest.accessories.api.equip.EquipmentChecking;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotPathWithStack;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface AccessoriesStorageLookup {
    public Map<String, ? extends AccessoriesStorage> getContainers();

    @Nullable
    default public <T> T getFromContainer(SlotPath slotPath, BiFunction<AccessoriesStorage, Integer, T> function) {
        AccessoriesStorage container = this.getContainers().get(slotPath.slotName());
        return container != null ? (T)function.apply(container, slotPath.index()) : null;
    }

    @Nullable
    default public AccessoriesStorage getContainer(SlotPath slotPath) {
        return this.getContainers().get(slotPath.slotName());
    }

    @Nullable
    default public AccessoriesStorage getContainer(SlotType slotType) {
        return this.getContainers().get(slotType.name());
    }

    @Nullable
    default public AccessoriesStorage getContainer(SlotTypeReference reference) {
        return this.getContainers().get(reference.slotName());
    }

    default public boolean isEquipped(Item item) {
        return this.isEquipped(item, EquipmentChecking.ACCESSORIES_ONLY);
    }

    default public boolean isEquipped(Item item, EquipmentChecking check) {
        return this.isEquipped(ItemStackBasedPredicate.ofItem(item), check);
    }

    default public boolean isEquipped(Predicate<ItemStack> predicate) {
        return this.isEquipped(predicate, EquipmentChecking.ACCESSORIES_ONLY);
    }

    default public boolean isEquipped(Predicate<ItemStack> predicate, EquipmentChecking check) {
        return this.isEquipped(ItemStackBasedPredicate.ofPredicate(predicate), check);
    }

    default public boolean isEquipped(ItemStackBasedPredicate predicate, EquipmentChecking check) {
        return this.getFirstEquipped(predicate, check) != null;
    }

    default public boolean isAnotherEquipped(ItemStack stack, SlotPath slotPath, Item item) {
        return this.isAnotherEquipped(stack, slotPath, ItemStackBasedPredicate.ofItem(item));
    }

    default public boolean isAnotherEquipped(ItemStack stack, SlotPath slotPath, Predicate<ItemStack> predicate) {
        return this.isAnotherEquipped(stack, slotPath, ItemStackBasedPredicate.ofPredicate(predicate));
    }

    default public boolean isAnotherEquipped(ItemStack stack, SlotPath slotPath, ItemStackBasedPredicate predicate) {
        List<? extends SlotPathWithStack> equippedStacks = this.getEquipped(predicate);
        if (equippedStacks.size() > 2) {
            for (SlotPathWithStack slotPathWithStack : equippedStacks) {
                if (!slotPathWithStack.path().equals(slotPath)) {
                    return true;
                }
                if (slotPathWithStack.stack().equals(stack)) continue;
                return true;
            }
        } else if (equippedStacks.size() == 1) {
            SlotPathWithStack otherEntryRef = equippedStacks.getFirst();
            if (!otherEntryRef.path().equals(slotPath)) {
                return true;
            }
            return !otherEntryRef.stack().equals(stack);
        }
        return false;
    }

    @Nullable
    default public SlotPathWithStack getFirstEquipped(Item item) {
        return this.getFirstEquipped(item, EquipmentChecking.ACCESSORIES_ONLY);
    }

    @Nullable
    default public SlotPathWithStack getFirstEquipped(Item item, EquipmentChecking check) {
        return this.getFirstEquipped(ItemStackBasedPredicate.ofItem(item), check);
    }

    @Nullable
    default public SlotPathWithStack getFirstEquipped(Predicate<ItemStack> predicate) {
        return this.getFirstEquipped(predicate, EquipmentChecking.ACCESSORIES_ONLY);
    }

    @Nullable
    default public SlotPathWithStack getFirstEquipped(Predicate<ItemStack> predicate, EquipmentChecking check) {
        return this.getFirstEquipped(ItemStackBasedPredicate.ofPredicate(predicate), check);
    }

    @Nullable
    default public SlotPathWithStack getFirstEquipped(ItemStackBasedPredicate predicate, EquipmentChecking check) {
        return AccessoriesStorageLookupUtils.getFirstEquipped(this.getContainers(), SlotPathWithStack::of, predicate, check);
    }

    default public List<? extends SlotPathWithStack> getEquipped(Item item) {
        return this.getEquipped(ItemStackBasedPredicate.ofItem(item));
    }

    default public List<? extends SlotPathWithStack> getEquipped(Predicate<ItemStack> predicate) {
        return this.getEquipped(ItemStackBasedPredicate.ofPredicate(predicate));
    }

    default public List<? extends SlotPathWithStack> getEquipped(ItemStackBasedPredicate predicate) {
        return this.getAllEquipped().stream().filter(reference -> predicate.test(reference.stack())).toList();
    }

    default public List<? extends SlotPathWithStack> getAllEquipped() {
        return AccessoriesStorageLookupUtils.getAllEquipped(this.getContainers(), SlotPathWithStack::of);
    }
}

