/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.attributes;

import io.wispforest.accessories.api.attributes.SlotAttribute;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record AttributeModificationData(@Nullable String slotPath, Holder<Attribute> attribute, AttributeModifier modifier, boolean usedInSlotValidation) {
    private final AttributeModifier modifier;

    public AttributeModificationData(@Nullable String slotPath, Holder<Attribute> attribute, AttributeModifier modifier) {
        this(slotPath, attribute, modifier, false);
    }

    public AttributeModificationData(Holder<Attribute> attribute, AttributeModifier modifier, boolean usedInSlotValidation) {
        this(null, attribute, modifier, usedInSlotValidation);
    }

    public AttributeModificationData(Holder<Attribute> attribute, AttributeModifier modifier) {
        this(attribute, modifier, false);
    }

    public boolean isValid(boolean filterSlotBasedPredicates, boolean isSlotValidation) {
        return this.isValid(filterSlotBasedPredicates ? AllowedType.BASE : AllowedType.ALL, isSlotValidation);
    }

    public boolean isValid(AllowedType mode, boolean isSlotValidation) {
        if (!mode.equals((Object)AllowedType.ALL) && mode.equals((Object)AllowedType.SLOT) != this.attribute().value() instanceof SlotAttribute) {
            return false;
        }
        if (isSlotValidation) {
            return this.usedInSlotValidation();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equalsWithoutPath(Object object) {
        if (!(object instanceof AttributeModificationData)) return false;
        AttributeModificationData that = (AttributeModificationData)object;
        if (this.usedInSlotValidation != that.usedInSlotValidation) return false;
        if (!Objects.equals(this.modifier, that.modifier)) return false;
        if (!Objects.equals(this.attribute, that.attribute)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attribute, this.modifier, this.usedInSlotValidation);
    }

    public AttributeModifier modifier() {
        return this.slotPath != null ? new AttributeModifier(this.modifier.id().withPath(path -> this.slotPath + "/" + path), this.modifier.amount(), this.modifier.operation()) : this.modifier;
    }

    @Override
    public String toString() {
        return "AttributeModifierInstance[attribute=" + String.valueOf(this.attribute) + ", modifier=" + String.valueOf(this.modifier) + "slotPath=" + (this.slotPath != null ? this.slotPath : "none") + "]";
    }

    public static enum AllowedType {
        BASE,
        SLOT,
        ALL;

    }
}

