/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.caching;

import io.wispforest.accessories.api.caching.DataComponentsPredicate;
import io.wispforest.accessories.api.caching.ItemLikeClassPredicate;
import io.wispforest.accessories.api.caching.ItemPredicate;
import io.wispforest.accessories.api.caching.ItemStackPredicate;
import io.wispforest.owo.util.Scary;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;

public abstract class ItemStackBasedPredicate
implements Predicate<ItemStack> {
    private static final String UNKNOWN_PREDICATE = "UNKNOWN";
    private final String name;

    protected ItemStackBasedPredicate(String name) {
        this.name = name;
    }

    public static ItemStackBasedPredicate ofClass(Class<? extends ItemLike> clazz) {
        return ItemStackBasedPredicate.ofClass(UNKNOWN_PREDICATE, clazz);
    }

    public static ItemStackBasedPredicate ofClass(String name, Class<? extends ItemLike> clazz) {
        return new ItemLikeClassPredicate(name, clazz);
    }

    public static ItemStackBasedPredicate ofItem(Item item) {
        return ItemStackBasedPredicate.ofItem(UNKNOWN_PREDICATE, item);
    }

    public static ItemStackBasedPredicate ofItem(String name, Item item) {
        return new ItemPredicate(name, item);
    }

    public static ItemStackBasedPredicate ofComponents(DataComponentType<?> ... dataComponentTypes) {
        return ItemStackBasedPredicate.ofComponents(UNKNOWN_PREDICATE, dataComponentTypes);
    }

    public static ItemStackBasedPredicate ofComponents(String name, DataComponentType<?> ... dataComponentTypes) {
        return new DataComponentsPredicate(name, dataComponentTypes);
    }

    @Scary
    @ApiStatus.Experimental
    public static ItemStackBasedPredicate ofPredicate(Predicate<ItemStack> predicate) {
        return ItemStackBasedPredicate.ofPredicate(UNKNOWN_PREDICATE, predicate);
    }

    @Scary
    @ApiStatus.Experimental
    public static ItemStackBasedPredicate ofPredicate(String name, Predicate<ItemStack> predicate) {
        if (predicate instanceof ItemStackBasedPredicate) {
            ItemStackBasedPredicate itemStackBasedPredicate = (ItemStackBasedPredicate)predicate;
            return itemStackBasedPredicate;
        }
        return new ItemStackPredicate(name, predicate);
    }

    public final String name() {
        return this.name;
    }

    public String toString() {
        return "Name: " + this.name + ", " + this.extraStringData();
    }

    public abstract String extraStringData();

    @Override
    public abstract boolean test(ItemStack var1);

    public abstract int hashCode();

    protected abstract boolean isEqual(Object var1);

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        return this.isEqual(other);
    }
}

