/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import com.google.common.base.Suppliers;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesStorage;
import io.wispforest.accessories.api.AccessoriesStorageLookup;
import io.wispforest.accessories.api.SimpleAccessoriesStorage;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderState;
import io.wispforest.accessories.api.client.DefaultedContextKey;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotPath;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AccessoriesRenderStateKeys {
    public static final ContextKey<SlotPath> SLOT_PATH = new ContextKey(Accessories.of("slot_path"));
    public static final ContextKey<ItemStack> ITEM_STACK = new ContextKey(Accessories.of("item_stack"));
    public static final ContextKey<@Nullable ItemStackRenderState> ITEM_STACK_STATE = new ContextKey(Accessories.of("item_stack_state"));
    public static final ContextKey<LivingEntityRenderState> ENTITY_STATE = new ContextKey(Accessories.of("entity_state"));
    public static final ContextKey<@Nullable Map<SlotPath, AccessoryRenderState>> ACCESSORY_RENDER_STATES = new ContextKey(Accessories.of("item_stack_render_state"));
    public static final ContextKey<@Nullable AccessoriesStorageLookup> STORAGE_LOOKUP = new ContextKey(Accessories.of("storage_lookup"));
    public static final DefaultedContextKey<List<@Nullable AccessoryRenderState>> NESTED_ACCESSORY_RENDER_STATES = new DefaultedContextKey<List>(Accessories.of("item_stack_render_state"), List::of);
    public static final ContextKey<@Nullable CameraRenderState> CAMERA_STATE = new ContextKey(Accessories.of("entity_uuid"));
    public static final DefaultedContextKey<UUID> ENTITY_UUID = new DefaultedContextKey(Accessories.of("entity_uuid"), Suppliers.memoize(UUID::randomUUID));
    public static final ContextKey<Integer> ENTITY_ID = new DefaultedContextKey<Integer>(Accessories.of("entity_id"), () -> 0);
    public static final DefaultedContextKey<Float> PARTIAL_TICKS = new DefaultedContextKey<Float>(Accessories.of("partial_ticks"), () -> Float.valueOf(0.0f));
    public static final DefaultedContextKey<Integer> LIGHT = new DefaultedContextKey<Integer>(Accessories.of("light"), () -> 1);
    public static final ContextKey<HumanoidArm> ARM = new ContextKey(Accessories.of("arm"));

    public static void setupStateForAccessories(EntityRenderState state, Entity entity, float partialTick, HumanoidArm arm) {
        if (state instanceof LivingEntityRenderState) {
            LivingEntityRenderState livingState = (LivingEntityRenderState)state;
            livingState.setStateData(ARM, (Object)arm);
        }
        AccessoriesRenderStateKeys.setupStateForAccessories(state, entity, partialTick);
    }

    public static void setupStateForAccessories(EntityRenderState state, Entity entity, float partialTick) {
        LivingEntityRenderState livingState;
        block10: {
            block9: {
                if (!(state instanceof LivingEntityRenderState)) break block9;
                livingState = (LivingEntityRenderState)state;
                if (entity instanceof LivingEntity) break block10;
            }
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        livingState.setStateData(ENTITY_UUID, (Object)livingEntity.getUUID());
        livingState.setStateData(ENTITY_ID, (Object)livingEntity.getId());
        livingState.setStateData(PARTIAL_TICKS, (Object)Float.valueOf(partialTick));
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        if (capability == null) {
            return;
        }
        LinkedHashMap<String, AccessoriesStorage> map = new LinkedHashMap<String, AccessoriesStorage>();
        for (Map.Entry<String, AccessoriesContainer> entry : capability.getContainers().entrySet()) {
            map.put(entry.getKey(), SimpleAccessoriesStorage.copy(entry.getValue()));
        }
        if (map.isEmpty()) {
            return;
        }
        AccessoriesStorageLookup lookup = () -> map;
        livingState.setStateData(STORAGE_LOOKUP, (Object)lookup);
        LinkedHashMap<SlotPath, AccessoryRenderState> renderStates = new LinkedHashMap<SlotPath, AccessoryRenderState>();
        for (AccessoriesStorage accessoriesStorage : lookup.getContainers().values()) {
            Container accessories = accessoriesStorage.getAccessories();
            Container cosmetics = accessoriesStorage.getCosmeticAccessories();
            for (int i = 0; i < accessoriesStorage.getSize(); ++i) {
                SlotPath path;
                AccessoryRenderState accessoryState;
                AccessoryRenderer renderer;
                ItemStack stack = accessories.getItem(i);
                ItemStack cosmeticStack = cosmetics.getItem(i);
                if (!cosmeticStack.isEmpty() && Accessories.config().clientOptions.showCosmeticAccessories()) {
                    stack = cosmeticStack;
                }
                if (stack.isEmpty() || (renderer = AccessoriesRendererRegistry.getRenderer(stack)).isEmpty() || (accessoryState = renderer.createRenderState(stack, path = accessoriesStorage.createPath(i), lookup, livingEntity, livingState)) == null) continue;
                renderStates.put(path, accessoryState);
            }
        }
        livingState.setStateData(ACCESSORY_RENDER_STATES, renderStates);
    }
}

