/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import io.wispforest.accessories.api.client.AccessoriesRenderStateKeys;
import io.wispforest.accessories.api.client.DefaultedContextKey;
import io.wispforest.accessories.api.client.RenderStateStorage;
import io.wispforest.accessories.api.slot.SlotPath;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class AccessoryRenderState
implements RenderStateStorage {
    private final List<RenderStateStorage> otherStates = new ArrayList<RenderStateStorage>();
    private final Reference2ObjectMap<ContextKey<?>, Object> stateData = new Reference2ObjectOpenHashMap();

    @Override
    public <T> T getStateData(ContextKey<T> key) {
        T t;
        if (this.stateData.containsKey(key)) {
            return (T)this.stateData.get(key);
        }
        for (RenderStateStorage otherState : this.otherStates) {
            if (!otherState.hasStateData(key)) continue;
            return this.getStateData(key);
        }
        if (key instanceof DefaultedContextKey) {
            DefaultedContextKey defaultedKey = (DefaultedContextKey)key;
            t = defaultedKey.getDefaultValue();
        } else {
            t = null;
        }
        return t;
    }

    @Override
    public <T> boolean hasStateData(ContextKey<T> key) {
        if (this.stateData.containsKey(key)) {
            return true;
        }
        return this.otherStates.stream().anyMatch(state -> state.hasStateData(key));
    }

    @Override
    public <T> void setStateData(ContextKey<T> key, T data) {
        if (data == null) {
            this.stateData.remove(key);
        } else {
            this.stateData.put(key, data);
        }
    }

    @Override
    public void clearExtraData() {
        this.stateData.clear();
    }

    public static AccessoryRenderState setupState(SlotPath path, ItemStack stack, LivingEntity entity, LivingEntityRenderState entityState, boolean createStackRenderState) {
        AccessoryRenderState state = new AccessoryRenderState();
        state.setStateData(AccessoriesRenderStateKeys.SLOT_PATH, path);
        state.setStateData(AccessoriesRenderStateKeys.ITEM_STACK, stack);
        state.setStateData(AccessoriesRenderStateKeys.ENTITY_STATE, entityState);
        if (createStackRenderState) {
            ItemStackRenderState stackRenderState = new ItemStackRenderState();
            Minecraft.getInstance().getItemModelResolver().updateForLiving(stackRenderState, stack, ItemDisplayContext.FIXED, entity);
            state.setStateData(AccessoriesRenderStateKeys.ITEM_STACK_STATE, stackRenderState);
        }
        return state;
    }
}

