/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.api.AccessoriesStorage;
import io.wispforest.accessories.api.AccessoriesStorageLookup;
import io.wispforest.accessories.api.client.AccessoriesRenderStateKeys;
import io.wispforest.accessories.api.client.AccessoryRenderState;
import io.wispforest.accessories.api.client.renderers.BuiltinAccessoryRenderers;
import io.wispforest.accessories.api.client.rendering.ModelTransformOps;
import io.wispforest.accessories.api.client.rendering.Side;
import io.wispforest.accessories.api.slot.SlotPath;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface AccessoryRenderer {
    public <S extends LivingEntityRenderState> void render(AccessoryRenderState var1, S var2, EntityModel<S> var3, PoseStack var4, SubmitNodeCollector var5);

    @Nullable
    default public AccessoryRenderState createRenderState(ItemStack stack, SlotPath path, AccessoriesStorageLookup storageLookup, LivingEntity entity, LivingEntityRenderState entityState) {
        Boolean isRenderingEnabled = storageLookup.getFromContainer(path, AccessoriesStorage::shouldRender);
        if (!this.shouldRender(stack, path, storageLookup, entity, entityState, isRenderingEnabled != null ? isRenderingEnabled : true)) {
            return null;
        }
        AccessoryRenderState accessoryState = AccessoryRenderState.setupState(path, stack, entity, entityState, this.shouldCreateStackRenderState());
        this.extractRenderState(stack, path, storageLookup, entity, entityState, accessoryState);
        return accessoryState;
    }

    default public void extractRenderState(ItemStack stack, SlotPath path, AccessoriesStorageLookup storageLookup, LivingEntity entity, LivingEntityRenderState entityState, AccessoryRenderState accessoryState) {
    }

    default public boolean shouldCreateStackRenderState() {
        return false;
    }

    default public boolean shouldRender(ItemStack stack, SlotPath path, AccessoriesStorageLookup storageLookup, LivingEntity entity, LivingEntityRenderState entityState, boolean isRenderingEnabled) {
        if (entityState.hasStateData(AccessoriesRenderStateKeys.ARM)) {
            return false;
        }
        return isRenderingEnabled;
    }

    public static void transformToFace(PoseStack poseStack, ModelPart part, Side side) {
        ModelTransformOps.transformToFace(poseStack, part, side);
    }

    public static void transformToModelPart(PoseStack poseStack, ModelPart part) {
        ModelTransformOps.transformToModelPart(poseStack, part, 0, 0, 0);
    }

    public static void transformToModelPart(PoseStack poseStack, ModelPart part, @Nullable Number xPercent, @Nullable Number yPercent, @Nullable Number zPercent) {
        ModelTransformOps.transformToModelPart(poseStack, part, xPercent, yPercent, zPercent);
    }

    @ApiStatus.NonExtendable
    default public boolean isEmpty() {
        return this instanceof BuiltinAccessoryRenderers.EmptyRenderer;
    }
}

