/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.renderers;

import com.google.common.collect.Streams;
import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesLoaderInternals;
import io.wispforest.accessories.api.AccessoriesStorageLookup;
import io.wispforest.accessories.api.client.AccessoriesRenderStateKeys;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderState;
import io.wispforest.accessories.api.client.renderers.AccessoryNestRenderer;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import io.wispforest.accessories.api.client.renderers.DefaultAccessoryRenderer;
import io.wispforest.accessories.api.client.rendering.RenderingFunctionOps;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryCustomRendererComponent;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.compat.GeckoLibCompat;
import io.wispforest.accessories.mixin.client.HumanoidArmorLayerAccessor;
import io.wispforest.accessories.mixin.client.LivingEntityRendererAccessor;
import io.wispforest.accessories.pond.WingsLayerExtension;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.WingsLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.equipment.Equippable;
import org.jetbrains.annotations.ApiStatus;

public class BuiltinAccessoryRenderers {
    public static final AccessoryRenderer ARMOR_RENDERER = new AccessoryRenderer(){

        @Override
        public <S extends LivingEntityRenderState> void render(AccessoryRenderState accessoryState, S entityState, EntityModel<S> model, PoseStack matrices, SubmitNodeCollector collector) {
            if (!(entityState instanceof HumanoidRenderState)) {
                return;
            }
            HumanoidRenderState humanoidRenderState = (HumanoidRenderState)entityState;
            EntityRenderer entityRender = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(entityState);
            if (!(entityRender instanceof LivingEntityRendererAccessor)) {
                return;
            }
            LivingEntityRendererAccessor accessor = (LivingEntityRendererAccessor)entityRender;
            ItemStack stack = accessoryState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);
            if (!stack.has(DataComponents.EQUIPPABLE)) {
                return;
            }
            EquipmentSlot equipmentSlot = ((Equippable)stack.get(DataComponents.EQUIPPABLE)).slot();
            Optional<RenderLayer> possibleLayer = accessor.getLayers().stream().filter(renderLayer -> renderLayer instanceof HumanoidArmorLayer).findFirst();
            possibleLayer.ifPresent(layer -> BuiltinAccessoryRenderers.rendererArmor((HumanoidArmorLayer)layer, stack, matrices, collector, humanoidRenderState, equipmentSlot));
        }
    };
    public static final AccessoryRenderer ELYTRA_RENDERER = new AccessoryRenderer(){

        @Override
        public <S extends LivingEntityRenderState> void render(AccessoryRenderState accessoryState, S entityState, EntityModel<S> model, PoseStack matrices, SubmitNodeCollector collector) {
            if (!(entityState instanceof HumanoidRenderState)) {
                return;
            }
            HumanoidRenderState humanoidRenderState = (HumanoidRenderState)entityState;
            EntityRenderer entityRender = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(entityState);
            if (!(entityRender instanceof LivingEntityRendererAccessor)) {
                return;
            }
            LivingEntityRendererAccessor accessor = (LivingEntityRendererAccessor)entityRender;
            ItemStack stack = accessoryState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);
            if (!stack.has(DataComponents.GLIDER)) {
                return;
            }
            Optional<RenderLayer> possibleLayer = accessor.getLayers().stream().filter(renderLayer -> renderLayer instanceof WingsLayer).findFirst();
            Integer light = (Integer)entityState.getStateData(AccessoriesRenderStateKeys.LIGHT);
            possibleLayer.ifPresent(layer -> ((WingsLayerExtension)layer).renderStack(stack, matrices, collector, light, humanoidRenderState));
        }
    };
    public static final DataDrivenAccessoryRenderer DATA_DRIVEN = new DataDrivenAccessoryRenderer();
    public static final ResourceLocation BUNDLE_RENDERER_ID = Accessories.of("bundle_renderer");
    public static final ResourceLocation DEFAULT_RENDERER_ID = Accessories.of("default_renderer");
    public static final ResourceLocation ARMOR_RENDERER_ID = Accessories.of("armor_renderer");
    public static final ResourceLocation ELYTRA_RENDERER_ID = Accessories.of("elytra_renderer");

    private static <S extends HumanoidRenderState, M extends HumanoidModel<S>, A extends HumanoidModel<S>> void rendererArmor(HumanoidArmorLayer<S, M, A> armorLayer, ItemStack stack, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, S renderState, EquipmentSlot equipmentSlot) {
        HumanoidArmorLayerAccessor armorLayerAccessor = (HumanoidArmorLayerAccessor)armorLayer;
        Integer light = (Integer)renderState.getStateData(AccessoriesRenderStateKeys.LIGHT);
        Float partialTicks = (Float)renderState.getStateData(AccessoriesRenderStateKeys.PARTIAL_TICKS);
        if (!BuiltinAccessoryRenderers.attemptGeckoRender(stack, poseStack, submitNodeCollector, renderState, equipmentSlot, light, partialTicks.floatValue(), (HumanoidModel)armorLayer.getParentModel())) {
            armorLayerAccessor.accessories$renderArmorPiece(poseStack, submitNodeCollector, stack, equipmentSlot, light, renderState);
        }
    }

    private static <S extends HumanoidRenderState, M extends HumanoidModel<S>, A extends HumanoidModel<S>> boolean attemptGeckoRender(ItemStack stack, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, S renderState, EquipmentSlot equipmentSlot, int light, float partialTicks, M parentModel) {
        if (!AccessoriesLoaderInternals.INSTANCE.isModLoaded("geckolib")) {
            return false;
        }
        return GeckoLibCompat.renderGeckoArmor(poseStack, submitNodeCollector, renderState, stack, equipmentSlot, parentModel, partialTicks, light);
    }

    public static void onAddCallback(Item item) {
    }

    static {
        AccessoriesRendererRegistry.bindItemToRenderer(Items.BUNDLE, BUNDLE_RENDERER_ID, BundleAccessoryRenderer::new);
        AccessoriesRendererRegistry.registerRenderer(DEFAULT_RENDERER_ID, () -> DefaultAccessoryRenderer.INSTANCE);
        AccessoriesRendererRegistry.registerRenderer(ARMOR_RENDERER_ID, () -> ARMOR_RENDERER);
        AccessoriesRendererRegistry.registerRenderer(ELYTRA_RENDERER_ID, () -> ELYTRA_RENDERER);
    }

    @ApiStatus.Internal
    public static class DataDrivenAccessoryRenderer
    implements AccessoryRenderer {
        @Override
        public <S extends LivingEntityRenderState> void render(AccessoryRenderState accessoryState, S entityState, EntityModel<S> model, PoseStack matrices, SubmitNodeCollector collector) {
            ItemStack stack = accessoryState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);
            SlotPath path = accessoryState.getStateData(AccessoriesRenderStateKeys.SLOT_PATH);
            AccessoryCustomRendererComponent data = (AccessoryCustomRendererComponent)stack.get(AccessoriesDataComponents.CUSTOM_RENDERER);
            if (data == null || data.renderingFunctions() == null) {
                return;
            }
            Integer light = (Integer)entityState.getStateData(AccessoriesRenderStateKeys.LIGHT);
            Float partialTicks = (Float)entityState.getStateData(AccessoriesRenderStateKeys.PARTIAL_TICKS);
            RenderingFunctionOps.handleFunctions(stack, path, matrices, model, entityState, collector, light, partialTicks.floatValue(), (HumanoidArm)entityState.getStateData(AccessoriesRenderStateKeys.ARM), 0xF000F0, OverlayTexture.NO_OVERLAY, -1, data.renderingFunctions());
        }

        @Override
        public boolean shouldRender(ItemStack stack, SlotPath path, AccessoriesStorageLookup storageLookup, LivingEntity entity, LivingEntityRenderState entityState, boolean isRenderingEnabled) {
            AccessoryCustomRendererComponent data = (AccessoryCustomRendererComponent)stack.get(AccessoriesDataComponents.CUSTOM_RENDERER);
            if (data == null || data.renderingFunctions() == null) {
                return false;
            }
            return RenderingFunctionOps.shouldRender(stack, path, storageLookup, entity, entityState, data.renderingFunctions()) && isRenderingEnabled;
        }
    }

    public static final class EmptyRenderer
    implements AccessoryRenderer {
        @Override
        public <S extends LivingEntityRenderState> void render(AccessoryRenderState accessoryState, S entityState, EntityModel<S> model, PoseStack matrices, SubmitNodeCollector collector) {
        }
    }

    @ApiStatus.Internal
    public static class BundleAccessoryRenderer
    implements AccessoryNestRenderer {
        @Override
        public List<ItemStack> getInnerStacks(ItemStack holderStack) {
            List stacks;
            BundleContents contents = (BundleContents)holderStack.get(DataComponents.BUNDLE_CONTENTS);
            Iterable items = contents.items();
            return items instanceof List ? (stacks = (List)items) : Streams.stream((Iterable)items).toList();
        }
    }
}

