/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.rendering;

import com.google.common.base.CaseFormat;
import com.google.common.base.Supplier;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.rendering.RenderingPredicate;
import io.wispforest.accessories.api.client.rendering.Transformation;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.format.edm.EdmElement;
import io.wispforest.endec.format.edm.EdmSerializer;
import io.wispforest.endec.format.gson.GsonEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.serialization.format.nbt.NbtEndec;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@ApiStatus.Experimental
public sealed interface RenderingFunction {
    public static final Endec<RenderingFunction> ENDEC = Endec.dispatchedStruct(key -> switch (key) {
        case "transformation" -> Transformations.ENDEC;
        case "model" -> Model.ENDEC;
        case "block" -> Block.ENDEC;
        case "item" -> Item.ENDEC;
        case "entity" -> Entity.ENDEC;
        case "particle" -> Particle.ENDEC;
        case "compound" -> Compound.ENDEC;
        case "renderer" -> DeferredRenderer.ENDEC;
        case "conditional" -> Conditional.ENDEC;
        case "data" -> RawRenderer.ENDEC;
        default -> throw new IllegalStateException("A invalid rendering function was created meaning such is unable to be decoded!");
    }, RenderingFunction::key, (Endec)Endec.STRING, (String)"type");

    public static Transformations ofTransformation(List<Transformation> transformations, List<RenderingFunction> renderingFunctions, ArmTarget armTarget) {
        return new Transformations(transformations, new Compound(renderingFunctions, armTarget));
    }

    public static Model ofModel(ResourceLocation id) {
        return new Model(id);
    }

    public static Block ofBlock(net.minecraft.world.level.block.Block block) {
        return RenderingFunction.ofBlock(block.defaultBlockState());
    }

    public static Block ofBlock(BlockState state) {
        return new Block(state, null, new CompoundTag());
    }

    public static Block ofBlockEntity(net.minecraft.world.level.block.Block block, BlockEntityType<? extends BlockEntity> type, Level level) {
        return RenderingFunction.ofBlockEntity(block.defaultBlockState(), type, level);
    }

    public static Block ofBlockEntity(BlockState blockState, BlockEntityType<? extends BlockEntity> type, Level level) {
        BlockEntity blockEntity = type.create(BlockPos.ZERO, blockState);
        if (blockEntity == null) {
            throw new IllegalStateException("Unable to create render function of the given block entity");
        }
        return RenderingFunction.ofBlockEntity(blockState, type, blockEntity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess()));
    }

    public static Block ofBlockEntity(BlockState blockState, BlockEntityType<? extends BlockEntity> type, CompoundTag data) {
        return new Block(blockState, type, data);
    }

    public static Item ofItem(ItemStack stack) {
        return new Item(stack);
    }

    public static Entity ofEntity(EntityType<? extends net.minecraft.world.entity.Entity> entityType, Level level) {
        net.minecraft.world.entity.Entity entity = entityType.create(level, EntitySpawnReason.EVENT);
        if (entity == null) {
            throw new IllegalStateException("Unable to create render function of the given entity");
        }
        return Accessories.handleIoError("rendering_function_entity_data", scopedCollector -> {
            TagValueOutput valueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)level.registryAccess());
            String string = entity.getEncodeId();
            if (string == null) {
                throw new IllegalStateException("Unable to create render function of the given entity");
            }
            valueOutput.putString("id", string);
            entity.saveWithoutId((ValueOutput)valueOutput);
            CompoundTag compound = valueOutput.buildResult();
            return new Entity(entityType, compound, true);
        });
    }

    public static Entity ofEntity(EntityType<? extends net.minecraft.world.entity.Entity> entityType, CompoundTag data) {
        return new Entity(entityType, data, true);
    }

    public static Particle ofParticle(ResourceLocation uniqueId, float delay, ParticleOptions particleData, Vector3f delta, float speed, int count, boolean overrideLimiter, boolean alwaysShow) {
        return new Particle(uniqueId, delay, particleData, delta, speed, count, overrideLimiter, alwaysShow);
    }

    default public String key() {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.getClass().getSimpleName());
    }

    public record Transformations(List<Transformation> transformations, Compound renderingFunction) implements RenderingFunction
    {
        public static final StructEndec<Transformations> ENDEC = StructEndecBuilder.of((StructField)Transformation.ENDEC.listOf().fieldOf("transformations", Transformations::transformations), (StructField)Compound.ENDEC.flatFieldOf(Transformations::renderingFunction), Transformations::new);
    }

    public record Compound(List<RenderingFunction> renderingFunctions, ArmTarget firstPersonArmTarget) implements RenderingFunction,
    ArmedTargeted
    {
        private static final StructEndec<Compound> OLD_FORMAT_ENDEC = StructEndecBuilder.of((StructField)ENDEC.fieldOf("rendering_function", s -> s.renderingFunctions().getFirst()), (StructField)Endec.forEnum(ArmTarget.class).optionalFieldOf("first_person_arm_target", Compound::firstPersonArmTarget, () -> ArmTarget.NONE), (function, armTarget) -> new Compound(List.of(function), (ArmTarget)((Object)armTarget)));
        public static final StructEndec<Compound> ENDEC = StructEndecBuilder.of((StructField)ENDEC.listOf().fieldOf("rendering_functions", Compound::renderingFunctions), (StructField)Endec.forEnum(ArmTarget.class).optionalFieldOf("first_person_arm_target", Compound::firstPersonArmTarget, () -> ArmTarget.NONE), Compound::new).structuredCatchErrors((ctx, serializer, struct, mainException) -> {
            try {
                return (Compound)OLD_FORMAT_ENDEC.decodeStruct(ctx, serializer, struct);
            }
            catch (Exception exception) {
                throw new RuntimeException(mainException);
            }
        });
    }

    public static enum ArmTarget {
        LEFT(HumanoidArm.LEFT),
        RIGHT(HumanoidArm.RIGHT),
        BOTH(HumanoidArm.LEFT, HumanoidArm.RIGHT),
        NONE(new HumanoidArm[0]);

        private final Set<HumanoidArm> arms;

        private ArmTarget(HumanoidArm ... arms) {
            EnumSet<HumanoidArm> result = EnumSet.noneOf(HumanoidArm.class);
            result.addAll(Set.of(arms));
            this.arms = result;
        }

        public final boolean hasArm(HumanoidArm arm) {
            return this.arms.contains(arm);
        }
    }

    public record Model(ResourceLocation id) implements RenderingFunction
    {
        public static final StructEndec<Model> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.IDENTIFIER.fieldOf("id", Model::id), Model::new);
    }

    public record Block(BlockState state, @Nullable BlockEntityType<?> type, CompoundTag data) implements RenderingFunction
    {
        public static final StructEndec<Block> ENDEC = StructEndecBuilder.of((StructField)EndecUtils.blockStateEndec("id").flatFieldOf(Block::state), (StructField)CodecUtils.toEndec((Codec)BuiltInRegistries.BLOCK_ENTITY_TYPE.byNameCodec()).optionalFieldOf("entity_id", Block::type, (Object)null), (StructField)NbtEndec.COMPOUND.optionalFieldOf("data", Block::data, CompoundTag::new), Block::new);
    }

    public record Item(ItemStack stack) implements RenderingFunction
    {
        public static final StructEndec<Item> ENDEC = StructEndecBuilder.of((StructField)new EndecUtils.LazyStructEndec(() -> {
            Codec baseCodec = ItemStack.CODEC;
            try {
                Field field = baseCodec.getClass().getDeclaredField("wrapped");
                field.setAccessible(true);
                Supplier supplier = (Supplier)field.get(baseCodec);
                return CodecUtils.toStructEndec((MapCodec)((MapCodec.MapCodecCodec)supplier.get()).codec());
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }).flatFieldOf(Item::stack), Item::new);
    }

    public record Entity(EntityType<?> entityType, CompoundTag data, boolean allowTicking) implements RenderingFunction
    {
        public static final StructEndec<Entity> ENDEC = StructEndecBuilder.of((StructField)CodecUtils.toEndec((Codec)BuiltInRegistries.ENTITY_TYPE.byNameCodec()).fieldOf("entity_id", Entity::entityType), (StructField)NbtEndec.COMPOUND.optionalFieldOf("stack", Entity::data, CompoundTag::new), (StructField)Endec.BOOLEAN.optionalFieldOf("allow_ticking", Entity::allowTicking, (Object)false), Entity::new);
    }

    public record Particle(ResourceLocation uniqueId, float delay, ParticleOptions particleData, Vector3f delta, float speed, int count, boolean overrideLimiter, boolean alwaysShow) implements RenderingFunction
    {
        private static final Endec<ParticleOptions> PARTICLE_OPTIONS_ENDEC = CodecUtils.toEndec((Codec)ParticleTypes.CODEC);
        public static final StructEndec<Particle> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.IDENTIFIER.optionalFieldOf("unique_id", Particle::uniqueId, () -> Accessories.of("shared")), (StructField)Endec.FLOAT.optionalFieldOf("delay", Particle::delay, () -> Float.valueOf(20.0f)), (StructField)PARTICLE_OPTIONS_ENDEC.fieldOf("particle_data", Particle::particleData), (StructField)EndecUtils.VECTOR_3_F_ENDEC.flatFieldOf(Particle::delta), (StructField)Endec.FLOAT.optionalFieldOf("speed", Particle::speed, (Object)Float.valueOf(1.0f)), (StructField)Endec.INT.optionalFieldOf("count", Particle::count, (Object)1), (StructField)Endec.BOOLEAN.optionalFieldOf("override_limiter", Particle::overrideLimiter, (Object)false), (StructField)Endec.BOOLEAN.optionalFieldOf("always_show", Particle::alwaysShow, (Object)false), Particle::new);

        @Override
        public boolean equals(Object obj) {
            EdmElement thatRawParticleData;
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Particle that = (Particle)obj;
            EdmElement rawParticleData = (EdmElement)PARTICLE_OPTIONS_ENDEC.encodeFully(EdmSerializer::of, (Object)this.particleData);
            return Objects.equals(rawParticleData, thatRawParticleData = (EdmElement)PARTICLE_OPTIONS_ENDEC.encodeFully(EdmSerializer::of, (Object)that.particleData)) && Objects.equals(this.delta, that.delta) && Float.floatToIntBits(this.speed) == Float.floatToIntBits(that.speed) && this.count == that.count && this.overrideLimiter == that.overrideLimiter && this.alwaysShow == that.alwaysShow;
        }

        @Override
        public int hashCode() {
            return Objects.hash(PARTICLE_OPTIONS_ENDEC.encodeFully(EdmSerializer::of, (Object)this.particleData), this.delta, Float.valueOf(this.speed), this.count, this.overrideLimiter, this.alwaysShow);
        }

        @Override
        public String toString() {
            return "Particle[particleData=" + String.valueOf(this.particleData) + ", delta=" + String.valueOf(this.delta) + ", speed=" + this.speed + ", count=" + this.count + ", overrideLimiter=" + this.overrideLimiter + "alwaysShow=" + this.alwaysShow + "]";
        }
    }

    @ApiStatus.Experimental
    public static final class DeferredRenderer
    implements RenderingFunction,
    ArmedTargeted {
        public static final StructEndec<DeferredRenderer> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.IDENTIFIER.optionalFieldOf("renderer_id", DeferredRenderer::rendererId, () -> AccessoriesRendererRegistry.NO_RENDERER_ID), (StructField)GsonEndec.INSTANCE.mapOf().optionalFieldOf("references", DeferredRenderer::references, HashMap::new), (StructField)Endec.forEnum(ArmTarget.class).optionalFieldOf("first_person_arm_target", DeferredRenderer::firstPersonArmTarget, () -> ArmTarget.BOTH), DeferredRenderer::new);
        private final ResourceLocation rendererId;
        private final Map<String, JsonElement> references;
        private final ArmTarget firstPersonArmTarget;
        private final UUID uuid;

        public DeferredRenderer(ResourceLocation rendererId, Map<String, JsonElement> references, ArmTarget firstPersonArmTarget) {
            this.rendererId = rendererId;
            this.references = references;
            this.firstPersonArmTarget = firstPersonArmTarget;
            this.uuid = UUID.nameUUIDFromBytes(this.toString().getBytes(StandardCharsets.UTF_8));
        }

        public Map<String, JsonElement> references() {
            return Collections.unmodifiableMap(this.references);
        }

        public ResourceLocation rendererId() {
            return this.rendererId;
        }

        @Override
        public ArmTarget firstPersonArmTarget() {
            return this.firstPersonArmTarget;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public String key() {
            return "renderer";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            DeferredRenderer that = (DeferredRenderer)obj;
            return Objects.equals(this.rendererId, that.rendererId) && Objects.equals(this.references, that.references) && Objects.equals((Object)this.firstPersonArmTarget, (Object)that.firstPersonArmTarget);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.rendererId, this.references, this.firstPersonArmTarget});
        }

        public String toString() {
            return "DeferredRenderer[rendererId=" + String.valueOf(this.rendererId) + ", references=" + String.valueOf(this.references) + ", firstPersonArmTarget=" + String.valueOf((Object)this.firstPersonArmTarget) + "]";
        }
    }

    public record Conditional(List<RenderingPredicate> predicates, Compound renderingFunction) implements RenderingFunction
    {
        public static final StructEndec<Conditional> ENDEC = StructEndecBuilder.of((StructField)RenderingPredicate.ENDEC.listOf().fieldOf("predicates", Conditional::predicates), (StructField)Compound.ENDEC.flatFieldOf(Conditional::renderingFunction), Conditional::new);
    }

    public static final class RawRenderer
    implements RenderingFunction,
    ArmedTargeted {
        public static final StructEndec<RawRenderer> ENDEC = StructEndecBuilder.of((StructField)GsonEndec.INSTANCE.mapOf().optionalFieldOf("references", RawRenderer::references, HashMap::new), (StructField)GsonEndec.INSTANCE.listOf().fieldOf("rendering_functions", RawRenderer::renderingFunctions), (StructField)Endec.forEnum(ArmTarget.class).optionalFieldOf("first_person_arm_target", RawRenderer::firstPersonArmTarget, () -> ArmTarget.NONE), RawRenderer::new);
        private final Map<String, JsonElement> references;
        private final List<JsonElement> renderingFunctions;
        private final ArmTarget firstPersonArmTarget;
        private final UUID uuid;

        public RawRenderer(Map<String, JsonElement> references, List<JsonElement> renderingFunctions, ArmTarget firstPersonArmTarget) {
            this.references = references;
            this.renderingFunctions = renderingFunctions;
            this.firstPersonArmTarget = firstPersonArmTarget;
            this.uuid = UUID.nameUUIDFromBytes(this.toString().getBytes(StandardCharsets.UTF_8));
        }

        public Map<String, JsonElement> references() {
            return Collections.unmodifiableMap(this.references);
        }

        public List<JsonElement> renderingFunctions() {
            return Collections.unmodifiableList(this.renderingFunctions);
        }

        @Override
        public ArmTarget firstPersonArmTarget() {
            return this.firstPersonArmTarget;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public String key() {
            return "data";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            RawRenderer that = (RawRenderer)obj;
            return Objects.equals(this.references, that.references) && Objects.equals(this.renderingFunctions, that.renderingFunctions) && Objects.equals((Object)this.firstPersonArmTarget, (Object)that.firstPersonArmTarget);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.references, this.renderingFunctions, this.firstPersonArmTarget});
        }

        public String toString() {
            return "RawRenderer[references=" + String.valueOf(this.references) + ", renderingFunctions=" + String.valueOf(this.renderingFunctions) + ", firstPersonArmTarget=" + String.valueOf((Object)this.firstPersonArmTarget) + "]";
        }
    }

    public static interface ArmedTargeted {
        public ArmTarget firstPersonArmTarget();
    }
}

