/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesStorageLookup;
import io.wispforest.accessories.api.client.AccessoriesRenderStateKeys;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import io.wispforest.accessories.api.client.rendering.RenderingFunction;
import io.wispforest.accessories.api.client.rendering.TransformOps;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.client.ClientDelayedCache;
import io.wispforest.accessories.data.CustomRendererLoader;
import java.lang.ref.SoftReference;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;

@ApiStatus.Experimental
public class RenderingFunctionOps {
    private static final ClientDelayedCache<ParticleTimeKey> PARTICLE_UPDATE_CACHE = new ClientDelayedCache();
    private static final Map<EntityType, EntityData> ENTITY_CACHE = new HashMap<EntityType, EntityData>();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void handleFunctions(ItemStack stack, SlotPath path, PoseStack matrices, EntityModel<? extends LivingEntityRenderState> model, LivingEntityRenderState renderState, SubmitNodeCollector collector, int light, float partialTicks, @Nullable HumanoidArm arm, int packedLight, int packedOverlay, int color, List<RenderingFunction> functions) {
        RenderingFunctionOps.handleFunctions(ItemStack.hashItemAndComponents((ItemStack)stack), stack, path, matrices, model, renderState, collector, light, partialTicks, arm, packedLight, packedOverlay, color, functions);
    }

    public static void handleFunctions(int uniqueKey, ItemStack stack, SlotPath path, PoseStack matrices, EntityModel<? extends LivingEntityRenderState> model, LivingEntityRenderState renderState, SubmitNodeCollector collector, int light, float partialTicks, @Nullable HumanoidArm arm, int packedLight, int packedOverlay, int color, List<RenderingFunction> functions) {
        for (RenderingFunction function : functions) {
            RenderingFunctionOps.handleFunction(uniqueKey, stack, path, matrices, model, renderState, collector, light, partialTicks, arm, packedLight, packedOverlay, color, function);
        }
    }

    public static void handleFunction(int uniqueKey, ItemStack stack, SlotPath path, PoseStack matrices, EntityModel<? extends LivingEntityRenderState> model, LivingEntityRenderState renderState, SubmitNodeCollector collector, int light, float partialTicks, @Nullable HumanoidArm arm, int packedLight, int packedOverlay, int color, RenderingFunction renderingFunction) {
        Minecraft client = Minecraft.getInstance();
        ClientLevel level = client.level;
        CameraRenderState cameraState = (CameraRenderState)renderState.getStateData(AccessoriesRenderStateKeys.CAMERA_STATE);
        RenderingFunction renderingFunction2 = renderingFunction;
        Objects.requireNonNull(renderingFunction2);
        RenderingFunction renderingFunction3 = renderingFunction2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RenderingFunction.Transformations.class, RenderingFunction.Block.class, RenderingFunction.Entity.class, RenderingFunction.Item.class, RenderingFunction.Model.class, RenderingFunction.Particle.class, RenderingFunction.Compound.class, RenderingFunction.RawRenderer.class, RenderingFunction.DeferredRenderer.class}, (Object)renderingFunction3, n)) {
            case 0: {
                RenderingFunction.Transformations transformation = (RenderingFunction.Transformations)renderingFunction3;
                TransformOps.transformStack(transformation.transformations(), matrices, model, () -> RenderingFunctionOps.handleFunction(uniqueKey, stack, path, matrices, model, renderState, collector, light, partialTicks, arm, packedLight, packedOverlay, color, transformation.renderingFunction()));
                break;
            }
            case 1: {
                RenderingFunction.Block blockData = (RenderingFunction.Block)renderingFunction3;
                BlockState state = blockData.state();
                BlockEntity blockEntity = blockData.type() != null ? BlockEntity.loadStatic((BlockPos)BlockPos.ZERO, (BlockState)blockData.state(), (CompoundTag)blockData.data(), (HolderLookup.Provider)level.registryAccess()) : null;
                matrices.pushPose();
                matrices.translate(-0.5, 0.0, -0.5);
                RenderingFunctionOps.renderBlock(client, state, blockEntity, cameraState, 0.0f, matrices, collector, packedLight, packedOverlay, color);
                matrices.popPose();
                break;
            }
            case 2: {
                RenderingFunction.Entity entityData = (RenderingFunction.Entity)renderingFunction3;
                try {
                    EntityData currentEntityData = ENTITY_CACHE.computeIfAbsent(entityData.entityType(), entityType -> {
                        Entity entity = entityData.entityType().create((Level)level, EntitySpawnReason.EVENT);
                        if (entity != null) {
                            CompoundTag defaultData = Accessories.handleIoError("rendering_function_default_entity_data", scopedCollector -> {
                                TagValueOutput valueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)level.registryAccess());
                                entity.saveWithoutId((ValueOutput)valueOutput);
                                return valueOutput.buildResult();
                            });
                            return new EntityData(new SoftReference<Entity>(entity), defaultData, true);
                        }
                        return new EntityData(null, new CompoundTag(), false);
                    });
                    if (!currentEntityData.wasSpawnable()) {
                        return;
                    }
                    if (!currentEntityData.canBeGotten()) {
                        currentEntityData.createNewReference(entityData.entityType(), (Level)level);
                    }
                    if (!currentEntityData.wasSpawnable()) {
                        return;
                    }
                    Entity entity = currentEntityData.reference().get();
                    if (entity == null) {
                        return;
                    }
                    boolean customData = false;
                    if (!entityData.data().isEmpty()) {
                        customData = true;
                        Accessories.handleIoError("rendering_function_entity_data", scopedCollector -> entity.load(TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)entityData.data())));
                    }
                    if (entityData.allowTicking() || entity instanceof Display) {
                        entity.tick();
                    }
                    EntityRenderDispatcher dispatcher = client.getEntityRenderDispatcher();
                    EntityRenderState state = dispatcher.extractEntity(entity, partialTicks);
                    dispatcher.submit(state, cameraState, 0.0, 0.0, 0.0, matrices, collector);
                    if (!customData) break;
                    currentEntityData.resetEntity((Level)level);
                }
                catch (Exception currentEntityData) {}
                break;
            }
            case 3: {
                RenderingFunction.Item itemData = (RenderingFunction.Item)renderingFunction3;
                ItemStack renderStack = itemData.stack();
                ItemStackRenderState state = new ItemStackRenderState();
                client.getItemModelResolver().updateForTopItem(state, renderStack, ItemDisplayContext.GUI, null, null, Objects.hash(itemData, uniqueKey));
                state.submit(matrices, collector, packedLight, packedOverlay, 0);
                break;
            }
            case 4: {
                RenderingFunction.Model modelData = (RenderingFunction.Model)renderingFunction3;
                ItemStack modelStack = Items.BEDROCK.getDefaultInstance();
                modelStack.set(DataComponents.ITEM_MODEL, (Object)modelData.id());
                ItemStackRenderState state = new ItemStackRenderState();
                client.getItemModelResolver().updateForTopItem(state, modelStack, ItemDisplayContext.GUI, null, null, Objects.hash(modelData, uniqueKey));
                break;
            }
            case 5: {
                RenderingFunction.Particle particleData = (RenderingFunction.Particle)renderingFunction3;
                if (!PARTICLE_UPDATE_CACHE.hasAllottedTime(new ParticleTimeKey(renderState.getEntityUUIDForState(), uniqueKey, particleData), particleData.delay())) {
                    return;
                }
                Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f).mulPosition((Matrix4fc)matrices.last().pose()).add((Vector3fc)Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f());
                RenderingFunctionOps.renderParticle((Level)level, particleData, pos.x(), pos.y(), pos.z());
                break;
            }
            case 6: {
                RenderingFunction.Compound compoundFunction = (RenderingFunction.Compound)renderingFunction3;
                if (arm != null && !compoundFunction.firstPersonArmTarget().hasArm(arm)) {
                    return;
                }
                RenderingFunctionOps.handleFunctions(uniqueKey, stack, path, matrices, model, renderState, collector, light, partialTicks, arm, packedLight, packedOverlay, color, compoundFunction.renderingFunctions());
                break;
            }
            case 7: {
                RenderingFunction.RawRenderer data = (RenderingFunction.RawRenderer)renderingFunction3;
                RenderingFunction renderFunction = CustomRendererLoader.getOrResolveRawRenderer(data, !CustomRendererLoader.isConstantResolveTarget());
                if (renderFunction == null) {
                    return;
                }
                RenderingFunctionOps.handleFunction(uniqueKey, stack, path, matrices, model, renderState, collector, light, partialTicks, arm, packedLight, packedOverlay, color, renderFunction);
                break;
            }
            case 8: {
                RenderingFunction.DeferredRenderer renderer = (RenderingFunction.DeferredRenderer)renderingFunction3;
                Either<AccessoryRenderer, RenderingFunction> renderFunction = CustomRendererLoader.getOrResolveRenderer(renderer, !CustomRendererLoader.isConstantResolveTarget());
                if (renderFunction == null) {
                    return;
                }
                AccessoriesStorageLookup lookup = (AccessoriesStorageLookup)renderState.getStateData(AccessoriesRenderStateKeys.STORAGE_LOOKUP);
                renderFunction.ifLeft(accessoryRenderer -> {}).ifRight(function1 -> RenderingFunctionOps.handleFunction(uniqueKey, stack, path, matrices, model, renderState, collector, light, partialTicks, arm, packedLight, packedOverlay, color, function1));
                break;
            }
            default: {
                throw new IllegalStateException("Unimplemented RendererFunc: " + renderingFunction.key());
            }
        }
    }

    private static void renderParticle(Level level, RenderingFunction.Particle particle, double x, double y, double z) {
        RandomSource random = level.getRandom();
        try {
            if (particle.count() == 0) {
                double xSpd = particle.speed() * particle.delta().x();
                double ySpd = particle.speed() * particle.delta().y();
                double zSpd = particle.speed() * particle.delta().z();
                level.addParticle(particle.particleData(), particle.overrideLimiter(), particle.alwaysShow(), x, y, z, xSpd, ySpd, zSpd);
            } else {
                for (int i = 0; i < particle.count(); ++i) {
                    double g = random.nextGaussian() * (double)particle.delta().x();
                    double h = random.nextGaussian() * (double)particle.delta().y();
                    double j = random.nextGaussian() * (double)particle.delta().z();
                    double k = random.nextGaussian() * (double)particle.speed();
                    double l = random.nextGaussian() * (double)particle.speed();
                    double m = random.nextGaussian() * (double)particle.speed();
                    level.addParticle(particle.particleData(), particle.overrideLimiter(), particle.alwaysShow(), x + g, y + h, z + j, k, l, m);
                }
            }
        }
        catch (Throwable var16) {
            LOGGER.warn("Could not spawn particle effect {}", (Object)particle.particleData());
        }
    }

    private static void renderBlock(Minecraft client, BlockState state, @Nullable BlockEntity blockEntity, CameraRenderState cameraState, float partialTick, PoseStack matrices, SubmitNodeCollector collector, int packedLight, int packedOverlay, int color) {
        BlockEntityRenderDispatcher dispatcher;
        BlockEntityRenderState \u043c\u0435\u0434\u0432\u0435\u0434\u044c;
        if (state.getRenderShape() != RenderShape.INVISIBLE) {
            collector.submitBlock(matrices, state, packedLight, packedOverlay, 0);
        }
        if (blockEntity != null && (\u043c\u0435\u0434\u0432\u0435\u0434\u044c = (dispatcher = client.getBlockEntityRenderDispatcher()).tryExtractRenderState(blockEntity, partialTick, null)) != null) {
            dispatcher.submit(\u043c\u0435\u0434\u0432\u0435\u0434\u044c, matrices, collector, cameraState);
        }
    }

    public static boolean shouldRender(ItemStack stack, SlotPath path, AccessoriesStorageLookup storageLookup, LivingEntity entity, LivingEntityRenderState entityState, List<RenderingFunction> renderingFunctions) {
        for (RenderingFunction function : renderingFunctions) {
            Boolean result = RenderingFunctionOps.shouldRender(stack, path, storageLookup, entity, entityState, function);
            if (result == null || !result.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Boolean shouldRender(ItemStack stack, SlotPath path, AccessoriesStorageLookup storageLookup, LivingEntity entity, LivingEntityRenderState entityState, RenderingFunction renderingFunction) {
        if (renderingFunction instanceof RenderingFunction.ArmedTargeted) {
            RenderingFunction.ArmedTargeted armedTargeted = (RenderingFunction.ArmedTargeted)((Object)renderingFunction);
            if (entityState.hasStateData(AccessoriesRenderStateKeys.ARM) && armedTargeted.firstPersonArmTarget().hasArm((HumanoidArm)entityState.getStateData(AccessoriesRenderStateKeys.ARM))) {
                return true;
            }
        }
        RenderingFunction renderingFunction2 = renderingFunction;
        Objects.requireNonNull(renderingFunction2);
        RenderingFunction renderingFunction3 = renderingFunction2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RenderingFunction.Transformations.class, RenderingFunction.Compound.class, RenderingFunction.RawRenderer.class, RenderingFunction.DeferredRenderer.class}, (Object)renderingFunction3, n)) {
            case 0 -> {
                RenderingFunction.Transformations transformation = (RenderingFunction.Transformations)renderingFunction3;
                yield RenderingFunctionOps.shouldRender(stack, path, storageLookup, entity, entityState, transformation.renderingFunction());
            }
            case 1 -> {
                RenderingFunction.Compound compoundFunction = (RenderingFunction.Compound)renderingFunction3;
                yield RenderingFunctionOps.shouldRender(stack, path, storageLookup, entity, entityState, compoundFunction.renderingFunctions());
            }
            case 2 -> {
                RenderingFunction.RawRenderer data = (RenderingFunction.RawRenderer)renderingFunction3;
                RenderingFunction renderFunction = CustomRendererLoader.getOrResolveRawRenderer(data, !CustomRendererLoader.isConstantResolveTarget());
                if (renderFunction == null) {
                    yield null;
                }
                yield RenderingFunctionOps.shouldRender(stack, path, storageLookup, entity, entityState, renderFunction);
            }
            case 3 -> {
                RenderingFunction.DeferredRenderer renderer = (RenderingFunction.DeferredRenderer)renderingFunction3;
                Either<AccessoryRenderer, RenderingFunction> possibleRenderer = CustomRendererLoader.getOrResolveRenderer(renderer, !CustomRendererLoader.isConstantResolveTarget());
                if (possibleRenderer == null) {
                    yield null;
                }
                yield (Boolean)Either.unwrap((Either)possibleRenderer.mapBoth(accessoryRenderer -> accessoryRenderer.shouldRender(stack, path, storageLookup, entity, entityState, true), renderFunction -> RenderingFunctionOps.shouldRender(stack, path, storageLookup, entity, entityState, renderFunction)));
            }
            default -> null;
        };
    }

    private static final class EntityData {
        private final CompoundTag defaultData;
        @Nullable
        private SoftReference<Entity> reference;
        private boolean wasSpawnable;

        private EntityData(@Nullable SoftReference<Entity> reference, CompoundTag defaultData, boolean wasSpawnable) {
            this.reference = reference;
            this.defaultData = defaultData;
            this.wasSpawnable = wasSpawnable;
        }

        private boolean canBeGotten() {
            return this.reference != null && this.reference.get() != null;
        }

        @Nullable
        public SoftReference<Entity> reference() {
            return this.reference;
        }

        public void resetEntity(Level level) {
            if (this.reference == null) {
                return;
            }
            Entity entity = this.reference.get();
            if (entity == null) {
                return;
            }
            try {
                Accessories.handleIoError("rendering_function_entity_data", scopedCollector -> entity.load(TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)this.defaultData)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void createNewReference(EntityType type, Level level) {
            Entity entity = type.create(level, EntitySpawnReason.EVENT);
            if (entity == null) {
                this.wasSpawnable = false;
                return;
            }
            this.reference = new SoftReference<Entity>(entity);
        }

        public CompoundTag defaultData() {
            return this.defaultData;
        }

        public boolean wasSpawnable() {
            return this.wasSpawnable;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            EntityData that = (EntityData)obj;
            return Objects.equals(this.reference, that.reference) && Objects.equals(this.defaultData, that.defaultData) && this.wasSpawnable == that.wasSpawnable;
        }

        public int hashCode() {
            return Objects.hash(this.reference, this.defaultData, this.wasSpawnable);
        }

        public String toString() {
            return "EntityData[reference=" + String.valueOf(this.reference) + ", defaultData=" + String.valueOf(this.defaultData) + ", wasSpawnable=" + this.wasSpawnable + "]";
        }
    }

    private record ParticleTimeKey(UUID entityUUID, int uniqueKey) {
        private ParticleTimeKey(UUID entityUUID, int uniqueKey, RenderingFunction.Particle particleData) {
            this(entityUUID, Objects.hash(uniqueKey, particleData));
        }
    }
}

