/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.rendering;

import com.google.common.base.CaseFormat;
import io.wispforest.accessories.api.client.rendering.ModelTransformOps;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import net.minecraft.client.model.Model;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public sealed interface RenderingPredicate {
    public static final Endec<RenderingPredicate> ENDEC = Endec.dispatchedStruct(key -> {
        switch (key) {
            case "model_target": {
                break;
            }
            default: {
                throw new IllegalStateException("A invalid rendering function was created meaning such is unable to be decoded!");
            }
        }
        return ModelTarget.ENDEC;
    }, RenderingPredicate::key, (Endec)Endec.STRING, (String)"type");

    public boolean shouldRender(LivingEntity var1, Model var2);

    default public String key() {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.getClass().getSimpleName());
    }

    public record ModelTarget(String modelPartName) implements RenderingPredicate
    {
        public static final StructEndec<ModelTarget> ENDEC = StructEndecBuilder.of((StructField)Endec.STRING.fieldOf("model_part", ModelTarget::modelPartName), ModelTarget::new);

        @Override
        public boolean shouldRender(LivingEntity entity, Model model) {
            return ModelTransformOps.getPart(model, this.modelPartName()) != null;
        }
    }
}

