/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.screen;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.screen.PlayerBasedTargetGetter;
import io.wispforest.accessories.api.client.screen.ScreenBasedTargetGetter;
import io.wispforest.accessories.api.client.screen.ScreenOpener;
import io.wispforest.accessories.api.client.screen.ScreenReopener;
import io.wispforest.accessories.compat.config.MenuButtonInjection;
import io.wispforest.accessories.mixin.HorseInventoryMenuAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.server.ContainerClose;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.HorseInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class AccessoriesScreenTransitionHelper {
    private static boolean INITIALIZED_INJECTIONS = false;
    public static final Event<MenuButtonInjectionCallback> EVENT = EventFactory.createArrayBacked(MenuButtonInjectionCallback.class, invokers -> registerFunc -> {
        for (MenuButtonInjectionCallback invoker : invokers) {
            invoker.registerInjections(registerFunc);
        }
    });
    private static final List<Class<AbstractContainerScreen<AbstractContainerMenu>>> SCREEN_CLASSES = new ArrayList<Class<AbstractContainerScreen<AbstractContainerMenu>>>();
    private static final Map<ResourceLocation, MenuButtonInjection> BUTTON_INJECTION_DATA = new HashMap<ResourceLocation, MenuButtonInjection>();
    private static final Map<Predicate<AbstractContainerScreen<AbstractContainerMenu>>, ScreenTransitionHelper> SCREEN_PREDICATES = new LinkedHashMap<Predicate<AbstractContainerScreen<AbstractContainerMenu>>, ScreenTransitionHelper>();
    private static final List<PlayerBasedTargetGetter> SCREENLESS_TARGET_GETTERS = new ArrayList<PlayerBasedTargetGetter>();
    private static final List<ScreenOpener> SCREEN_OPENERS = new ArrayList<ScreenOpener>();
    @Nullable
    private static Screen prevScreen = null;
    @Nullable
    private static MenuButtonInjection prevInjection = null;
    @Nullable
    private static ScreenTransitionHelper prevScreenInfo = null;

    public static void registerTargetGetter(PlayerBasedTargetGetter getter) {
        SCREENLESS_TARGET_GETTERS.add(getter);
    }

    public static void registerScreenOpener(ScreenOpener screenOpener) {
        SCREEN_OPENERS.add(screenOpener);
    }

    @SafeVarargs
    public static void registerScreensForButton(Class<? extends AbstractContainerScreen<?>> ... screenClasses) {
        SCREEN_CLASSES.addAll(List.of(screenClasses));
    }

    public static <M extends AbstractContainerMenu, S extends AbstractContainerScreen<M>> void registerPlayerScreenTransition(ResourceLocation location, Class<S> screenClass) {
        AccessoriesScreenTransitionHelper.registerPlayerScreenTransition(location, screenClass::isInstance);
        AccessoriesScreenTransitionHelper.registerScreensForButton(screenClass);
    }

    public static void registerPlayerScreenTransition(ResourceLocation location, Predicate<AbstractContainerScreen<AbstractContainerMenu>> screenPredicate) {
        AccessoriesScreenTransitionHelper.registerScreenTransition(location, screenPredicate, ScreenBasedTargetGetter.PLAYER_DEFAULTED_TARGET, ScreenReopener.PLAYER_INVENTORY);
    }

    public static <M extends AbstractContainerMenu, S extends AbstractContainerScreen<M>> void registerScreenTransitionWithCustomInvReopener(ResourceLocation location, Class<S> screenClass, ScreenBasedTargetGetter<M, S> getter) {
        AccessoriesScreenTransitionHelper.registerScreenTransition(location, screenClass, getter, ScreenReopener.CUSTOM_INVENTORY);
    }

    public static <M extends AbstractContainerMenu, S extends AbstractContainerScreen<M>> void registerScreenTransition(ResourceLocation location, Class<S> screenClass, ScreenBasedTargetGetter<M, S> getter, ScreenReopener<M, S> reopener) {
        AccessoriesScreenTransitionHelper.registerScreenTransition(location, screenClass::isInstance, getter, reopener);
        AccessoriesScreenTransitionHelper.registerScreensForButton(screenClass);
    }

    public static void registerScreenTransition(ResourceLocation location, Predicate<AbstractContainerScreen<AbstractContainerMenu>> screenPredicate, ScreenBasedTargetGetter<AbstractContainerMenu, AbstractContainerScreen<AbstractContainerMenu>> targetEntityGetter, ScreenReopener<AbstractContainerMenu, AbstractContainerScreen<AbstractContainerMenu>> reopener) {
        SCREEN_PREDICATES.put(screenPredicate, new ScreenTransitionHelper(location, targetEntityGetter, reopener));
    }

    @ApiStatus.Internal
    public static Class<AbstractContainerScreen>[] getScreenClasses() {
        return (Class[])List.copyOf(SCREEN_CLASSES).toArray(Class[]::new);
    }

    @ApiStatus.Internal
    @Nullable
    public static MenuButtonInjection getInjection(AbstractContainerScreen<AbstractContainerMenu> screen) {
        if (!INITIALIZED_INJECTIONS) {
            AccessoriesScreenTransitionHelper.initInjections();
        }
        if (screen.equals((Object)prevScreen)) {
            return prevInjection;
        }
        MenuButtonInjection injection = null;
        ScreenTransitionHelper info = null;
        try {
            ResourceLocation typeLocation = BuiltInRegistries.MENU.getKey((Object)screen.getMenu().getType());
            injection = BUTTON_INJECTION_DATA.get(typeLocation);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (injection == null && (info = AccessoriesScreenTransitionHelper.getInfo(screen)) != null) {
            injection = BUTTON_INJECTION_DATA.get(info.location());
        }
        prevScreen = screen;
        prevInjection = injection;
        prevScreenInfo = info;
        return injection;
    }

    @Nullable
    private static ScreenTransitionHelper getInfo(AbstractContainerScreen<AbstractContainerMenu> screen) {
        for (Map.Entry<Predicate<AbstractContainerScreen<AbstractContainerMenu>>, ScreenTransitionHelper> entry : SCREEN_PREDICATES.entrySet()) {
            if (!entry.getKey().test(screen)) continue;
            return entry.getValue();
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static LivingEntity getTargetEntity(AbstractContainerScreen<AbstractContainerMenu> screen) {
        if (prevScreenInfo == null) {
            return null;
        }
        return prevScreenInfo.getter().getTarget(screen);
    }

    @ApiStatus.Internal
    @Nullable
    public static LivingEntity getTargetEntity(LocalPlayer player) {
        for (PlayerBasedTargetGetter targetGetter : SCREENLESS_TARGET_GETTERS) {
            LivingEntity target = targetGetter.getTarget(player);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    @ApiStatus.Internal
    public static void openPrevScreen(Player player, LivingEntity targetEntity, @Nullable AbstractContainerScreen<AbstractContainerMenu> screen) {
        if (screen != null) {
            ScreenTransitionHelper info = AccessoriesScreenTransitionHelper.getInfo(screen);
            if (info != null && info.reopener.reopenScreen(player, targetEntity, screen)) {
                return;
            }
        } else {
            if (Accessories.config().screenOptions.backButtonClosesScreen()) {
                Minecraft.getInstance().setScreen(null);
                return;
            }
            for (ScreenOpener screenOpener : SCREEN_OPENERS) {
                if (!screenOpener.openScreen(player, targetEntity)) continue;
                return;
            }
        }
        Minecraft.getInstance().setScreen((Screen)new InventoryScreen(player));
        player.containerMenu = player.inventoryMenu;
        AccessoriesNetworking.sendToServer(new ContainerClose());
    }

    @ApiStatus.Internal
    public static void init() {
        AccessoriesScreenTransitionHelper.registerPlayerScreenTransition(ResourceLocation.withDefaultNamespace((String)"creative_player_inventory"), CreativeModeInventoryScreen.class);
        AccessoriesScreenTransitionHelper.registerPlayerScreenTransition(ResourceLocation.withDefaultNamespace((String)"player_inventory"), InventoryScreen.class);
        AccessoriesScreenTransitionHelper.registerScreenTransitionWithCustomInvReopener(ResourceLocation.withDefaultNamespace((String)"horse_inventory"), HorseInventoryScreen.class, screen -> ((HorseInventoryMenuAccessor)screen.getMenu()).accessories$horse());
        AccessoriesScreenTransitionHelper.registerTargetGetter(player -> {
            AbstractHorse abstractHorse;
            Entity patt0$temp = player.getVehicle();
            return patt0$temp instanceof AbstractHorse ? (abstractHorse = (AbstractHorse)patt0$temp) : null;
        });
        AccessoriesScreenTransitionHelper.registerScreenOpener(ScreenOpener.CUSTOM_INVENTORY);
    }

    public static void initInjections() {
        Consumer<List<MenuButtonInjection>> consumer = injections -> {
            BUTTON_INJECTION_DATA.clear();
            injections.forEach(injection -> BUTTON_INJECTION_DATA.putIfAbsent(injection.menuType(), (MenuButtonInjection)injection));
            ((MenuButtonInjectionCallback)EVENT.invoker()).registerInjections(BUTTON_INJECTION_DATA::putIfAbsent);
        };
        Accessories.config().screenOptions.subscribeToMenuButtonInjections(consumer);
        consumer.accept(Accessories.config().screenOptions.menuButtonInjections());
        INITIALIZED_INJECTIONS = true;
    }

    private record ScreenTransitionHelper(ResourceLocation location, ScreenBasedTargetGetter<AbstractContainerMenu, AbstractContainerScreen<AbstractContainerMenu>> getter, ScreenReopener<AbstractContainerMenu, AbstractContainerScreen<AbstractContainerMenu>> reopener) {
    }

    public static interface MenuButtonInjectionCallback {
        public void registerInjections(BiConsumer<ResourceLocation, MenuButtonInjection> var1);
    }
}

