/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.core;

import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryNestUtils;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.events.DropRule;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.TriState;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.Nullable;

public interface AccessoryNest
extends Accessory {
    public static boolean isNest(ItemStack holderStack) {
        return AccessoryRegistry.getAccessoryOrDefault(holderStack) instanceof AccessoryNest;
    }

    default public List<ItemStack> getInnerStacks(ItemStack holderStack) {
        AccessoryNestContainerContents data = (AccessoryNestContainerContents)holderStack.get(AccessoriesDataComponents.NESTED_ACCESSORIES);
        return data == null ? List.of() : data.accessories();
    }

    default public boolean setInnerStack(ItemStack holderStack, int index, ItemStack newStack) {
        if (!AccessoryNest.isNest(holderStack)) {
            return false;
        }
        if (AccessoryNest.isNest(newStack) && !this.allowDeepRecursion()) {
            return false;
        }
        holderStack.update(AccessoriesDataComponents.NESTED_ACCESSORIES, (Object)new AccessoryNestContainerContents(List.of()), contents -> contents.setStack(index, newStack));
        return true;
    }

    default public boolean allowDeepRecursion() {
        return false;
    }

    default public List<Pair<DropRule, ItemStack>> getDropRules(ItemStack stack, SlotReference reference, DamageSource source) {
        ArrayList<Pair<DropRule, ItemStack>> innerRules = new ArrayList<Pair<DropRule, ItemStack>>();
        List<ItemStack> innerStacks = this.getInnerStacks(stack);
        for (int i = 0; i < innerStacks.size(); ++i) {
            ItemStack innerStack = innerStacks.get(i);
            DropRule rule = AccessoryRegistry.getAccessoryOrDefault(innerStack).getDropRule(innerStack, SlotPath.cloneWithInnerIndex(reference, i), source);
            innerRules.add((Pair<DropRule, ItemStack>)Pair.of((Object)((Object)rule), (Object)innerStack));
        }
        return innerRules;
    }

    default public void onStackChanges(ItemStack holderStack, AccessoryNestContainerContents data, @Nullable LivingEntity livingEntity) {
    }

    @Override
    default public void onBreak(ItemStack stack, SlotReference reference) {
        AccessoryNestUtils.consumeEntries(stack, reference, Accessory::onBreak);
    }

    @Override
    default public boolean canEquipFromUse(ItemStack stack, SlotReference reference) {
        return AccessoryNestUtils.handleEntries(stack, reference, new AccessoryNestUtils.PathedAccessoryFunction<SlotReference, TriState>(this){

            @Override
            public TriState handle(Accessory accessory, ItemStack innerStack, SlotReference innerRef) {
                return accessory.canEquipFromUse(innerStack, innerRef) ? TriState.DEFAULT : TriState.FALSE;
            }

            @Override
            public boolean isDefaulted(TriState state) {
                return state != TriState.DEFAULT;
            }
        }).toBoolean(true);
    }

    @Override
    default public void onEquipFromUse(ItemStack stack, SlotReference reference) {
        AccessoryNestUtils.consumeEntries(stack, reference, Accessory::onEquipFromUse);
    }

    @Override
    default public void tick(ItemStack stack, SlotReference reference) {
        AccessoryNestUtils.consumeEntries(stack, reference, Accessory::tick);
    }

    @Override
    default public void onEquip(ItemStack stack, SlotReference reference) {
        AccessoryNestUtils.consumeEntries(stack, reference, Accessory::onEquip);
    }

    @Override
    default public void onUnequip(ItemStack stack, SlotReference reference) {
        AccessoryNestUtils.consumeEntries(stack, reference, Accessory::onUnequip);
    }

    @Override
    default public boolean canEquip(ItemStack stack, SlotReference reference) {
        return AccessoryNestUtils.handleEntries(stack, reference, (accessory, innerStack, innerRef) -> accessory.canEquip(innerStack, (SlotReference)innerRef) ? null : Boolean.valueOf(false));
    }

    @Override
    default public boolean canUnequip(ItemStack stack, SlotReference reference) {
        if (EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
            Player player;
            LivingEntity livingEntity = reference.entity();
            return livingEntity instanceof Player && (player = (Player)livingEntity).isCreative();
        }
        return AccessoryNestUtils.handleEntries(stack, reference, (accessory, innerStack, innerRef) -> accessory.canUnequip(innerStack, (SlotReference)innerRef) ? null : Boolean.valueOf(false));
    }

    @Override
    default public void getDynamicModifiers(ItemStack stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        AccessoryNestUtils.consumeEntries(stack, reference, (accessory, innerStack, innerRef) -> accessory.getDynamicModifiers(innerStack, (SlotReference)innerRef, new AccessoryAttributeBuilder(innerRef, builder)));
    }

    @Override
    default public void getAttributesTooltip(ItemStack stack, SlotType type, List<Component> tooltips, Item.TooltipContext tooltipContext, TooltipFlag tooltipType) {
        AccessoryNestUtils.consumeEntries(stack, (accessory, innerStack) -> accessory.getAttributesTooltip(innerStack, type, tooltips, tooltipContext, tooltipType));
    }

    @Override
    default public void getExtraTooltip(ItemStack stack, List<Component> tooltips, Item.TooltipContext tooltipContext, TooltipFlag tooltipType) {
        AccessoryNestUtils.consumeEntries(stack, (accessory, innerStack) -> accessory.getExtraTooltip(innerStack, tooltips, tooltipContext, tooltipType));
    }

    @Deprecated(forRemoval=true)
    public static boolean checkIfChangesOccurred(ItemStack holderStack, @Nullable LivingEntity livingEntity, AccessoryNestContainerContents data) {
        return AccessoryNestUtils.checkIfChangesOccurred(holderStack, livingEntity, data);
    }

    @Deprecated(forRemoval=true)
    public static <T> T attemptFunction(ItemStack holderStack, SlotReference slotReference, Function<Map<SlotEntryReference, Accessory>, T> func, T defaultValue) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(holderStack);
        if (data == null) {
            return defaultValue;
        }
        T t = func.apply(data.getMap(slotReference));
        AccessoryNestUtils.checkIfChangesOccurred(holderStack, null, data);
        return t;
    }

    @Deprecated(forRemoval=true)
    public static <T> T attemptFunction(ItemStack holderStack, @Nullable LivingEntity livingEntity, Function<Map<ItemStack, Accessory>, T> func, T defaultValue) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(holderStack);
        if (data == null) {
            return defaultValue;
        }
        T t = func.apply(data.getMap());
        AccessoryNestUtils.checkIfChangesOccurred(holderStack, livingEntity, data);
        return t;
    }

    @Deprecated(forRemoval=true)
    public static void attemptConsumer(ItemStack holderStack, SlotReference slotReference, Consumer<Map<SlotEntryReference, Accessory>> consumer) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(holderStack);
        if (data == null) {
            return;
        }
        consumer.accept(data.getMap(slotReference));
        AccessoryNestUtils.checkIfChangesOccurred(holderStack, slotReference.entity(), data);
    }

    @Deprecated(forRemoval=true)
    public static void attemptConsumer(ItemStack holderStack, @Nullable LivingEntity livingEntity, Consumer<Map<ItemStack, Accessory>> consumer) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(holderStack);
        if (data == null) {
            return;
        }
        consumer.accept(data.getMap());
        AccessoryNestUtils.checkIfChangesOccurred(holderStack, livingEntity, data);
    }

    @Deprecated(forRemoval=true)
    public static boolean isAccessoryNest(ItemStack holderStack) {
        return AccessoryNest.isNest(holderStack);
    }

    @Override
    @Deprecated(forRemoval=true)
    default public boolean canEquipFromUse(ItemStack stack) {
        return AccessoryNestUtils.handleEntries(stack, new AccessoryNestUtils.AccessoryFunction<TriState>(this){

            @Override
            public TriState handle(Accessory accessory, ItemStack innerStack) {
                return accessory.canEquipFromUse(innerStack) ? TriState.DEFAULT : TriState.FALSE;
            }

            @Override
            public boolean isDefaulted(TriState state) {
                return state != TriState.DEFAULT;
            }
        }).toBoolean(true);
    }
}

