/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.core;

import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryNest;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.events.SlotStateChange;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.pond.stack.PatchedDataComponentMapExtension;
import java.util.List;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AccessoryNestUtils {
    @Nullable
    public static AccessoryNestContainerContents getData(ItemStack stack) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        if (!(accessory instanceof AccessoryNest)) {
            return null;
        }
        return (AccessoryNestContainerContents)stack.get(AccessoriesDataComponents.NESTED_ACCESSORIES);
    }

    public static boolean checkIfChangesOccurred(ItemStack holderStack, @Nullable LivingEntity livingEntity, AccessoryNestContainerContents data) {
        boolean hasChangeOccurred = false;
        List<ItemStack> accessories = data.accessories();
        boolean isNest = AccessoryNest.isNest(holderStack);
        for (int i = 0; i < accessories.size(); ++i) {
            AccessoryNestContainerContents innerData;
            PatchedDataComponentMapExtension extension;
            ItemStack stack = accessories.get(i);
            DataComponentMap dataComponentMap = stack.getComponents();
            if (dataComponentMap instanceof PatchedDataComponentMapExtension && (extension = (PatchedDataComponentMapExtension)dataComponentMap).accessories$hasChanged()) {
                hasChangeOccurred = true;
            } else if (data.slotChanges().containsKey(i)) {
                hasChangeOccurred = true;
            } else if (isNest && (innerData = AccessoryNestUtils.getData(stack)) != null && (hasChangeOccurred = AccessoryNestUtils.checkIfChangesOccurred(stack, livingEntity, innerData))) break;
            if (!hasChangeOccurred) continue;
            data.slotChanges().putIfAbsent(i, SlotStateChange.MUTATION);
        }
        if (hasChangeOccurred && isNest) {
            AccessoryNest nest = (AccessoryNest)AccessoryRegistry.getAccessoryOrDefault(holderStack);
            holderStack.set(AccessoriesDataComponents.NESTED_ACCESSORIES, (Object)data);
            nest.onStackChanges(holderStack, data, livingEntity);
        }
        return hasChangeOccurred;
    }

    @Nullable
    public static <T, S extends SlotPath> T recursivelyHandle(ItemStack stack, S reference, PathedStackFunction<S, T> function) {
        return AccessoryNestUtils.recursivelyHandle(stack, reference, function);
    }

    @Nullable
    public static <T, S extends SlotPath> T recursivelyHandle(ItemStack stack, S reference, PathedAccessoryFunction<S, T> function) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        Object value = function.handle(accessory, stack, reference);
        if (accessory instanceof AccessoryNest && value == null) {
            value = AccessoryNestUtils.handleEntries(stack, reference, (ItemStack innerStack, S innerRef) -> AccessoryNestUtils.recursivelyHandle(innerStack, innerRef, function));
        }
        return value;
    }

    @Nullable
    public static <T, S extends SlotPath> T handleEntries(ItemStack stack, S reference, PathedAccessoryFunction<S, T> function) {
        return (T)AccessoryNestUtils.handleEntries(stack, reference, (ItemStack innerStack, S innerRef) -> function.handle(AccessoryRegistry.getAccessoryOrDefault(innerStack), innerStack, innerRef));
    }

    @Nullable
    public static <T, S extends SlotPath> T handleEntries(ItemStack stack, S reference, PathedStackFunction<S, T> function) {
        Object value = null;
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(stack);
        if (data != null) {
            value = data.iterateStacks((i, innerStack) -> function.handle((ItemStack)innerStack, (Object)SlotPath.cloneWithInnerIndex(reference, i)));
            if (reference instanceof SlotReference) {
                SlotReference ref = (SlotReference)reference;
                AccessoryNestUtils.checkIfChangesOccurred(stack, ref.entity(), data);
            }
        }
        return (T)value;
    }

    public static <S extends SlotPath> void recursivelyConsume(ItemStack stack, S reference, PathedStackConsumer<S> consumer) {
        AccessoryNestUtils.recursivelyConsume(stack, reference, consumer);
    }

    public static <S extends SlotPath> void recursivelyConsume(ItemStack stack, S reference, PathedAccessoryConsumer<S> consumer) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        consumer.handle(accessory, stack, reference);
        if (!(accessory instanceof AccessoryNest)) {
            return;
        }
        AccessoryNestUtils.consumeEntries(stack, reference, (ItemStack innerStack, S innerRef) -> AccessoryNestUtils.recursivelyConsume(innerStack, innerRef, consumer));
    }

    public static <S extends SlotPath> void consumeEntries(ItemStack stack, S reference, PathedAccessoryConsumer<S> consumer) {
        AccessoryNestUtils.consumeEntries(stack, reference, (ItemStack innerStack, S innerRef) -> consumer.handle(AccessoryRegistry.getAccessoryOrDefault(innerStack), innerStack, innerRef));
    }

    public static <S extends SlotPath> void consumeEntries(ItemStack stack, S reference, PathedStackConsumer<S> consumer) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(stack);
        if (data == null) {
            return;
        }
        data.iterateStacks((i, innerStack) -> consumer.handle((ItemStack)innerStack, (Object)SlotPath.cloneWithInnerIndex(reference, i)));
        if (!(reference instanceof SlotReference)) {
            return;
        }
        SlotReference ref = (SlotReference)reference;
        AccessoryNestUtils.checkIfChangesOccurred(stack, ref.entity(), data);
    }

    @Nullable
    public static <T> T recursivelyHandle(ItemStack stack, StackFunction<T> function) {
        return (T)AccessoryNestUtils.recursivelyHandle(stack, (Accessory accessory, ItemStack innerStack) -> function.handle(innerStack));
    }

    @Nullable
    public static <T> T recursivelyHandle(ItemStack stack, AccessoryFunction<T> function) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        function.handle(accessory, stack);
        if (!(accessory instanceof AccessoryNest)) {
            return null;
        }
        return (T)AccessoryNestUtils.handleEntries(stack, (ItemStack innerStack) -> AccessoryNestUtils.recursivelyHandle(innerStack, function));
    }

    @Nullable
    public static <T> T handleEntries(ItemStack stack, AccessoryFunction<T> function) {
        return (T)AccessoryNestUtils.handleEntries(stack, (ItemStack innerStack) -> function.handle(AccessoryRegistry.getAccessoryOrDefault(innerStack), innerStack));
    }

    @Nullable
    public static <T> T handleEntries(ItemStack stack, StackFunction<T> function) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(stack);
        if (data == null) {
            return null;
        }
        T value = null;
        for (ItemStack innerStack : data.accessories()) {
            if (!innerStack.isEmpty() && (value = (T)function.handle(innerStack)) != null) break;
        }
        return value;
    }

    public static void recursivelyConsume(ItemStack stack, StackConsumer consumer) {
        AccessoryNestUtils.recursivelyConsume(stack, (Accessory accessory, ItemStack innerStack) -> consumer.handle(innerStack));
    }

    public static void recursivelyConsume(ItemStack stack, AccessoryConsumer consumer) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        consumer.handle(accessory, stack);
        if (!(accessory instanceof AccessoryNest)) {
            return;
        }
        AccessoryNestUtils.consumeEntries(stack, (ItemStack innerStack) -> AccessoryNestUtils.recursivelyConsume(innerStack, consumer));
    }

    public static void consumeEntries(ItemStack stack, AccessoryConsumer consumer) {
        AccessoryNestUtils.consumeEntries(stack, (ItemStack innerStack) -> consumer.handle(AccessoryRegistry.getAccessoryOrDefault(innerStack), innerStack));
    }

    public static void consumeEntries(ItemStack stack, StackConsumer consumer) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(stack);
        if (data == null) {
            return;
        }
        data.accessories().forEach(innerStack -> {
            if (!innerStack.isEmpty()) {
                consumer.handle((ItemStack)innerStack);
            }
        });
    }

    public static interface PathedAccessoryFunction<S extends SlotPath, T>
    extends DefaultBehavior<T> {
        @Nullable
        public T handle(Accessory var1, ItemStack var2, S var3);
    }

    public static interface PathedStackFunction<S extends SlotPath, T>
    extends PathedAccessoryFunction<S, T> {
        @Override
        @Nullable
        default public T handle(Accessory accessory, ItemStack innerStack, S innerRef) {
            return this.handle(innerStack, innerRef);
        }

        @Nullable
        public T handle(ItemStack var1, S var2);
    }

    public static interface PathedAccessoryConsumer<S extends SlotPath> {
        public void handle(Accessory var1, ItemStack var2, S var3);
    }

    public static interface PathedStackConsumer<S extends SlotPath>
    extends PathedAccessoryConsumer<S> {
        @Override
        default public void handle(Accessory accessory, ItemStack innerStack, S innerRef) {
            this.handle(innerStack, innerRef);
        }

        public void handle(ItemStack var1, S var2);
    }

    public static interface StackFunction<T>
    extends AccessoryFunction<T> {
        @Override
        @Nullable
        default public T handle(Accessory accessory, ItemStack innerStack) {
            return this.handle(innerStack);
        }

        @Nullable
        public T handle(ItemStack var1);
    }

    public static interface AccessoryFunction<T>
    extends DefaultBehavior<T> {
        @Nullable
        public T handle(Accessory var1, ItemStack var2);
    }

    public static interface StackConsumer
    extends AccessoryConsumer {
        @Override
        default public void handle(Accessory accessory, ItemStack innerStack) {
            this.handle(innerStack);
        }

        public void handle(ItemStack var1);
    }

    public static interface AccessoryConsumer {
        public void handle(Accessory var1, ItemStack var2);
    }

    public static interface DefaultBehavior<T> {
        default public boolean isDefaulted(@Nullable T t) {
            return t == null;
        }
    }
}

