/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.slot;

import com.mojang.serialization.Codec;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.slot.DelegatingSlotPath;
import io.wispforest.accessories.api.slot.SlotPathImpl;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.CodecUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.include.com.google.common.base.Objects;

public sealed interface SlotPath
permits SlotPathImpl, DelegatingSlotPath {
    public static final StructEndec<SlotPath> ENDEC = StructEndecBuilder.of((StructField)Endec.STRING.fieldOf("slot_name", SlotPath::slotName), (StructField)Endec.VAR_INT.fieldOf("index", SlotPath::index), EndecUtils.optionalFieldOf(Endec.VAR_INT.listOf(), "inner_indices", SlotPath::innerIndices, List::of, List::isEmpty), SlotPath::of);
    public static final Codec<SlotPath> CODEC = CodecUtils.toCodec(ENDEC);
    public static final StreamCodec<? extends FriendlyByteBuf, SlotPath> STREAM_CODEC = CodecUtils.toPacketCodec(ENDEC);

    public String slotName();

    public int index();

    public List<Integer> innerIndices();

    public boolean isNested();

    public static SlotPath of(SlotType slotType, int index) {
        return SlotPath.of(slotType.name(), index);
    }

    public static SlotPath of(String name, int index) {
        return new SlotPathImpl(name, index, List.of());
    }

    public static SlotPath of(String name, int index, Integer ... innerIndices) {
        return SlotPath.of(name, index, List.of(innerIndices));
    }

    public static SlotPath of(String name, int index, List<Integer> innerIndices) {
        List<Integer> finalInnerIndices = Collections.unmodifiableList(innerIndices);
        if (innerIndices.isEmpty()) {
            return SlotPath.of(name, index);
        }
        return new SlotPathImpl(name, index, finalInnerIndices);
    }

    public static SlotPath withInnerIndex(SlotPath basePath, int innerIndex) {
        ArrayList<Integer> innerSlotIndices = new ArrayList<Integer>();
        if (basePath.isNested()) {
            innerSlotIndices.addAll(basePath.innerIndices());
        }
        innerSlotIndices.add(innerIndex);
        return SlotPath.of(basePath.slotName(), basePath.index(), innerSlotIndices);
    }

    public static <S extends SlotPath> S clone(S path) {
        if (path instanceof SlotReference) {
            SlotReference slotReference = (SlotReference)path;
            return (S)SlotReference.of(slotReference.entity(), slotReference.slotPath());
        }
        return path;
    }

    public static <S extends SlotPath> S cloneWithInnerIndex(S basePath, int innerIndex) {
        SlotPath newPath = SlotPath.withInnerIndex(basePath, innerIndex);
        if (basePath instanceof SlotReference) {
            SlotReference slotReference = (SlotReference)basePath;
            return (S)SlotReference.of(slotReference.entity(), slotReference.slotPath());
        }
        return (S)newPath;
    }

    @Nullable
    public static SlotPath fromString(String path) {
        String[] parts = path.split("/");
        if (parts.length <= 1) {
            return null;
        }
        String baseSlotName = parts[0].replace("-", ":");
        int index = Integer.parseInt(parts[1]);
        return SlotPath.of(baseSlotName, index);
    }

    default public String createString() {
        return this.toLocation().toString().replace(":", "-");
    }

    default public ResourceLocation toLocation() {
        String[] parts = this.slotName().split(":");
        ResourceLocation location = parts.length == 1 ? Accessories.of(parts[0]) : ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)this.slotName().replace(parts[0] + ":", ""));
        location = location.withSuffix("/" + this.index());
        List<Integer> innerSlotIndices = this.innerIndices();
        if (!innerSlotIndices.isEmpty()) {
            for (int i = 0; i < innerSlotIndices.size(); ++i) {
                location = location.withSuffix("/nest_" + i + "_" + String.valueOf(innerSlotIndices.get(i)));
            }
        }
        return location;
    }

    public static String createBaseSlotPath(SlotType slotType, int index) {
        return SlotPath.createBaseSlotPath(slotType.name(), index);
    }

    public static String createBaseSlotPath(String name, int index) {
        return SlotPath.of(name, index).createString();
    }

    public static boolean areEqual(SlotPath path, SlotPath otherPath) {
        if (path instanceof SlotReference) {
            SlotReference ref = (SlotReference)path;
            if (otherPath instanceof SlotReference) {
                SlotReference otherRef = (SlotReference)otherPath;
                if (ref.entity() != otherRef.entity()) {
                    return false;
                }
            }
        }
        return path.slotName().equals(otherPath.slotName()) && path.index() == otherPath.index() && path.innerIndices().equals(otherPath.innerIndices()) && path.isNested() == otherPath.isNested();
    }

    public static int createHashCode(SlotPath path) {
        return Objects.hashCode((Object[])new Object[]{path.slotName(), path.index(), path.innerIndices(), path.isNested()});
    }
}

