/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.slot;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.events.DropRule;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public interface SlotType
extends Comparable<SlotType> {
    public static final ResourceLocation EMPTY_SLOT_ICON = Accessories.of("gui/slot/empty");

    public String name();

    default public ResourceLocation getId() {
        return Accessories.parseLocationOrDefault(this.name());
    }

    default public String translation() {
        return Accessories.translationKey("slot." + this.name().replace(":", "."));
    }

    public ResourceLocation icon();

    public int order();

    public int amount();

    public Set<ResourceLocation> validators();

    public DropRule dropRule();

    @Override
    default public int compareTo(@NotNull SlotType o) {
        int value = Integer.compare(this.order(), o.order());
        if (value != 0) {
            return value;
        }
        return this.name().compareTo(o.name());
    }

    default public String dumpData() {
        return "SlotType[, name:'" + this.name() + "', icon:" + String.valueOf(this.icon() == EMPTY_SLOT_ICON ? "none" : this.icon()) + ", amount:" + this.amount() + ", order:" + this.order() + ", validators:" + String.valueOf(this.validators()) + ", dropRule:" + String.valueOf((Object)this.dropRule()) + ", translation:" + this.translation() + "]";
    }
}

