/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.mojang.blaze3d.platform.Window;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesClientInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.screen.AccessoriesScreenTransitionHelper;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.client.ClientLifecycleEvents;
import io.wispforest.accessories.client.DrawUtils;
import io.wispforest.accessories.client.EntityTarget;
import io.wispforest.accessories.client.gui.AccessoriesScreenBase;
import io.wispforest.accessories.client.gui.components.AccessoriesScreenSettingsLayout;
import io.wispforest.accessories.client.gui.components.ComponentUtils;
import io.wispforest.accessories.compat.config.MenuButtonInjection;
import io.wispforest.accessories.compat.config.client.ExtendedConfigScreen;
import io.wispforest.accessories.compat.config.client.Structured;
import io.wispforest.accessories.compat.config.client.components.StructListOptionContainer;
import io.wispforest.accessories.compat.config.client.components.StructOptionContainer;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.PlayerEquipControl;
import io.wispforest.accessories.impl.option.AccessoriesPlayerOptionsHolder;
import io.wispforest.accessories.impl.option.PlayerOptions;
import io.wispforest.accessories.impl.option.PlayerOptionsAccess;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.mixin.owo.ConfigWrapperAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.holder.SyncOptionChange;
import io.wispforest.accessories.networking.server.ScreenOpen;
import io.wispforest.accessories.pond.TooltipFlagExtension;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import io.wispforest.owo.config.ui.ConfigScreenProviders;
import io.wispforest.owo.config.ui.OptionComponentFactory;
import io.wispforest.owo.config.ui.OptionComponents;
import io.wispforest.owo.config.ui.component.OptionValueProvider;
import io.wispforest.owo.config.ui.component.SearchAnchorComponent;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.layers.Layers;
import io.wispforest.owo.util.NumberReflection;
import io.wispforest.owo.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;

public class AccessoriesClient {
    public static final KeyMapping.Category KEY_CATEGORY = KeyMapping.Category.register((ResourceLocation)Accessories.of("main"));
    public static final KeyMapping OPEN_SCREEN = new KeyMapping("accessories.key.open_accessories_screen", 72, KEY_CATEGORY);
    public static final Event<WindowResizeCallback> WINDOW_RESIZE_CALLBACK_EVENT = EventFactory.createArrayBacked(WindowResizeCallback.class, callbacks -> (client, window) -> {
        for (WindowResizeCallback callback : callbacks) {
            callback.onResized(client, window);
        }
    });
    public static boolean IS_PLAYER_INVISIBLE = false;
    private static final boolean IS_OSX = Util.getPlatform() == Util.OS.OSX;
    private static final int EDIT_SHORTCUT_KEY_MODIFIER = IS_OSX ? 8 : 2;
    private static boolean displayUnusedSlotWarning = false;

    public static void initConfigStuff() {
        ConfigScreenProviders.register((String)"accessories", ExtendedConfigScreen.buildFunc(Accessories.config(), (config, factoryRegister) -> {
            factoryRegister.registerTypedFactory(AccessoriesPlayerOptionsHolder.class, (model, option) -> {
                FlowLayout optionComponent = (FlowLayout)model.expandTemplate(FlowLayout.class, "boolean-toggle-config-option", OptionComponents.packParameters((String)option.translationKey(), (String)Objects.toString(option.value())));
                final MutableObject holderValue = new MutableObject((Object)AccessoriesPlayerOptionsHolder.createOrCopy((AccessoriesPlayerOptionsHolder)option.value()));
                ButtonComponent resetButton = ((ButtonComponent)optionComponent.childById(ButtonComponent.class, "reset-button")).onPress(button -> {
                    holderValue.setValue((Object)AccessoriesPlayerOptionsHolder.createOrCopy((AccessoriesPlayerOptionsHolder)option.defaultValue()));
                    button.active = false;
                });
                final Runnable checkResetButton = () -> {
                    resetButton.active = holderValue.getValue() != null && !((AccessoriesPlayerOptionsHolder)holderValue.getValue()).isDefaultedValues();
                };
                checkResetButton.run();
                FlowLayout btnLayout = (FlowLayout)optionComponent.childById(FlowLayout.class, "controls-flow");
                ButtonComponent tempBtn = (ButtonComponent)optionComponent.childById(ButtonComponent.class, "toggle-button");
                btnLayout.removeChild((io.wispforest.owo.ui.core.Component)tempBtn);
                ButtonComponent toggleButton = (ButtonComponent)Components.button((Component)Component.literal((String)"Edit"), btn -> {}).verticalSizing((Sizing)tempBtn.verticalSizing().get()).horizontalSizing((Sizing)tempBtn.horizontalSizing().get());
                btnLayout.child(0, (io.wispforest.owo.ui.core.Component)toggleButton);
                toggleButton.onPress(btn -> {
                    final Screen currentScreen = Minecraft.getInstance().screen;
                    BaseOwoScreen<FlowLayout> newScreen = new BaseOwoScreen<FlowLayout>(){

                        @NotNull
                        protected OwoUIAdapter<FlowLayout> createAdapter() {
                            return OwoUIAdapter.create((Screen)this, Containers::verticalFlow);
                        }

                        protected void build(FlowLayout rootComponent) {
                            rootComponent.child((io.wispforest.owo.ui.core.Component)Containers.verticalFlow((Sizing)Sizing.fixed((int)178), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)14)).child((io.wispforest.owo.ui.core.Component)Containers.horizontalFlow((Sizing)Sizing.expand(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)Components.label((Component)Component.literal((String)"Default Screen Options"))).horizontalAlignment(HorizontalAlignment.LEFT)).child(Components.button((Component)Component.literal((String)"Back"), btn -> this.onClose()).verticalSizing(Sizing.fixed((int)14))).verticalAlignment(VerticalAlignment.CENTER)).child((io.wispforest.owo.ui.core.Component)Containers.verticalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.fixed((int)186)).child((io.wispforest.owo.ui.core.Component)new AccessoriesScreenSettingsLayout((PlayerOptionsAccess)holderValue.getValue(), (x$0, x$1) -> this.component(x$0, x$1)).shouldNetworkSync(false).updateLive(true)).padding(Insets.of((int)1)).surface(ComponentUtils.getInsetPanelSurface())).gap(3).padding(Insets.of((int)7)).surface(ComponentUtils.getPanelSurface()));
                            rootComponent.surface(Surface.optionsBackground()).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER);
                        }

                        public void onClose() {
                            checkResetButton.run();
                            Minecraft.getInstance().setScreen(currentScreen);
                        }
                    };
                    Minecraft client = Minecraft.getInstance();
                    client.screen = newScreen;
                    client.screen.added();
                    client.mouseHandler.releaseMouse();
                    KeyMapping.releaseAll();
                    newScreen.init(client, client.getWindow().getGuiScaledWidth(), client.getWindow().getGuiScaledHeight());
                    client.noRender = false;
                });
                optionComponent.child((io.wispforest.owo.ui.core.Component)new SearchAnchorComponent((ParentComponent)optionComponent, option.key(), new Supplier[]{() -> ((LabelComponent)optionComponent.childById(LabelComponent.class, "option-name")).text().getString(), () -> toggleButton.getMessage().getString()}));
                return new OptionComponentFactory.Result((io.wispforest.owo.ui.core.Component)optionComponent, new OptionValueProvider(){

                    public boolean isValid() {
                        return true;
                    }

                    public Object parsedValue() {
                        return holderValue.getValue();
                    }
                });
            });
            factoryRegister.registerFactory(option -> {
                Field field = option.backingField().field();
                if (field.getType() != List.class) {
                    return false;
                }
                Class listType = ReflectionUtils.getTypeArgument((Type)field.getGenericType(), (int)0);
                if (listType == null) {
                    return false;
                }
                return String.class != listType && !NumberReflection.isNumberType((Class)listType);
            }, (uiModel, option) -> {
                StructListOptionContainer layout = new StructListOptionContainer(uiModel, option);
                return new OptionComponentFactory.Result(layout, layout);
            });
            ReflectiveEndecBuilder builder = ((ConfigWrapperAccessor)config).accessories$builder();
            factoryRegister.registerFactory(option -> option.backingField().field().isAnnotationPresent(Structured.class), (model, option) -> {
                Structured annotationData = option.backingField().field().getAnnotation(Structured.class);
                MutableComponent title = Component.translatable((String)("text.config." + option.configName() + ".option." + option.key().asString()));
                FlowLayout titleLayout = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
                titleLayout.padding(Insets.of((int)5, (int)5, (int)5, (int)0));
                title = title.copy().withStyle(ChatFormatting.UNDERLINE);
                titleLayout.child((io.wispforest.owo.ui.core.Component)Components.label((Component)title));
                StructOptionContainer component = StructOptionContainer.of(model, option, builder, annotationData.sideBySide());
                titleLayout.child((io.wispforest.owo.ui.core.Component)new SearchAnchorComponent((ParentComponent)titleLayout, option.key(), new Supplier[]{() -> I18n.get((String)("text.config." + option.configName() + ".option." + option.key().asString()), (Object[])new Object[0]), () -> component.parsedValue().toString()}));
                FlowLayout mainLayout = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
                mainLayout.child((io.wispforest.owo.ui.core.Component)titleLayout).child((io.wispforest.owo.ui.core.Component)component);
                return new OptionComponentFactory.Result((io.wispforest.owo.ui.core.Component)mainLayout, (OptionValueProvider)component);
            });
        }));
        Accessories.config().clientOptions.subscribeToEquipControl(value -> AccessoriesClient.attemptAction(holder -> {
            if (holder.getDefaultedData(PlayerOptions.EQUIP_CONTROL) == value) {
                return;
            }
            AccessoriesNetworking.sendToServer(SyncOptionChange.of(PlayerOptions.EQUIP_CONTROL, value));
        }));
        Accessories.config().screenOptions.subscribeToShowUnusedSlots(value -> AccessoriesClient.attemptAction(holder -> {
            if (holder.getDefaultedData(PlayerOptions.SHOW_UNUSED_SLOTS) == value) {
                return;
            }
            AccessoriesNetworking.sendToServer(SyncOptionChange.of(PlayerOptions.SHOW_UNUSED_SLOTS, value));
        }));
        Accessories.config().screenOptions.subscribeToAlwaysShowCraftingGrid(value -> AccessoriesClient.attemptAction(holder -> {
            if (holder.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID) == value) {
                return;
            }
            AccessoriesNetworking.sendToServer(SyncOptionChange.of(PlayerOptions.SHOW_CRAFTING_GRID, value));
        }));
    }

    public static void init() {
        AccessoriesClientInternals.setInstance(new AccessoriesClientInternals(){

            @Override
            public TooltipFlag createTooltipFlag(TooltipFlag flag) {
                Minecraft client = Minecraft.getInstance();
                int modifiers = (client.hasShiftDown() ? 1 : 0) | (client.hasControlDown() ? EDIT_SHORTCUT_KEY_MODIFIER : 0) | (client.hasAltDown() ? 4 : 0);
                return TooltipFlagExtension.createFlag(flag, modifiers);
            }
        });
        ClientLifecycleEvents.END_DATA_PACK_RELOAD.register((client, success) -> {
            if (!success) {
                return;
            }
            BuiltInRegistries.ITEM.forEach(item -> {
                ItemStack defaultStack = item.getDefaultInstance();
                if ((item instanceof BannerItem || defaultStack.has(DataComponents.GLIDER)) && !AccessoriesRendererRegistry.hasRenderer(item)) {
                    AccessoriesRendererRegistry.bindItemToEmptyRenderer(item);
                }
            });
            AccessoriesRendererRegistry.onReload();
        });
        AccessoriesClient.initLayer();
    }

    public static void openScreenFromKey() {
        Minecraft minecraft = Minecraft.getInstance();
        Screen currentScreen = minecraft.screen;
        if (currentScreen instanceof AccessoriesScreenBase) {
            minecraft.setScreen(null);
        } else if (currentScreen == null) {
            AccessoriesClient.attemptToOpenScreen(minecraft.player.isShiftKeyDown() ? EntityTarget.LOOKING_ENTITY : EntityTarget.PLAYER);
        } else {
            LocalPlayer targetEntity = null;
            if (currentScreen instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)currentScreen;
                targetEntity = AccessoriesScreenTransitionHelper.getTargetEntity((AbstractContainerScreen<AbstractContainerMenu>)containerScreen);
            }
            if (targetEntity == null) {
                targetEntity = minecraft.player;
            }
            AccessoriesClient.attemptToOpenScreenFromEntity(targetEntity);
        }
    }

    private static void attemptAction(Consumer<AccessoriesPlayerOptionsHolder> consumer) {
        LocalPlayer currentPlayer = Minecraft.getInstance().player;
        if (currentPlayer == null || Minecraft.getInstance().level == null) {
            return;
        }
        AccessoriesPlayerOptionsHolder options = AccessoriesPlayerOptionsHolder.getOptions((Player)currentPlayer);
        if (options != null) {
            consumer.accept(options);
        }
    }

    public static void initalConfigDataSync() {
        LocalPlayer currentPlayer = Minecraft.getInstance().player;
        if (currentPlayer == null || Minecraft.getInstance().level == null) {
            return;
        }
        AccessoriesPlayerOptionsHolder options = AccessoriesPlayerOptionsHolder.getOptions((Player)currentPlayer);
        if (options == null) {
            return;
        }
        PlayerEquipControl equipControl = Accessories.config().clientOptions.equipControl();
        if (options.getDefaultedData(PlayerOptions.EQUIP_CONTROL) != equipControl) {
            AccessoriesNetworking.sendToServer(PlayerOptions.EQUIP_CONTROL.toPacket(equipControl));
        }
        boolean showUnusedSlots = Accessories.config().screenOptions.showUnusedSlots();
        if (options.getDefaultedData(PlayerOptions.SHOW_UNUSED_SLOTS) != showUnusedSlots) {
            AccessoriesNetworking.sendToServer(PlayerOptions.SHOW_UNUSED_SLOTS.toPacket(showUnusedSlots));
        }
        boolean alwaysShowCraftingGrid = Accessories.config().screenOptions.alwaysShowCraftingGrid();
        if (options.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID) != alwaysShowCraftingGrid) {
            AccessoriesNetworking.sendToServer(PlayerOptions.SHOW_CRAFTING_GRID.toPacket(true));
        }
    }

    public static boolean attemptToOpenScreen(EntityTarget entityTarget) {
        LivingEntity targetEntity;
        LocalPlayer player = Minecraft.getInstance().player;
        LivingEntity livingEntity = targetEntity = Accessories.config().screenOptions.keybindIgnoresOtherTargets() ? null : AccessoriesScreenTransitionHelper.getTargetEntity(player);
        if (targetEntity == null) {
            EntityHitResult entitResult;
            Entity entity;
            HitResult result;
            if (entityTarget.equals((Object)EntityTarget.PLAYER)) {
                return AccessoriesClient.attemptToOpenScreenFromEntity((LivingEntity)player);
            }
            if (entityTarget.equals((Object)EntityTarget.LOOKING_ENTITY) && (result = ProjectileUtil.getHitResultOnViewVector((Entity)player, e -> e instanceof LivingEntity, (double)player.entityInteractionRange())) instanceof EntityHitResult && (entity = (entitResult = (EntityHitResult)result).getEntity()) instanceof LivingEntity) {
                LivingEntity living;
                targetEntity = living = (LivingEntity)entity;
            }
        }
        if (targetEntity != null && !EntitySlotLoader.getEntitySlots(targetEntity).isEmpty()) {
            return AccessoriesClient.attemptToOpenScreenFromEntity(targetEntity);
        }
        return false;
    }

    public static boolean attemptToOpenScreenFromEntity(LivingEntity targetingEntity) {
        ItemStack itemStack;
        LocalPlayer player = Minecraft.getInstance().player;
        if (targetingEntity.equals((Object)player)) {
            Collection<SlotType> slots = AccessoriesCapability.getUsedSlotsFor((Player)player);
            AccessoriesPlayerOptionsHolder options = AccessoriesPlayerOptionsHolder.getOptions((Player)player);
            if (slots.isEmpty() && !options.getDefaultedData(PlayerOptions.SHOW_UNUSED_SLOTS).booleanValue() && !displayUnusedSlotWarning && !Accessories.config().clientOptions.disableEmptySlotScreenError()) {
                player.displayClientMessage((Component)Component.literal((String)"[Accessories]: No Used Slots found by any mod directly, the screen will show empty unless a item is found to implement slots!"), false);
                displayUnusedSlotWarning = true;
            }
        }
        AccessoriesMenuVariant selectedVariant = AccessoriesMenuVariant.PRIMARY_V2;
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen screen2 = (CreativeModeInventoryScreen)screen;
            itemStack = ((CreativeModeInventoryScreen.ItemPickerMenu)screen2.getMenu()).getCarried();
        } else {
            itemStack = null;
        }
        ItemStack creativeCarriedStack = itemStack;
        AccessoriesNetworking.sendToServer(ScreenOpen.of(targetingEntity, selectedVariant, creativeCarriedStack));
        return true;
    }

    public static void attemptToOpenSelectionScreen(int entityId, boolean targetLookEntity, Player player) {
        ItemStack itemStack;
        AccessoriesMenuVariant selectedVariant = AccessoriesMenuVariant.PRIMARY_V2;
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen screen2 = (CreativeModeInventoryScreen)screen;
            itemStack = ((CreativeModeInventoryScreen.ItemPickerMenu)screen2.getMenu()).getCarried();
        } else {
            itemStack = null;
        }
        ItemStack creativeCarriedStack = itemStack;
        Function<AccessoriesMenuVariant, ScreenOpen> packetBuilder = menuVariant -> new ScreenOpen(targetLookEntity ? -1 : entityId, targetLookEntity, (AccessoriesMenuVariant)((Object)menuVariant), creativeCarriedStack);
        AccessoriesNetworking.sendToServer(packetBuilder.apply(selectedVariant));
    }

    public static void initLayer() {
        AccessoriesScreenTransitionHelper.init();
        Layers.add(Containers::verticalFlow, instance -> {
            instance.aggressivePositioning = true;
            ((FlowLayout)instance.adapter.rootComponent).allowOverflow(true);
            MenuButtonInjection injectionData = AccessoriesScreenTransitionHelper.getInjection((AbstractContainerScreen<AbstractContainerMenu>)((AbstractContainerScreen)instance.screen));
            if (injectionData == null) {
                return;
            }
            ButtonComponent button = (ButtonComponent)Components.button((Component)Component.literal((String)""), btn -> {
                LivingEntity target = AccessoriesScreenTransitionHelper.getTargetEntity((AbstractContainerScreen<AbstractContainerMenu>)((AbstractContainerScreen)instance.screen));
                if (target == null) {
                    target = Minecraft.getInstance().player;
                }
                AccessoriesClient.attemptToOpenScreenFromEntity(target);
            }).renderer((context, btn, delta) -> DrawUtils.blit((GuiGraphics)context, Accessories.of("textures/gui/accessories_open_icon" + (btn.isHovered() ? "_hovered" : "") + ".png"), btn.x(), btn.y(), 0.0f, 0.0f, 8, 8, 8, 8)).tooltip((Component)Component.translatable((String)Accessories.translationKey("open.screen"))).margins(Insets.of((int)1, (int)0, (int)0, (int)1)).sizing(Sizing.fixed((int)8));
            if (instance.screen instanceof CreativeModeInventoryScreen) {
                ComponentUtils.CreativeScreenExtension extension = (ComponentUtils.CreativeScreenExtension)instance.screen;
                button.visible = extension.getTab().getType().equals((Object)CreativeModeTab.Type.INVENTORY);
                extension.getEvent().register(tab -> {
                    button.visible = tab.getType().equals((Object)CreativeModeTab.Type.INVENTORY);
                });
            }
            ((FlowLayout)instance.adapter.rootComponent).child((io.wispforest.owo.ui.core.Component)button);
            instance.alignComponentToHandledScreenCoordinates((io.wispforest.owo.ui.core.Component)button, injectionData.xOffset(), injectionData.yOffset());
        }, (Class[])AccessoriesScreenTransitionHelper.getScreenClasses());
    }

    public static interface WindowResizeCallback {
        public void onResized(Minecraft var1, Window var2);
    }
}

