/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.wispforest.accessories.Accessories;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.OwoUIPipelines;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class AccessoriesPipelines {
    public static final RenderType.CompositeRenderType HSV_GUI = RenderType.create((String)"accessories:hsv_gui", (int)786432, (RenderPipeline)OwoUIPipelines.GUI_HSV, (RenderType.CompositeState)RenderType.CompositeState.builder().createCompositeState(false));
    public static final RenderPipeline.Snippet SPECTRUM_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.MATRICES_PROJECTION_SNIPPET}).withFragmentShader(Accessories.of("core/spectrum_position_tex")).withVertexShader(Accessories.of("core/spectrum_position_tex")).withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS).withBlend(BlendFunction.TRANSLUCENT).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).withSampler("InputSampler").buildSnippet();
    public static final RenderPipeline SPECTRUM = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{SPECTRUM_SNIPPET}).withLocation(Accessories.of("pipeline/spectrum")).build();
    public static final Function<ResourceLocation, RenderType> SPECTRUM_GUI = Util.memoize(resourceLocation -> RenderType.create((String)"accessories:spectrum_gui", (int)786432, (RenderPipeline)SPECTRUM, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false)).createCompositeState(false)));
    public static final RenderPipeline COLORED_GUI_TEXTURED_PIPE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.GUI_TEXTURED_SNIPPET}).withLocation(Accessories.of("pipeline/colored_gui_textured")).withColorWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).withBlend(new BlendFunction(SourceFactor.ONE, DestFactor.ONE)).build();
    public static final BiFunction<Color, ResourceLocation, RenderType> COLORED_GUI_TEXTURED = Util.memoize((color, resourceLocation) -> RenderType.create((String)"accessories:colored_gui_textured", (int)786432, (RenderPipeline)COLORED_GUI_TEXTURED_PIPE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false)).createCompositeState(false)));
    private static TextureTarget BUFFER = null;
    private static Color SHADER_COLOR = null;

    public static void registerPipelines(Consumer<RenderPipeline> pipelineRegister) {
        pipelineRegister.accept(SPECTRUM);
        pipelineRegister.accept(COLORED_GUI_TEXTURED_PIPE);
    }

    public static TextureTarget getOrCreateBuffer() {
        try {
            if (BUFFER == null) {
                Window window = Minecraft.getInstance().getWindow();
                BUFFER = new TextureTarget("accessories_buffer_thingy", window.getWidth(), window.getHeight(), true);
                WindowResizeCallback.EVENT.register((innerClient, innerWindow) -> {
                    if (BUFFER == null) {
                        return;
                    }
                    BUFFER.resize(innerWindow.getWidth(), innerWindow.getHeight());
                });
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create the buffer for Accessories Hover Rendering due to an error!", e);
        }
        return BUFFER;
    }
}

