/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui.components;

import com.mojang.math.Axis;
import io.wispforest.owo.ui.component.EntityComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.renderstate.EntityElementRenderState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class InventoryEntityComponent<E extends Entity>
extends EntityComponent<E> {
    private float startingRotation = -45.0f;
    private float lastBbWidth = 0.0f;
    private float lastBbHeight = 0.0f;
    private ScaleFitType type = ScaleFitType.NONE;
    private boolean sideBySideMode = false;
    private int additionalOffset = 0;
    public float xOffset = 0.0f;
    public float yOffset = 0.0f;
    private TriConsumer<OwoUIDrawContext, Component, List<Runnable>> renderWrapping = (ctx, component, runnables) -> runnables.forEach(Runnable::run);

    public InventoryEntityComponent(Sizing horizontalSizing, Sizing verticalSizing, E entity) {
        super(Sizing.fixed((int)0), entity);
        this.horizontalSizing(horizontalSizing).verticalSizing(verticalSizing);
        this.lastBbWidth = entity.getBbWidth();
        this.lastBbHeight = entity.getBbHeight();
    }

    public InventoryEntityComponent(Sizing horizontalSizing, Sizing verticalSizing, EntityType<E> type, @Nullable CompoundTag nbt) {
        super(Sizing.fixed((int)0), type, nbt);
        this.horizontalSizing(horizontalSizing).verticalSizing(verticalSizing);
        this.lastBbWidth = this.entity.getBbWidth();
        this.lastBbHeight = this.entity.getBbHeight();
    }

    public static <E extends Entity> InventoryEntityComponent<E> of(Sizing horizontalSizing, Sizing verticalSizing, E entity) {
        return new InventoryEntityComponent<E>(horizontalSizing, verticalSizing, entity);
    }

    public boolean sideBySideMode() {
        return this.sideBySideMode;
    }

    public InventoryEntityComponent<E> sideBySideMode(boolean sideBySideMode) {
        this.sideBySideMode = sideBySideMode;
        return this;
    }

    public int additionalOffset() {
        return this.additionalOffset;
    }

    public InventoryEntityComponent<E> additionalOffset(int value) {
        this.additionalOffset = value;
        return this;
    }

    private float getEntityScale() {
        float f;
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            f = living.getScale();
        } else {
            f = 1.0f;
        }
        return f;
    }

    public InventoryEntityComponent<E> renderWrapping(TriConsumer<OwoUIDrawContext, Component, List<Runnable>> renderWrapping) {
        this.renderWrapping = renderWrapping;
        return this;
    }

    public float getSingleInstanceWidth() {
        return (float)((Sizing)this.horizontalSizing().get()).value / (this.sideBySideMode ? 2.0f : 1.0f) - (float)(this.sideBySideMode ? 25 : 40);
    }

    public InventoryEntityComponent<E> scaleToFit(boolean scaleToFit) {
        if (scaleToFit) {
            float componentHeight = ((Sizing)this.verticalSizing().get()).value;
            float componentWidth = this.getSingleInstanceWidth();
            float entityHeight = this.entity.getBbHeight() * (Math.min(componentWidth, componentHeight) / Math.max(componentWidth, componentHeight));
            float entityWidth = this.entity.getBbWidth() * (Math.max(componentWidth, componentHeight) / Math.min(componentWidth, componentHeight));
            float length = Math.max(entityHeight, entityWidth);
            float baseScale = 0.35f / length;
            this.scale(baseScale);
            this.type = ScaleFitType.BOTH;
        } else {
            this.scale(1.0f);
            this.type = ScaleFitType.NONE;
        }
        return this;
    }

    public InventoryEntityComponent<E> startingRotation(float value) {
        this.startingRotation = value;
        return this;
    }

    public InventoryEntityComponent<E> scaleToFitVertically(boolean scaleToFit) {
        this.scale(scaleToFit ? 0.5f / this.entity.getBbHeight() : 1.0f);
        this.type = scaleToFit ? ScaleFitType.VERTICAL : ScaleFitType.NONE;
        return this;
    }

    public InventoryEntityComponent<E> scaleToFitHorizontally(boolean scaleToFit) {
        this.scale(scaleToFit ? 0.5f / this.entity.getBbWidth() : 1.0f);
        this.type = scaleToFit ? ScaleFitType.HORIZONTAL : ScaleFitType.NONE;
        return this;
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        Entity entity = this.entity;
        if (!(entity instanceof LivingEntity)) {
            super.draw(context, mouseX, mouseY, partialTicks, delta);
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (this.lastBbWidth != this.entity.getBbWidth() || this.lastBbHeight != this.entity.getBbHeight()) {
            switch (this.type.ordinal()) {
                case 0: {
                    this.scaleToFitVertically(true);
                    break;
                }
                case 1: {
                    this.scaleToFitHorizontally(true);
                    break;
                }
                case 2: {
                    this.scaleToFit(true);
                    break;
                }
            }
            this.lastBbWidth = this.entity.getBbWidth();
            this.lastBbHeight = this.entity.getBbHeight();
        }
        ArrayList<Runnable> renderQueue = new ArrayList<Runnable>();
        renderQueue.add(() -> {
            context.push();
            this.renderLiving(context, living, mouseX, mouseY, partialTicks, true);
            context.pop();
        });
        if (this.sideBySideMode) {
            renderQueue.add(() -> {
                context.push();
                this.renderLiving(context, living, mouseX, mouseY, partialTicks, false);
                context.pop();
            });
        }
        this.renderWrapping.accept((Object)context, (Object)this, renderQueue);
    }

    private void renderLiving(OwoUIDrawContext context, LivingEntity living, int mouseX, int mouseY, float partialTicks, boolean isLeftSide) {
        Matrix4f matrix = new Matrix4f();
        this.transformMatrixStack(matrix, isLeftSide);
        this.transform.accept(matrix);
        float prevYBodyRot0 = living.yBodyRotO;
        float prevYBodyRot = living.yBodyRot;
        float prevYRot = living.getYRot();
        float prevYRot0 = living.yRotO;
        float prevXRot = living.getXRot();
        float prevXRot0 = living.xRotO;
        float prevYHeadRot0 = living.yHeadRotO;
        float prevYHeadRot = living.yHeadRot;
        this.rotateMatrixStack(matrix, living, mouseX, mouseY, isLeftSide);
        living.yBodyRotO = 0.0f;
        living.yBodyRot = 0.0f;
        living.setYRot(0.0f);
        living.yHeadRot = living.yBodyRot;
        living.yHeadRotO = living.yBodyRotO;
        EntityRenderer renderer = this.manager.getRenderer(this.entity);
        EntityRenderState entityState = renderer.createRenderState(this.entity, partialTicks);
        entityState.x = 0.0;
        entityState.y = 0.0;
        entityState.z = 0.0;
        if (this.showNametag) {
            entityState.nameTag = this.entity.getDisplayName();
            entityState.nameTagAttachment = this.entity.getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, this.entity.getYRot(partialTicks));
        } else {
            entityState.nameTag = null;
            entityState.nameTagAttachment = null;
        }
        entityState.lightCoords = 0xF000F0;
        entityState.hitboxesRenderState = null;
        entityState.shadowPieces.clear();
        entityState.outlineColor = 0;
        context.guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)new EntityElementRenderState(entityState, matrix, new ScreenRectangle(this.x, this.y, this.width, this.height), context.scissorStack.peek()));
        living.yBodyRotO = prevYBodyRot0;
        living.yBodyRot = prevYBodyRot;
        living.setYRot(prevYRot);
        living.yRotO = prevYRot0;
        living.setXRot(prevXRot);
        living.xRotO = prevXRot0;
        living.yHeadRotO = prevYHeadRot0;
        living.yHeadRot = prevYHeadRot;
    }

    private void transformMatrixStack(Matrix4f matrix, boolean isLeftSide) {
        float trueWidth = (float)this.width / (this.sideBySideMode ? 2.0f : 1.0f);
        float maxLength = Math.max(trueWidth, (float)this.height);
        float baseScaleValue = 75.0f * this.scale;
        float xyScaleValue = baseScaleValue * maxLength / 64.0f;
        float yPos = (float)this.height / 2.0f;
        matrix.translate(this.centerOffSet(isLeftSide), -yPos, 60.0f);
        matrix.scale(xyScaleValue, -xyScaleValue, -baseScaleValue);
        matrix.translate(0.0f, this.entity.getBbHeight() / -2.0f, 0.0f);
        matrix.translate(this.xOffset * (float)(isLeftSide ? 1 : -1), this.yOffset, 0.0f);
    }

    private float centerOffSet(boolean isLeftSide) {
        return (float)this.additionalOffset * (isLeftSide ? -2.3f : 2.3f);
    }

    private void rotateMatrixStack(Matrix4f matrix, LivingEntity living, int mouseX, int mouseY, boolean isLeftSide) {
        float rotationOffset;
        float trueWidth = (float)this.width / (this.sideBySideMode ? 2.0f : 1.0f);
        float xRotation = (float)Math.toDegrees(Math.atan(((float)(mouseY - this.y) - (float)this.height / 2.0f) / 40.0f));
        float f = rotationOffset = !isLeftSide ? 180.0f : 0.0f;
        if (this.lookAtCursor) {
            float yRotation = (float)Math.toDegrees(Math.atan(((float)(mouseX - this.x) - (trueWidth + this.centerOffSet(isLeftSide))) / 40.0f));
            living.yHeadRotO = -yRotation;
            this.entity.yRotO = -yRotation;
            this.entity.xRotO = xRotation * 0.65f;
            this.entity.setYRot(this.entity.yRotO);
            this.entity.setXRot(this.entity.xRotO);
            if (xRotation == 0.0f) {
                xRotation = 0.1f;
            }
            matrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(xRotation * 0.35f));
            matrix.rotate((Quaternionfc)Axis.YP.rotationDegrees(yRotation * 0.555f + rotationOffset));
        } else {
            this.entity.xRotO = xRotation * 0.35f;
            this.entity.setXRot(this.entity.xRotO);
            if (xRotation == 0.0f) {
                xRotation = 0.1f;
            }
            matrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(xRotation * 0.15f));
            matrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(15.0f));
            matrix.rotate((Quaternionfc)Axis.YP.rotationDegrees(this.startingRotation + this.mouseRotation + rotationOffset));
        }
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        this.scale += (float)(amount * (double)this.scale * (double)0.1f);
        return true;
    }

    public boolean onKeyPress(KeyEvent input) {
        int keycode = input.key();
        if (keycode == 263) {
            this.xOffset -= 0.05f;
        } else if (keycode == 262) {
            this.xOffset += 0.05f;
        }
        if (keycode == 265) {
            this.yOffset += 0.05f;
        } else if (keycode == 264) {
            this.yOffset -= 0.05f;
        }
        return super.onKeyPress(input);
    }

    public static enum ScaleFitType {
        VERTICAL,
        HORIZONTAL,
        BOTH,
        NONE;

    }
}

